/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.docker.proxy.BuildInfoProxy;
import org.jfrog.hudson.pipeline.docker.proxy.CertManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ArtifactoryBuilder
extends GlobalConfiguration {

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalConfiguration> {
        private boolean useCredentialsPlugin;
        private List<ArtifactoryServer> artifactoryServers;
        private boolean pushToBintrayEnabled = true;
        private boolean buildInfoProxyEnabled = false;
        private int buildInfoProxyPort;
        private String buildInfoProxyCertPublic;
        private String buildInfoProxyCertPrivate;

        public DescriptorImpl() {
            super(ArtifactoryBuilder.class);
            this.initDefaultCertPaths();
            this.load();
        }

        private void initDefaultCertPaths() {
            if (StringUtils.isNotEmpty((String)this.buildInfoProxyCertPublic) || StringUtils.isNotEmpty((String)this.buildInfoProxyCertPrivate)) {
                return;
            }
            File jenkinsHome = new File(Jenkins.getInstance().getRootDir().getPath());
            File publicCert = new File(jenkinsHome, CertManager.DEFAULT_RELATIVE_CERT_PATH);
            File privateCert = new File(jenkinsHome, CertManager.DEFAULT_RELATIVE_KEY_PATH);
            this.buildInfoProxyCertPublic = publicCert.getPath();
            this.buildInfoProxyCertPrivate = privateCert.getPath();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project, ACL.SYSTEM);
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServerId(@QueryParameter String value, @QueryParameter String artifactoryUrl, @QueryParameter String username, @QueryParameter String password, @QueryParameter String credentialsId) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set server ID");
            }
            List<ArtifactoryServer> artifactoryServers = RepositoriesUtils.getArtifactoryServers();
            if (artifactoryServers == null) {
                return FormValidation.ok();
            }
            int countServersByValueAsName = 0;
            for (ArtifactoryServer server : artifactoryServers) {
                if (!server.getName().equals(value) || ++countServersByValueAsName <= 1) continue;
                return FormValidation.error((String)"Duplicated server ID");
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public FormValidation doTestConnection(@QueryParameter(value="artifactoryUrl") String url, @QueryParameter(value="artifactory.timeout") String timeout, @QueryParameter(value="artifactory.bypassProxy") boolean bypassProxy, @QueryParameter(value="useCredentialsPlugin") boolean useLegacyCredentials, @QueryParameter(value="credentialsId") String deployerCredentialsId, @QueryParameter(value="username") String deployerCredentialsUsername, @QueryParameter(value="password") String deployerCredentialsPassword, @QueryParameter(value="connectionRetry") int connectionRetry) throws ServletException {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"Please set a valid Artifactory URL");
            }
            if (connectionRetry < 0) {
                return FormValidation.error((String)"Connection Retries can not be less then 0");
            }
            Credentials credentials = PluginsUtils.credentialsLookup(deployerCredentialsId, null);
            String username = useLegacyCredentials ? credentials.getUsername() : deployerCredentialsUsername;
            String password = useLegacyCredentials ? credentials.getPassword() : deployerCredentialsPassword;
            try (ArtifactoryBuildInfoClient client = StringUtils.isNotBlank((String)username) ? new ArtifactoryBuildInfoClient(url, username, password, (Log)new NullLog()) : new ArtifactoryBuildInfoClient(url, (Log)new NullLog());){
                ArtifactoryVersion version;
                if (!bypassProxy && Jenkins.getInstance().proxy != null) {
                    client.setProxyConfiguration(RepositoriesUtils.createProxyConfiguration(Jenkins.getInstance().proxy));
                }
                if (StringUtils.isNotBlank((String)timeout)) {
                    client.setConnectionTimeout(Integer.parseInt(timeout));
                }
                RepositoriesUtils.setRetryParams(connectionRetry, (ArtifactoryBaseClient)client);
                try {
                    version = client.verifyCompatibleArtifactoryVersion();
                }
                catch (UnsupportedOperationException uoe) {
                    FormValidation formValidation = FormValidation.warning((String)uoe.getMessage());
                    client.close();
                    return formValidation;
                }
                catch (Exception e) {
                    FormValidation formValidation = FormValidation.error((String)e.getMessage());
                    client.close();
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.ok((String)("Found Artifactory " + version.toString()));
                return formValidation;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }

        public String getDisplayName() {
            return "Artifactory Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.useCredentialsPlugin = (Boolean)o.get("useCredentialsPlugin");
            this.pushToBintrayEnabled = (Boolean)o.get("pushToBintrayEnabled");
            try {
                this.configureProxy((JSONObject)o.get("buildInfoProxyEnabled"));
            }
            catch (IOException e) {
                throw new Descriptor.FormException((Throwable)e, e.getMessage());
            }
            catch (InterruptedException e) {
                throw new Descriptor.FormException((Throwable)e, e.getMessage());
            }
            Object servers = o.get("artifactoryServer");
            List artifactoryServers = !JSONNull.getInstance().equals(servers) ? req.bindJSONToList(ArtifactoryServer.class, servers) : null;
            if (!this.isServerIDConfigured(artifactoryServers)) {
                throw new Descriptor.FormException("Please set the Artifactory server ID.", "ServerID");
            }
            if (this.isServerDuplicated(artifactoryServers)) {
                throw new Descriptor.FormException("The Artifactory server ID you have entered is already configured", "Server ID");
            }
            this.setArtifactoryServers(artifactoryServers);
            this.save();
            return super.configure(req, o);
        }

        private synchronized void configureProxy(JSONObject proxyConfig) throws IOException, InterruptedException {
            if (proxyConfig == null) {
                BuildInfoProxy.stopAll();
                this.buildInfoProxyEnabled = false;
                return;
            }
            int portFromForm = Integer.parseInt(proxyConfig.get("buildInfoProxyPort").toString());
            if (!this.buildInfoProxyEnabled || portFromForm != this.buildInfoProxyPort) {
                BuildInfoProxy.startAll(portFromForm);
                this.buildInfoProxyEnabled = true;
                this.buildInfoProxyPort = portFromForm;
            }
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return this.artifactoryServers;
        }

        public boolean getUseCredentialsPlugin() {
            return this.useCredentialsPlugin;
        }

        public void setArtifactoryServers(List<ArtifactoryServer> artifactoryServers) {
            this.artifactoryServers = artifactoryServers;
        }

        public void setUseCredentialsPlugin(boolean useCredentialsPlugin) {
            this.useCredentialsPlugin = useCredentialsPlugin;
        }

        public boolean isPushToBintrayEnabled() {
            return this.pushToBintrayEnabled;
        }

        public boolean isBuildInfoProxyEnabled() {
            return this.buildInfoProxyEnabled && StringUtils.isNotEmpty((String)this.getBuildInfoProxyCertPublic()) && StringUtils.isNotEmpty((String)this.getBuildInfoProxyCertPrivate());
        }

        public String getBuildInfoProxyCertPublic() {
            if (new File(this.buildInfoProxyCertPublic).exists()) {
                return this.buildInfoProxyCertPublic;
            }
            return "";
        }

        public String getBuildInfoProxyCertPrivate() {
            if (new File(this.buildInfoProxyCertPrivate).exists()) {
                return this.buildInfoProxyCertPrivate;
            }
            return "";
        }

        @JavaScriptMethod
        public Pair<String, String> generateCerts(String buildInfoProxyPort) {
            if (this.isProxyCertExist().booleanValue()) {
                return null;
            }
            int port = Integer.parseInt(buildInfoProxyPort);
            CertManager.createCertificateSource(this.buildInfoProxyCertPublic, this.buildInfoProxyCertPrivate);
            try {
                BuildInfoProxy.startAll(port);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.buildInfoProxyPort = port;
            return Pair.of((Object)this.buildInfoProxyCertPublic, (Object)this.buildInfoProxyCertPrivate);
        }

        private Boolean isProxyCertExist() {
            File buildInfoProxyCertPublicFile = new File(this.buildInfoProxyCertPublic);
            File buildInfoProxyCertPrivateFile = new File(this.buildInfoProxyCertPrivate);
            if (buildInfoProxyCertPublicFile.exists() || buildInfoProxyCertPrivateFile.exists()) {
                return true;
            }
            return false;
        }

        public int getBuildInfoProxyPort() {
            return this.buildInfoProxyPort;
        }

        private boolean isServerDuplicated(List<ArtifactoryServer> artifactoryServers) {
            HashSet<String> serversNames = new HashSet<String>();
            if (artifactoryServers == null) {
                return false;
            }
            for (ArtifactoryServer server : artifactoryServers) {
                String name = server.getName();
                if (serversNames.contains(name)) {
                    return true;
                }
                serversNames.add(name);
            }
            return false;
        }

        private boolean isServerIDConfigured(List<ArtifactoryServer> artifactoryServers) {
            if (artifactoryServers == null) {
                return true;
            }
            for (ArtifactoryServer server : artifactoryServers) {
                String name = server.getName();
                if (!StringUtils.isBlank((String)name)) continue;
                return false;
            }
            return true;
        }
    }
}

