/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.aquaserverlessscannerbuildstep;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.aquaserverlessscannerbuildstep.AquaScannerAction;
import org.jenkinsci.plugins.aquaserverlessscannerbuildstep.ScannerExecuter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AquaServerlessScannerBuilder
extends Builder
implements SimpleBuildStep {
    public static final int OK_CODE = 0;
    public static final int DISALLOWED_CODE = 4;
    private final String onDisallowed;
    private final String notCompliesCmd;
    private final String codeScanPath;
    private final String customFlags;
    private static int count;
    private static int buildId;

    public static synchronized void setCount(int count) {
        AquaServerlessScannerBuilder.count = count;
    }

    public static synchronized void setBuildId(int buildId) {
        AquaServerlessScannerBuilder.buildId = buildId;
    }

    @DataBoundConstructor
    public AquaServerlessScannerBuilder(String onDisallowed, String notCompliesCmd, String codeScanPath, String customFlags) {
        this.onDisallowed = onDisallowed;
        this.notCompliesCmd = notCompliesCmd;
        this.codeScanPath = codeScanPath;
        this.customFlags = customFlags;
    }

    public String getOnDisallowed() {
        return this.onDisallowed;
    }

    public String getNotCompliesCmd() {
        return this.notCompliesCmd;
    }

    public String getCodeScanPath() {
        return this.codeScanPath;
    }

    public String getCustomFlags() {
        return this.customFlags;
    }

    public String isOnDisallowed(String state) {
        if (this.onDisallowed == null) {
            return "ignore".equals(state) ? "true" : "false";
        }
        return this.onDisallowed.equals(state) ? "true" : "false";
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException, InterruptedException {
        String artifactName;
        String artifactSuffix;
        String apiServerlessUrl = this.getDescriptor().getApiServerlessUrl();
        String serverlessUser = this.getDescriptor().getServerlessUser();
        String serverlessPassword = this.getDescriptor().getServerlessPassword();
        String serverlessBinaryUrl = this.getDescriptor().getServerlessBinaryUrl();
        String serverlessBinaryUser = this.getDescriptor().getServerlessBinaryUser();
        String serverlessBinaryPassword = this.getDescriptor().getServerlessBinaryPassword();
        if (apiServerlessUrl == null || apiServerlessUrl.trim().equals("") || serverlessUser == null || serverlessUser.trim().equals("") || serverlessPassword == null || serverlessPassword.trim().equals("")) {
            throw new AbortException("Missing configuration. Please set the global configuration parameters in The \"Aqua Security\" section under  \"Manage Jenkins/Configure System\", before continuing.\n");
        }
        if (apiServerlessUrl.indexOf("://") == -1) {
            apiServerlessUrl = "https://" + apiServerlessUrl;
        }
        if (build.hashCode() != buildId) {
            AquaServerlessScannerBuilder.setBuildId(build.hashCode());
            AquaServerlessScannerBuilder.setCount(1);
            artifactSuffix = null;
            artifactName = "scanout.html";
        } else {
            AquaServerlessScannerBuilder.setCount(count + 1);
            artifactSuffix = Integer.toString(count);
            artifactName = "scanout-" + artifactSuffix + ".html";
        }
        int exitCode = ScannerExecuter.execute(build, workspace, launcher, listener, artifactName, apiServerlessUrl, serverlessUser, serverlessPassword, this.notCompliesCmd, this.codeScanPath, this.customFlags, serverlessBinaryUrl, serverlessBinaryUser, serverlessBinaryPassword, this.onDisallowed);
        build.addAction((Action)new AquaScannerAction(build, artifactSuffix, artifactName));
        this.archiveArtifacts(build, workspace, launcher, listener);
        System.out.println("exitCode: " + exitCode);
        String failedMessage = "Scanning failed.";
        switch (exitCode) {
            case 0: {
                System.out.println("Scanning success.");
                break;
            }
            case 4: {
                throw new AbortException(failedMessage);
            }
            default: {
                throw new AbortException(failedMessage);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void archiveArtifacts(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException {
        ArtifactArchiver artifactArchiver = new ArtifactArchiver("scanout*");
        artifactArchiver.perform(build, workspace, launcher, listener);
        ArtifactArchiver styleArtifactArchiver = new ArtifactArchiver("styles.css");
        styleArtifactArchiver.perform(build, workspace, launcher, listener);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static {
        buildId = 0;
    }

    @Symbol(value={"aquaServerlessScanner"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private Secret apiServerlessUrl;
        private Secret serverlessUser;
        private Secret serverlessPassword;
        private Secret serverlessBinaryUrl;
        private Secret serverlessBinaryUser;
        private Secret serverlessBinaryPassword;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) throws IOException, ServletException {
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Must be a number");
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Aqua Serverless Security";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.apiServerlessUrl = Secret.fromString((String)formData.getString("apiServerlessUrl"));
            this.serverlessUser = Secret.fromString((String)formData.getString("serverlessUser"));
            this.serverlessPassword = Secret.fromString((String)formData.getString("serverlessPassword"));
            this.serverlessBinaryUrl = Secret.fromString((String)formData.getString("serverlessBinaryUrl"));
            this.serverlessBinaryUser = Secret.fromString((String)formData.getString("serverlessBinaryUser"));
            this.serverlessBinaryPassword = Secret.fromString((String)formData.getString("serverlessBinaryPassword"));
            this.save();
            return super.configure(req, formData);
        }

        public String getApiServerlessUrl() {
            return Secret.toString((Secret)this.apiServerlessUrl);
        }

        public String getServerlessUser() {
            return Secret.toString((Secret)this.serverlessUser);
        }

        public String getServerlessPassword() {
            return Secret.toString((Secret)this.serverlessPassword);
        }

        public String getServerlessBinaryUrl() {
            return Secret.toString((Secret)this.serverlessBinaryUrl);
        }

        public String getServerlessBinaryUser() {
            return Secret.toString((Secret)this.serverlessBinaryUser);
        }

        public String getServerlessBinaryPassword() {
            return Secret.toString((Secret)this.serverlessBinaryPassword);
        }
    }
}

