/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.jenkins.appd;

import hudson.model.AbstractBuild;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.codecentric.jenkins.appd.AppDynamicsBuildAction;
import nl.codecentric.jenkins.appd.rest.types.MetricData;
import nl.codecentric.jenkins.appd.rest.types.MetricValues;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AppDynamicsReport {
    private final Map<String, MetricData> keyedMetricDataMap = new LinkedHashMap<String, MetricData>();
    private final Long reportTimestamp;
    private final Integer reportDurationInMinutes;
    private AppDynamicsBuildAction buildAction;
    private AppDynamicsReport lastBuildReport;

    public AppDynamicsReport(Long timestamp, Integer durationInMinutes) {
        this.reportTimestamp = timestamp;
        this.reportDurationInMinutes = durationInMinutes;
    }

    public void addMetrics(MetricData metrics) {
        this.keyedMetricDataMap.put(metrics.getMetricPath(), metrics);
    }

    public MetricData getMetricByKey(String metricKey) {
        MetricData selectedMetric = this.keyedMetricDataMap.get(metricKey);
        if (selectedMetric == null) {
            throw new IllegalArgumentException("Provided Metric Key is not available, tried to select; " + metricKey);
        }
        return selectedMetric;
    }

    public List<MetricData> getMetricsList() {
        return new ArrayList<MetricData>(this.keyedMetricDataMap.values());
    }

    public double getAverageForMetric(String metricKey) {
        MetricData selectedMetric;
        try {
            selectedMetric = this.getMetricByKey(metricKey);
        }
        catch (IllegalArgumentException e) {
            return -1.0;
        }
        long calculatedSum = 0L;
        for (MetricValues value : selectedMetric.getMetricValues()) {
            calculatedSum += (long)value.getValue().intValue();
        }
        int numberOfMeasurements = selectedMetric.getMetricValues().size();
        double result = -1.0;
        if (numberOfMeasurements > 0) {
            result = (double)calculatedSum / (double)numberOfMeasurements;
        }
        return result;
    }

    public long getMaxForMetric(String metricKey) {
        MetricData selectedMetric = this.getMetricByKey(metricKey);
        long max = Long.MIN_VALUE;
        for (MetricValues value : selectedMetric.getMetricValues()) {
            max = Math.max((long)value.getMax().intValue(), max);
        }
        return max;
    }

    public long getMinForMetric(String metricKey) {
        MetricData selectedMetric = this.getMetricByKey(metricKey);
        long min = Long.MAX_VALUE;
        for (MetricValues value : selectedMetric.getMetricValues()) {
            min = Math.min((long)value.getMin().intValue(), min);
        }
        return min;
    }

    public String getName() {
        DateTimeFormatter dateTimeFormat = DateTimeFormat.mediumDateTime();
        return String.format("AppDynamics Metric Report for time %s - with a duration of %d minutes", dateTimeFormat.print(this.reportTimestamp.longValue()), this.reportDurationInMinutes);
    }

    public long getTimestamp() {
        return this.reportTimestamp;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    AppDynamicsBuildAction getBuildAction() {
        return this.buildAction;
    }

    void setBuildAction(AppDynamicsBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setLastBuildReport(AppDynamicsReport lastBuildReport) {
        this.lastBuildReport = lastBuildReport;
    }

    public AppDynamicsReport getLastBuildReport() {
        return this.lastBuildReport;
    }
}

