/*
 * Decompiled with CFR 0.152.
 */
package nl.codecentric.jenkins.appd;

import hudson.model.AbstractBuild;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Logger;
import nl.codecentric.jenkins.appd.AppDynamicsReport;
import nl.codecentric.jenkins.appd.rest.RestConnection;
import nl.codecentric.jenkins.appd.rest.types.MetricData;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class AppDynamicsDataCollector {
    private static final Logger LOG = Logger.getLogger(AppDynamicsDataCollector.class.getName());
    private static final String[] STATIC_METRIC_PATHS = new String[]{"Overall Application Performance|Average Response Time (ms)", "Overall Application Performance|Calls per Minute", "Overall Application Performance|Normal Average Response Time (ms)", "Overall Application Performance|Number of Slow Calls", "Overall Application Performance|Number of Very Slow Calls", "Overall Application Performance|Errors per Minute", "Overall Application Performance|Exceptions per Minute", "Overall Application Performance|Infrastructure Errors per Minute"};
    private final RestConnection restConnection;
    private final AbstractBuild<?, ?> build;
    private final PrintStream logger;
    private final int minimumDurationInMinutes;
    private final String[] METRIC_PATHS;

    public AppDynamicsDataCollector(RestConnection connection, AbstractBuild<?, ?> build, PrintStream logger, String customMetricPath, int minimumDurationInMinutes) {
        this.restConnection = connection;
        this.build = build;
        this.logger = logger;
        this.minimumDurationInMinutes = minimumDurationInMinutes;
        this.METRIC_PATHS = AppDynamicsDataCollector.getMergedMetricPaths(customMetricPath, false);
    }

    public static String[] getStaticMetricPaths() {
        return (String[])STATIC_METRIC_PATHS.clone();
    }

    public static String[] getMergedMetricPaths(String customMetricPath, boolean encodeCustomMetric) {
        if (StringUtils.isNotBlank((String)customMetricPath)) {
            String encodedCustomMetricPath = customMetricPath;
            if (encodeCustomMetric) {
                try {
                    encodedCustomMetricPath = URLEncoder.encode(customMetricPath, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return (String[])ArrayUtils.add((Object[])STATIC_METRIC_PATHS, (Object)encodedCustomMetricPath);
        }
        return (String[])STATIC_METRIC_PATHS.clone();
    }

    public AppDynamicsReport createReportFromMeasurements() {
        long buildStartTime = this.build.getRootBuild().getTimeInMillis();
        int durationInMinutes = this.calculateDurationToFetch(buildStartTime);
        LOG.fine(String.format("Current time: %d - Build time: %d - Duration: %d", System.currentTimeMillis(), buildStartTime, durationInMinutes));
        AppDynamicsReport adReport = new AppDynamicsReport(buildStartTime, durationInMinutes);
        for (String metricPath : this.METRIC_PATHS) {
            MetricData metric = this.restConnection.fetchMetricData(metricPath, durationInMinutes);
            if (metric != null) {
                adReport.addMetrics(metric);
                continue;
            }
            this.logger.println(String.format("No result for metric: %s %n\t--> Check if metric exists and correctly formatted.", metricPath));
        }
        return adReport;
    }

    private int calculateDurationToFetch(Long buildStartTime) {
        long duration = System.currentTimeMillis() - buildStartTime;
        int durationInMinutes = (int)(duration / 60000L);
        if (durationInMinutes < this.minimumDurationInMinutes) {
            durationInMinutes = this.minimumDurationInMinutes;
        }
        return durationInMinutes;
    }
}

