/*
 * Decompiled with CFR 0.152.
 */
package com.anchore.jenkins.plugins.anchore;

import com.anchore.jenkins.plugins.anchore.AnchoreAction;
import com.anchore.jenkins.plugins.anchore.Annotation;
import com.anchore.jenkins.plugins.anchore.BuildConfig;
import com.anchore.jenkins.plugins.anchore.ConsoleLog;
import com.anchore.jenkins.plugins.anchore.Util;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.PluginWrapper;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class BuildWorker {
    private static final Logger LOG = Logger.getLogger(BuildWorker.class.getName());
    private static final String GATES_OUTPUT_PREFIX = "anchore_gates";
    private static final String CVE_LISTING_PREFIX = "anchore_security";
    private static final String JENKINS_DIR_NAME_PREFIX = "AnchoreReport.";
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final String AE_VULNS_PREFIX = "anchoreengine-api-response-vulnerabilities-";
    private static final String AE_EVAL_PREFIX = "anchoreengine-api-response-evaluation-";
    Run<?, ?> build;
    FilePath workspace;
    Launcher launcher;
    TaskListener listener;
    BuildConfig config;
    private ConsoleLog console;
    private boolean analyzed;
    private String buildId;
    private String jenkinsOutputDirName;
    private Map<String, String> queryOutputMap;
    private Map<String, String> input_image_dfile = new LinkedHashMap<String, String>();
    private Map<String, String> input_image_imageDigest = new LinkedHashMap<String, String>();
    private String gateOutputFileName;
    private Util.GATE_ACTION finalAction;
    private JSONObject gateSummary;
    private int totalStopActionCount = 0;
    private int totalWarnActionCount = 0;
    private int totalGoActionCount = 0;
    private String cveListingFileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildWorker(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, BuildConfig config) throws AbortException {
        try {
            this.build = build;
            this.workspace = workspace;
            if (null == listener) {
                LOG.warning("Anchore Container Image Scanner plugin cannot initialize Jenkins task listener");
                throw new AbortException("Cannot initialize Jenkins task listener. Aborting step");
            }
            this.listener = listener;
            if (null == config) {
                LOG.warning("Anchore Container Image Scanner cannot find the required configuration");
                throw new AbortException("Configuration for the plugin is invalid. Configure the plugin under Manage Jenkins->Configure System->Anchore Configuration first. Add the Anchore Container Image Scanner step in your project and retry");
            }
            this.config = config;
            this.console = new ConsoleLog("AnchoreWorker", this.listener.getLogger(), this.config.getDebug());
            this.console.logDebug("Initializing build worker");
            this.launcher = workspace.createLauncher(listener);
            this.analyzed = false;
            this.printConfig();
            this.checkConfig();
            this.initializeJenkinsWorkspace();
            this.initializeAnchoreWorkspace();
            this.console.logDebug("Build worker initialized");
        }
        catch (Exception e) {
            try {
                if (this.console != null) {
                    this.console.logError("Failed to initialize worker for plugin execution", e);
                }
                this.cleanJenkinsWorkspaceQuietly();
            }
            catch (Exception exception) {}
            finally {
                throw new AbortException("Failed to initialize worker for plugin execution, check logs for corrective action");
            }
        }
    }

    public void runAnalyzer() throws AbortException {
        this.runAnalyzerEngine();
    }

    private static CloseableHttpClient makeHttpClient(boolean verify) {
        CloseableHttpClient httpclient = null;
        if (verify) {
            httpclient = HttpClients.createDefault();
        } else {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return httpclient;
    }

    private void runAnalyzerEngine() throws AbortException {
        String imageDigest = null;
        String username = this.config.getEngineuser();
        String password = this.config.getEnginepass();
        boolean sslverify = this.config.getEngineverify();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        try {
            for (Map.Entry<String, String> entry : this.input_image_dfile.entrySet()) {
                String tag = entry.getKey();
                String dfile = entry.getValue();
                ArrayList<String> queryList = new ArrayList<String>();
                String queryStr = null;
                this.console.logInfo("Submitting " + tag + " for analysis");
                CloseableHttpClient httpclient = BuildWorker.makeHttpClient(sslverify);
                Throwable throwable = null;
                try {
                    String theurl = this.config.getEngineurl().replaceAll("/+$", "") + "/images";
                    if (!this.config.getAutoSubscribeTagUpdates()) {
                        queryList.add("autosubscribe=false");
                    }
                    if (this.config.getForceAnalyze()) {
                        queryList.add("force=true");
                    }
                    if (!queryList.isEmpty()) {
                        queryStr = Joiner.on((char)'&').skipNulls().join(queryList);
                    }
                    if (!Strings.isNullOrEmpty(queryStr)) {
                        theurl = theurl + "?" + queryStr;
                    }
                    JSONObject jsonBody = new JSONObject();
                    jsonBody.put("tag", (Object)tag);
                    if (null != dfile) {
                        jsonBody.put("dockerfile", (Object)dfile);
                    }
                    if (null != this.config.getAnnotations() && !this.config.getAnnotations().isEmpty()) {
                        JSONObject annotations = new JSONObject();
                        for (Annotation a : this.config.getAnnotations()) {
                            annotations.put(a.getKey(), (Object)a.getValue());
                        }
                        jsonBody.put("annotations", (Object)annotations);
                    }
                    String body = jsonBody.toString();
                    HttpPost httppost = new HttpPost(theurl);
                    httppost.addHeader("Content-Type", "application/json");
                    httppost.setEntity((HttpEntity)new StringEntity(body));
                    this.console.logDebug("anchore-engine add image URL: " + theurl);
                    this.console.logDebug("anchore-engine add image payload: " + body);
                    CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost, (HttpContext)context);
                    Throwable throwable2 = null;
                    try {
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode != 200) {
                            String serverMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                            this.console.logError("anchore-engine add image failed. URL: " + theurl + ", status: " + response.getStatusLine() + ", error: " + serverMessage);
                            throw new AbortException("Failed to analyze " + tag + " due to error adding image to anchore-engine. Check above logs for errors from anchore-engine");
                        }
                        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                        JSONArray respJson = JSONArray.fromObject((Object)responseBody);
                        imageDigest = JSONObject.fromObject((Object)respJson.get(0)).getString("imageDigest");
                        this.console.logInfo("Analysis request accepted, received image digest " + imageDigest);
                        this.input_image_imageDigest.put(tag, imageDigest);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (response == null) continue;
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        response.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (httpclient == null) continue;
                    if (throwable != null) {
                        try {
                            httpclient.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    httpclient.close();
                }
            }
            this.analyzed = true;
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            this.console.logError("Failed to add image(s) to anchore-engine due to an unexpected error", e);
            throw new AbortException("Failed to add image(s) to anchore-engine due to an unexpected error. Please refer to above logs for more information");
        }
    }

    public Util.GATE_ACTION runGates() throws AbortException {
        return this.runGatesEngine();
    }

    private Util.GATE_ACTION runGatesEngine() throws AbortException {
        String username = this.config.getEngineuser();
        String password = this.config.getEnginepass();
        boolean sslverify = this.config.getEngineverify();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        FilePath jenkinsOutputDirFP = new FilePath(this.workspace, this.jenkinsOutputDirName);
        FilePath jenkinsGatesOutputFP = new FilePath(jenkinsOutputDirFP, this.gateOutputFileName);
        int counter = 0;
        this.finalAction = Util.GATE_ACTION.PASS;
        if (this.analyzed) {
            try {
                JSONObject gate_results = new JSONObject();
                for (Map.Entry<String, String> entry : this.input_image_imageDigest.entrySet()) {
                    int statusCode;
                    String tag = entry.getKey();
                    String imageDigest = entry.getValue();
                    this.console.logInfo("Waiting for analysis of " + tag + ", polling status periodically");
                    Boolean anchore_eval_status = false;
                    String theurl = this.config.getEngineurl().replaceAll("/+$", "") + "/images/" + imageDigest + "/check?tag=" + tag + "&detail=true";
                    if (!Strings.isNullOrEmpty((String)this.config.getPolicyBundleId())) {
                        theurl = theurl + "&policyId=" + this.config.getPolicyBundleId();
                    }
                    this.console.logDebug("anchore-engine get policy evaluation URL: " + theurl);
                    int tryCount = 0;
                    int maxCount = Integer.parseInt(this.config.getEngineRetries());
                    Boolean done = false;
                    HttpGet httpget = new HttpGet(theurl);
                    httpget.addHeader("Content-Type", "application/json");
                    String serverMessage = null;
                    boolean sleep = false;
                    do {
                        if (sleep) {
                            this.console.logDebug("Snoozing before retrying anchore-engine get policy evaluation");
                            Thread.sleep(1000L);
                            sleep = false;
                        }
                        ++tryCount;
                        try (CloseableHttpClient httpclient = BuildWorker.makeHttpClient(sslverify);){
                            this.console.logDebug("Attempting anchore-engine get policy evaluation (" + tryCount + "/" + maxCount + ")");
                            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget, (HttpContext)context);){
                                statusCode = response.getStatusLine().getStatusCode();
                                if (statusCode != 200) {
                                    serverMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                                    this.console.logDebug("anchore-engine get policy evaluation failed. URL: " + theurl + ", status: " + response.getStatusLine() + ", error: " + serverMessage);
                                    sleep = true;
                                    continue;
                                }
                                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                                JSONArray respJson = JSONArray.fromObject((Object)responseBody);
                                JSONObject tag_eval_obj = JSONObject.fromObject((Object)JSONArray.fromObject((Object)JSONArray.fromObject((Object)JSONObject.fromObject((Object)JSONObject.fromObject((Object)respJson.get(0)).getJSONObject(imageDigest)))).get(0));
                                JSONArray tag_evals = null;
                                Iterator iterator = tag_eval_obj.keySet().iterator();
                                if (iterator.hasNext()) {
                                    Object key = iterator.next();
                                    tag_evals = tag_eval_obj.getJSONArray((String)key);
                                }
                                if (null == tag_evals) {
                                    throw new AbortException("Failed to analyze " + tag + " due to missing tag eval records in anchore-engine policy evaluation response");
                                }
                                if (tag_evals.size() < 1) {
                                    this.console.logDebug("anchore-engine get policy evaluation response contains no tag eval records. May snooze and retry");
                                    sleep = true;
                                    continue;
                                }
                                String jenkinsAEResponseFileName = AE_EVAL_PREFIX + ++counter + JSON_FILE_EXTENSION;
                                FilePath jenkinsAEResponseFP = new FilePath(jenkinsOutputDirFP, jenkinsAEResponseFileName);
                                try {
                                    this.console.logDebug("Writing anchore-engine policy evaluation response to " + jenkinsAEResponseFP.getRemote());
                                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(jenkinsAEResponseFP.write(), StandardCharsets.UTF_8));){
                                        bw.write(responseBody);
                                    }
                                }
                                catch (IOException | InterruptedException e) {
                                    this.console.logWarn("Failed to write anchore-engine policy evaluation response to " + jenkinsAEResponseFP.getRemote(), e);
                                    throw new AbortException("Failed to write anchore-engine policy evaluation response to " + jenkinsAEResponseFP.getRemote());
                                }
                                String eval_status = JSONObject.fromObject((Object)JSONObject.fromObject((Object)tag_evals.get(0))).getString("status");
                                JSONObject gate_result = JSONObject.fromObject((Object)JSONObject.fromObject((Object)JSONObject.fromObject((Object)JSONObject.fromObject((Object)tag_evals.get(0)).getJSONObject("detail")).getJSONObject("result")).getJSONObject("result"));
                                this.console.logDebug("anchore-engine get policy evaluation status: " + eval_status);
                                this.console.logDebug("anchore-engine get policy evaluation result: " + gate_result.toString());
                                for (Object key : gate_result.keySet()) {
                                    try {
                                        gate_results.put((String)key, (Object)gate_result.getJSONObject((String)key));
                                    }
                                    catch (Exception e) {
                                        this.console.logDebug("Ignoring error parsing policy evaluation result key: " + key);
                                    }
                                }
                                if (eval_status.equals("pass")) {
                                    anchore_eval_status = true;
                                }
                                done = true;
                                this.console.logInfo("Completed analysis and processed policy evaluation result");
                            }
                        }
                    } while (!done.booleanValue() && tryCount < maxCount);
                    if (!done.booleanValue()) {
                        if (statusCode != 200) {
                            this.console.logWarn("anchore-engine get policy evaluation failed. HTTP method: GET, URL: " + theurl + ", status: " + statusCode + ", error: " + serverMessage);
                        }
                        this.console.logWarn("Exhausted all attempts polling anchore-engine. Analysis is incomplete for " + imageDigest);
                        throw new AbortException("Timed out waiting for anchore-engine analysis to complete (increasing engineRetries might help). Check above logs for errors from anchore-engine");
                    }
                    if (anchore_eval_status.booleanValue()) continue;
                    this.finalAction = Util.GATE_ACTION.FAIL;
                }
                try {
                    this.console.logDebug("Writing policy evaluation result to " + jenkinsGatesOutputFP.getRemote());
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(jenkinsGatesOutputFP.write(), StandardCharsets.UTF_8));){
                        bw.write(gate_results.toString());
                    }
                }
                catch (IOException | InterruptedException e) {
                    this.console.logWarn("Failed to write policy evaluation output to " + jenkinsGatesOutputFP.getRemote(), e);
                    throw new AbortException("Failed to write policy evaluation output to " + jenkinsGatesOutputFP.getRemote());
                }
                this.generateGatesSummary(gate_results);
                this.console.logInfo("Anchore Container Image Scanner Plugin step result - " + (Object)((Object)this.finalAction));
                return this.finalAction;
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                this.console.logError("Failed to execute anchore-engine policy evaluation due to an unexpected error", e);
                throw new AbortException("Failed to execute anchore-engine policy evaluation due to an unexpected error. Please refer to above logs for more information");
            }
        }
        this.console.logError("Image(s) were not added to anchore-engine (or a prior attempt to add images may have failed). Re-submit image(s) to anchore-engine before attempting policy evaluation");
        throw new AbortException("Submit image(s) to anchore-engine for analysis before attempting policy evaluation");
    }

    private void runVulnerabilityListing() throws AbortException {
        block61: {
            if (this.analyzed) {
                String username = this.config.getEngineuser();
                String password = this.config.getEnginepass();
                boolean sslverify = this.config.getEngineverify();
                FilePath jenkinsOutputDirFP = new FilePath(this.workspace, this.jenkinsOutputDirName);
                int counter = 0;
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                HttpClientContext context = HttpClientContext.create();
                context.setCredentialsProvider((CredentialsProvider)credsProvider);
                try {
                    JSONObject securityJson = new JSONObject();
                    JSONArray columnsJson = new JSONArray();
                    for (String string : Arrays.asList("Tag", "CVE ID", "Severity", "Vulnerability Package", "Fix Available", "URL")) {
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("title", (Object)string);
                        columnsJson.add((Object)jSONObject);
                    }
                    JSONArray dataJson = new JSONArray();
                    for (Map.Entry<String, String> entry : this.input_image_imageDigest.entrySet()) {
                        String input = entry.getKey();
                        String digest = entry.getValue();
                        CloseableHttpClient httpclient = BuildWorker.makeHttpClient(sslverify);
                        Throwable throwable = null;
                        try {
                            this.console.logInfo("Querying vulnerability listing for " + input);
                            String theurl = this.config.getEngineurl().replaceAll("/+$", "") + "/images/" + digest + "/vuln/all";
                            HttpGet httpget = new HttpGet(theurl);
                            httpget.addHeader("Content-Type", "application/json");
                            this.console.logDebug("anchore-engine get vulnerability listing URL: " + theurl);
                            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget, (HttpContext)context);
                            Throwable throwable2 = null;
                            try {
                                int statusCode = response.getStatusLine().getStatusCode();
                                if (statusCode != 200) {
                                    String serverMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                                    this.console.logWarn("anchore-engine get vulnerability listing failed. URL: " + theurl + ", status: " + response.getStatusLine() + ", error: " + serverMessage);
                                    throw new AbortException("Failed to fetch vulnerability listing from anchore-engine");
                                }
                                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                                String jenkinsAEResponseFileName = AE_VULNS_PREFIX + ++counter + JSON_FILE_EXTENSION;
                                FilePath jenkinsAEResponseFP = new FilePath(jenkinsOutputDirFP, jenkinsAEResponseFileName);
                                try {
                                    this.console.logDebug("Writing anchore-engine vulnerabilities listing response to " + jenkinsAEResponseFP.getRemote());
                                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(jenkinsAEResponseFP.write(), StandardCharsets.UTF_8));){
                                        bw.write(responseBody);
                                    }
                                }
                                catch (IOException | InterruptedException e) {
                                    this.console.logWarn("Failed to write anchore-engine vulnerabilities listing response to " + jenkinsAEResponseFP.getRemote(), e);
                                    throw new AbortException("Failed to write anchore-engine vulnerabilities listing response to " + jenkinsAEResponseFP.getRemote());
                                }
                                JSONObject responseJson = JSONObject.fromObject((Object)responseBody);
                                JSONArray vulList = responseJson.getJSONArray("vulnerabilities");
                                for (int i = 0; i < vulList.size(); ++i) {
                                    JSONObject vulnJson = vulList.getJSONObject(i);
                                    JSONArray vulnArray = new JSONArray();
                                    vulnArray.addAll(Arrays.asList(input, vulnJson.getString("vuln"), vulnJson.getString("severity"), vulnJson.getString("package"), vulnJson.getString("fix"), "<a href='" + vulnJson.getString("url") + "'>" + vulnJson.getString("url") + "</a>"));
                                    dataJson.add((Object)vulnArray);
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (response == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                response.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (httpclient == null) continue;
                            if (throwable != null) {
                                try {
                                    httpclient.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            httpclient.close();
                        }
                    }
                    securityJson.put("columns", (Object)columnsJson);
                    securityJson.put("data", (Object)dataJson);
                    this.cveListingFileName = "anchore_security.json";
                    FilePath filePath = new FilePath(jenkinsOutputDirFP, this.cveListingFileName);
                    try {
                        this.console.logDebug("Writing vulnerability listing result to " + filePath.getRemote());
                        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(filePath.write(), StandardCharsets.UTF_8));){
                            bufferedWriter.write(securityJson.toString());
                            break block61;
                        }
                    }
                    catch (IOException | InterruptedException exception) {
                        this.console.logWarn("Failed to write vulnerability listing to " + filePath.getRemote(), exception);
                        throw new AbortException("Failed to write vulnerability listing to " + filePath.getRemote());
                    }
                }
                catch (AbortException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.console.logError("Failed to fetch vulnerability listing from anchore-engine due to an unexpected error", e);
                    throw new AbortException("Failed to fetch vulnerability listing from anchore-engine due to an unexpected error. Please refer to above logs for more information");
                }
            }
            this.console.logError("Image(s) were not added to anchore-engine (or a prior attempt to add images may have failed). Re-submit image(s) to anchore-engine before attempting vulnerability listing");
            throw new AbortException("Submit image(s) to anchore-engine for analysis before attempting vulnerability listing");
        }
    }

    private void generateGatesSummary(JSONObject gatesJson) {
        this.console.logDebug("Summarizing policy evaluation results");
        if (gatesJson != null) {
            JSONArray summaryRows = new JSONArray();
            int numColumns = 0;
            int repoTagIndex = -1;
            int gateNameIndex = -1;
            int gateActionIndex = -1;
            int whitelistedIndex = -1;
            for (Object imageKey : gatesJson.keySet()) {
                JSONObject content = gatesJson.getJSONObject((String)imageKey);
                if (null != content) {
                    JSONObject result = content.getJSONObject("result");
                    if (null != result) {
                        if (numColumns <= 0 || repoTagIndex < 0 || gateNameIndex < 0 || gateActionIndex < 0 || whitelistedIndex < 0) {
                            JSONArray header = result.getJSONArray("header");
                            if (null != header) {
                                numColumns = header.size();
                                block23: for (int i = 0; i < header.size(); ++i) {
                                    switch (header.getString(i)) {
                                        case "Repo_Tag": {
                                            repoTagIndex = i;
                                            continue block23;
                                        }
                                        case "Gate": {
                                            gateNameIndex = i;
                                            continue block23;
                                        }
                                        case "Gate_Action": {
                                            gateActionIndex = i;
                                            continue block23;
                                        }
                                        case "Whitelisted": {
                                            whitelistedIndex = i;
                                            continue block23;
                                        }
                                    }
                                }
                            } else {
                                this.console.logWarn("'header' element not found in gate output, skipping summary computation for " + imageKey);
                                continue;
                            }
                        }
                        if (numColumns <= 0 || repoTagIndex < 0 || gateNameIndex < 0 || gateActionIndex < 0) {
                            this.console.logWarn("Either 'header' element has no columns or column indices (for Repo_Tag, Gate, Gate_Action) not initialized, skipping summary computation for " + imageKey);
                            continue;
                        }
                        JSONArray rows = result.getJSONArray("rows");
                        if (null != rows) {
                            JSONObject summaryRow;
                            int stop = 0;
                            int warn = 0;
                            int go = 0;
                            int stop_wl = 0;
                            int warn_wl = 0;
                            int go_wl = 0;
                            String repoTag = null;
                            for (int i = 0; i < rows.size(); ++i) {
                                JSONArray row = rows.getJSONArray(i);
                                if (row.size() == numColumns) {
                                    if (Strings.isNullOrEmpty(repoTag)) {
                                        repoTag = row.getString(repoTagIndex);
                                    }
                                    if (row.getString(gateNameIndex).equalsIgnoreCase("FINAL")) continue;
                                    switch (row.getString(gateActionIndex).toLowerCase()) {
                                        case "stop": {
                                            ++stop;
                                            stop_wl = whitelistedIndex != -1 && !row.getString(whitelistedIndex).equalsIgnoreCase("none") && !row.getString(whitelistedIndex).equalsIgnoreCase("false") ? ++stop_wl : stop_wl;
                                            break;
                                        }
                                        case "warn": {
                                            ++warn;
                                            warn_wl = whitelistedIndex != -1 && !row.getString(whitelistedIndex).equalsIgnoreCase("none") && !row.getString(whitelistedIndex).equalsIgnoreCase("false") ? ++warn_wl : warn_wl;
                                            break;
                                        }
                                        case "go": {
                                            ++go;
                                            go_wl = whitelistedIndex != -1 && !row.getString(whitelistedIndex).equalsIgnoreCase("none") && !row.getString(whitelistedIndex).equalsIgnoreCase("false") ? ++go_wl : go_wl;
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                this.console.logWarn("Expected " + numColumns + " elements but got " + row.size() + ", skipping row " + row + " in summary computation for " + imageKey);
                            }
                            this.totalStopActionCount += stop - stop_wl;
                            this.totalWarnActionCount += warn - warn_wl;
                            this.totalGoActionCount += go - go_wl;
                            if (!Strings.isNullOrEmpty((String)repoTag)) {
                                this.console.logInfo("Policy evaluation summary for " + repoTag + " - stop: " + (stop - stop_wl) + " (+" + stop_wl + " whitelisted), warn: " + (warn - warn_wl) + " (+" + warn_wl + " whitelisted), go: " + (go - go_wl) + " (+" + go_wl + " whitelisted), final: " + result.getString("final_action"));
                                summaryRow = new JSONObject();
                                summaryRow.put(Util.GATE_SUMMARY_COLUMN.Repo_Tag.toString(), (Object)repoTag);
                                summaryRow.put(Util.GATE_SUMMARY_COLUMN.Stop_Actions.toString(), (Object)(stop - stop_wl));
                                summaryRow.put(Util.GATE_SUMMARY_COLUMN.Warn_Actions.toString(), (Object)(warn - warn_wl));
                                summaryRow.put(Util.GATE_SUMMARY_COLUMN.Go_Actions.toString(), (Object)(go - go_wl));
                                summaryRow.put(Util.GATE_SUMMARY_COLUMN.Final_Action.toString(), (Object)result.getString("final_action"));
                                summaryRows.add((Object)summaryRow);
                                continue;
                            }
                            this.console.logInfo("Policy evaluation summary for " + imageKey + " - stop: " + (stop - stop_wl) + " (+" + stop_wl + " whitelisted), warn: " + (warn - warn_wl) + " (+" + warn_wl + " whitelisted), go: " + (go - go_wl) + " (+" + go_wl + " whitelisted), final: " + result.getString("final_action"));
                            summaryRow = new JSONObject();
                            summaryRow.put(Util.GATE_SUMMARY_COLUMN.Repo_Tag.toString(), (Object)imageKey.toString());
                            summaryRow.put(Util.GATE_SUMMARY_COLUMN.Stop_Actions.toString(), (Object)(stop - stop_wl));
                            summaryRow.put(Util.GATE_SUMMARY_COLUMN.Warn_Actions.toString(), (Object)(warn - warn_wl));
                            summaryRow.put(Util.GATE_SUMMARY_COLUMN.Go_Actions.toString(), (Object)(go - go_wl));
                            summaryRow.put(Util.GATE_SUMMARY_COLUMN.Final_Action.toString(), (Object)result.getString("final_action"));
                            summaryRows.add((Object)summaryRow);
                            this.console.logWarn("Repo_Tag element not found in gate output, using imageId: " + imageKey);
                            continue;
                        }
                        this.console.logWarn("'rows' element not found in gate output, skipping summary computation for " + imageKey);
                        continue;
                    }
                    this.console.logWarn("'result' element not found in gate output, skipping summary computation for " + imageKey);
                    continue;
                }
                this.console.logWarn("No mapped object found in gate output, skipping summary computation for " + imageKey);
            }
            this.gateSummary = new JSONObject();
            this.gateSummary.put("header", (Object)this.generateDataTablesColumnsForGateSummary());
            this.gateSummary.put("rows", (Object)summaryRows);
        } else {
            this.console.logWarn("Invalid input to generate gates summary");
        }
    }

    public void runQueries() throws AbortException {
        this.runVulnerabilityListing();
    }

    public void setupBuildReports() throws AbortException {
        try {
            this.console.logDebug("Archiving results");
            ArtifactArchiver artifactArchiver = new ArtifactArchiver(this.jenkinsOutputDirName + "/");
            artifactArchiver.perform(this.build, this.workspace, this.launcher, this.listener);
            this.console.logDebug("Setting up build results");
            if (this.finalAction != null) {
                this.build.addAction((Action)new AnchoreAction(this.build, this.finalAction.toString(), this.jenkinsOutputDirName, this.gateOutputFileName, this.queryOutputMap, this.gateSummary.toString(), this.cveListingFileName, this.totalStopActionCount, this.totalWarnActionCount, this.totalGoActionCount));
            } else {
                this.build.addAction((Action)new AnchoreAction(this.build, "", this.jenkinsOutputDirName, this.gateOutputFileName, this.queryOutputMap, this.gateSummary.toString(), this.cveListingFileName, this.totalStopActionCount, this.totalWarnActionCount, this.totalGoActionCount));
            }
        }
        catch (Exception e) {
            this.console.logError("Failed to setup build results due to an unexpected error", e);
            throw new AbortException("Failed to setup build results due to an unexpected error. Please refer to above logs for more information");
        }
    }

    public void cleanup() {
        try {
            this.console.logDebug("Cleaning up build artifacts");
            if (!Strings.isNullOrEmpty((String)this.jenkinsOutputDirName)) {
                try {
                    this.console.logDebug("Deleting Jenkins workspace " + this.jenkinsOutputDirName);
                    this.cleanJenkinsWorkspaceQuietly();
                }
                catch (IOException | InterruptedException e) {
                    this.console.logDebug("Unable to delete Jenkins workspace " + this.jenkinsOutputDirName, e);
                }
            }
        }
        catch (RuntimeException e) {
            this.console.logDebug("Failed to clean up build artifacts due to an unexpected error", e);
        }
    }

    private void printConfig() {
        List plugins;
        this.console.logInfo("Jenkins version: " + Jenkins.VERSION);
        if (Jenkins.getActiveInstance() != null && Jenkins.getActiveInstance().getPluginManager() != null && (plugins = Jenkins.getActiveInstance().getPluginManager().getPlugins()) != null) {
            for (PluginWrapper plugin : plugins) {
                if (!plugin.getShortName().equals("anchore-container-scanner")) continue;
                this.console.logInfo(plugin.getDisplayName() + " version: " + plugin.getVersion());
                break;
            }
        }
        this.config.print(this.console);
    }

    private void checkConfig() throws AbortException {
        if (Strings.isNullOrEmpty((String)this.config.getName())) {
            this.console.logError("Image list file not found");
            throw new AbortException("Image list file not specified. Please provide a valid image list file name in the Anchore Container Image Scanner step and try again");
        }
        try {
            if (!new FilePath(this.workspace, this.config.getName()).exists()) {
                this.console.logError("Cannot find image list file \"" + this.config.getName() + "\" under " + this.workspace);
                throw new AbortException("Cannot find image list file '" + this.config.getName() + "'. Please ensure that image list file is created prior to Anchore Container Image Scanner step");
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            this.console.logWarn("Unable to access image list file \"" + this.config.getName() + "\" under " + this.workspace, e);
            throw new AbortException("Unable to access image list file " + this.config.getName() + ". Please ensure that image list file is created prior to Anchore Container Image Scanner step");
        }
    }

    private void initializeJenkinsWorkspace() throws AbortException {
        try {
            this.console.logDebug("Initializing Jenkins workspace");
            this.buildId = this.build.getParent().getDisplayName() + "_" + this.build.getNumber();
            if (Strings.isNullOrEmpty((String)this.buildId)) {
                this.console.logWarn("Unable to generate a unique identifier for this build due to invalid configuration");
                throw new AbortException("Unable to generate a unique identifier for this build due to invalid configuration");
            }
            this.jenkinsOutputDirName = JENKINS_DIR_NAME_PREFIX + this.buildId.replaceAll(",", "_");
            FilePath jenkinsReportDir = new FilePath(this.workspace, this.jenkinsOutputDirName);
            if (!jenkinsReportDir.exists()) {
                this.console.logDebug("Creating workspace directory " + this.jenkinsOutputDirName);
                jenkinsReportDir.mkdirs();
            }
            this.queryOutputMap = new LinkedHashMap<String, String>();
            this.gateOutputFileName = "anchore_gates.json";
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            this.console.logWarn("Failed to initialize Jenkins workspace", e);
            throw new AbortException("Failed to initialize Jenkins workspace due to to an unexpected error");
        }
    }

    private void initializeAnchoreWorkspace() throws AbortException {
        this.initializeAnchoreWorkspaceEngine();
    }

    private void initializeAnchoreWorkspaceEngine() throws AbortException {
        try {
            this.console.logDebug("Initializing Anchore workspace (enginemode)");
            FilePath inputImageFP = new FilePath(this.workspace, this.config.getName());
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputImageFP.read(), StandardCharsets.UTF_8));){
                String line;
                boolean count = false;
                while ((line = br.readLine()) != null) {
                    Iterator partIterator;
                    String imgId = null;
                    String jenkinsDFile = null;
                    String dfilecontents = null;
                    Iterable iterable = Util.IMAGE_LIST_SPLITTER.split((CharSequence)line);
                    if (null != iterable && null != (partIterator = iterable.iterator()) && partIterator.hasNext()) {
                        imgId = (String)partIterator.next();
                        if (partIterator.hasNext()) {
                            jenkinsDFile = (String)partIterator.next();
                            StringBuilder b = new StringBuilder();
                            FilePath myfp = new FilePath(this.workspace, jenkinsDFile);
                            try (BufferedReader mybr = new BufferedReader(new InputStreamReader(myfp.read(), StandardCharsets.UTF_8));){
                                String myline;
                                while ((myline = mybr.readLine()) != null) {
                                    b.append(myline + '\n');
                                }
                            }
                            this.console.logDebug("Dockerfile contents: " + b.toString());
                            byte[] encodedBytes = Base64.encodeBase64((byte[])b.toString().getBytes(StandardCharsets.UTF_8));
                            dfilecontents = new String(encodedBytes, StandardCharsets.UTF_8);
                        }
                    }
                    if (null == imgId) continue;
                    this.console.logDebug("Image tag/digest: " + imgId);
                    this.console.logDebug("Base64 encoded Dockerfile contents: " + dfilecontents);
                    this.input_image_dfile.put(imgId, dfilecontents);
                }
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception e) {
            this.console.logError("Failed to initialize Anchore workspace due to an unexpected error", e);
            throw new AbortException("Failed to initialize Anchore workspace due to an unexpected error. Please refer to above logs for more information");
        }
    }

    private JSONArray generateDataTablesColumnsForGateSummary() {
        JSONArray headers = new JSONArray();
        for (Util.GATE_SUMMARY_COLUMN column : Util.GATE_SUMMARY_COLUMN.values()) {
            JSONObject header = new JSONObject();
            header.put("data", (Object)column.toString());
            header.put("title", (Object)column.toString().replaceAll("_", " "));
            headers.add((Object)header);
        }
        return headers;
    }

    private void cleanJenkinsWorkspaceQuietly() throws IOException, InterruptedException {
        FilePath jenkinsOutputDirFP = new FilePath(this.workspace, this.jenkinsOutputDirName);
        jenkinsOutputDirFP.deleteRecursive();
    }
}

