/*
 * Decompiled with CFR 0.152.
 */
package com.anchore.jenkins.plugins.anchore;

import com.anchore.jenkins.plugins.anchore.AnchoreAction;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.Area;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class AnchoreProjectAction
implements Action {
    public final Job<?, ?> job;

    public AnchoreProjectAction(Job<?, ?> job) {
        this.job = job;
    }

    public String getIconFileName() {
        return Jenkins.RESOURCE_PATH + "/plugin/anchore-container-scanner/images/anchore.png";
    }

    public String getDisplayName() {
        return "Anchore Report";
    }

    public String getUrlName() {
        return "anchore";
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AnchoreAction a;
        Run lastRun = this.job.getLastCompletedBuild();
        if (lastRun != null && (a = (AnchoreAction)lastRun.getAction(AnchoreAction.class)) != null) {
            response.sendRedirect2(String.format("../%d/%s", lastRun.getNumber(), a.getUrlName()));
        }
    }

    public AnchoreAction getLastAnchoreAction() {
        Run tb = this.job.getLastSuccessfulBuild();
        for (Run b = this.job.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            AnchoreAction a = (AnchoreAction)b.getAction(AnchoreAction.class);
            if (a != null && !b.isBuilding()) {
                return a;
            }
            if (b != tb) continue;
            return null;
        }
        return null;
    }

    private String getRelPath(StaplerRequest req) {
        String relPath = req.getParameter("rel");
        if (relPath == null) {
            return "";
        }
        return relPath;
    }

    public Graph getTrendGraph() {
        AnchoreAction a = this.getLastAnchoreAction();
        if (a != null) {
            return new AnchoreTrendGraph(a, this.getRelPath(Stapler.getCurrentRequest()));
        }
        Stapler.getCurrentResponse().setStatus(404);
        return null;
    }

    private static final class AnchoreTrendGraph
    extends Graph {
        private static final int MAX_HISTORY_DEFAULT = 100;
        private AnchoreAction base;
        private String relPath;

        private static Area calcDefaultSize() {
            Area res = Functions.getScreenResolution();
            if (res != null && res.width <= 800) {
                return new Area(250, 100);
            }
            return new Area(500, 200);
        }

        protected AnchoreTrendGraph(AnchoreAction base, String relPath) {
            this(base, AnchoreTrendGraph.calcDefaultSize(), relPath);
        }

        private AnchoreTrendGraph(AnchoreAction base, Area defaultSize, String relPath) {
            super(base.getBuild().getTimestamp(), defaultSize.width, defaultSize.height);
            this.base = base;
            this.relPath = relPath;
        }

        private CategoryDataset buildDataSet() {
            DataSetBuilder dsb = new DataSetBuilder();
            int cap = Integer.getInteger(AnchoreAction.class.getName() + ".anchore.trend.max", 100);
            int count = 0;
            for (AnchoreAction a = this.base; a != null && ++count <= cap; a = a.getPreviousResult()) {
                dsb.add((Number)a.getGoActionCount(), (Comparable)((Object)"0_go"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.getBuild()));
                dsb.add((Number)a.getWarnActionCount(), (Comparable)((Object)"1_warn"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.getBuild()));
                dsb.add((Number)a.getStopActionCount(), (Comparable)((Object)"2_stop"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.getBuild()));
            }
            return dsb.build();
        }

        protected JFreeChart createGraph() {
            CategoryDataset dataset = this.buildDataSet();
            JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setForegroundAlpha(0.8f);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.BLACK);
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            StackedAreaRenderer2 ar = new StackedAreaRenderer2(){

                public String generateURL(CategoryDataset data, int row, int column) {
                    ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)data.getColumnKey(column);
                    return relPath + label.getRun().getNumber() + "/anchore-results/";
                }

                public String generateToolTip(CategoryDataset data, int row, int column) {
                    ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)data.getColumnKey(column);
                    AnchoreAction a = (AnchoreAction)label.getRun().getAction(AnchoreAction.class);
                    switch (row) {
                        case 0: {
                            return label.getRun().getDisplayName() + ": " + a.getGoActionCount() + " Go Actions";
                        }
                        case 1: {
                            return label.getRun().getDisplayName() + ": " + a.getWarnActionCount() + " Warn Actions";
                        }
                    }
                    return label.getRun().getDisplayName() + ": " + a.getStopActionCount() + " Stop Actions";
                }
            };
            ar.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
            ar.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
            ar.setSeriesPaint(2, (Paint)ColorPalette.RED);
            plot.setRenderer((CategoryItemRenderer)ar);
            plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
            return chart;
        }
    }
}

