/*
 * Decompiled with CFR 0.152.
 */
package com.anchore.jenkins.plugins.anchore;

import com.anchore.jenkins.plugins.anchore.Annotation;
import com.anchore.jenkins.plugins.anchore.BuildConfig;
import com.anchore.jenkins.plugins.anchore.BuildWorker;
import com.anchore.jenkins.plugins.anchore.ConsoleLog;
import com.anchore.jenkins.plugins.anchore.Util;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AnchoreBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOG = Logger.getLogger(AnchoreBuilder.class.getName());
    private String name;
    private String engineRetries = "300";
    private boolean bailOnFail = true;
    private boolean bailOnPluginFail = true;
    private String policyBundleId = "";
    private List<Annotation> annotations;
    private boolean autoSubscribeTagUpdates = true;
    private boolean forceAnalyze = false;
    private String engineurl = "";
    private String engineCredentialsId = "";
    private boolean engineverify = false;
    private boolean isEngineverifyOverrride = false;

    public String getName() {
        return this.name;
    }

    public String getEngineRetries() {
        return this.engineRetries;
    }

    public boolean getBailOnFail() {
        return this.bailOnFail;
    }

    public boolean getBailOnPluginFail() {
        return this.bailOnPluginFail;
    }

    public String getPolicyBundleId() {
        return this.policyBundleId;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean getAutoSubscribeTagUpdates() {
        return this.autoSubscribeTagUpdates;
    }

    public boolean getForceAnalyze() {
        return this.forceAnalyze;
    }

    public String getEngineurl() {
        return this.engineurl;
    }

    public String getEngineCredentialsId() {
        return this.engineCredentialsId;
    }

    public boolean getEngineverify() {
        return this.engineverify;
    }

    @DataBoundSetter
    public void setEngineRetries(String engineRetries) {
        this.engineRetries = engineRetries;
    }

    @DataBoundSetter
    public void setBailOnFail(boolean bailOnFail) {
        this.bailOnFail = bailOnFail;
    }

    @DataBoundSetter
    public void setBailOnPluginFail(boolean bailOnPluginFail) {
        this.bailOnPluginFail = bailOnPluginFail;
    }

    @DataBoundSetter
    public void setPolicyBundleId(String policyBundleId) {
        this.policyBundleId = policyBundleId;
    }

    @DataBoundSetter
    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    @DataBoundSetter
    public void setAutoSubscribeTagUpdates(boolean autoSubscribeTagUpdates) {
        this.autoSubscribeTagUpdates = autoSubscribeTagUpdates;
    }

    @DataBoundSetter
    public void setForceAnalyze(boolean forceAnalyze) {
        this.forceAnalyze = forceAnalyze;
    }

    @DataBoundSetter
    public void setEngineurl(String engineurl) {
        this.engineurl = engineurl;
    }

    @DataBoundSetter
    public void setEngineCredentialsId(String engineCredentialsId) {
        this.engineCredentialsId = engineCredentialsId;
    }

    @DataBoundSetter
    public void setEngineverify(boolean engineverify) {
        this.engineverify = engineverify;
        this.isEngineverifyOverrride = true;
    }

    @DataBoundConstructor
    public AnchoreBuilder(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        LOG.warning("Starting Anchore Container Image Scanner step, project: " + run.getParent().getDisplayName() + ", job: " + run.getNumber());
        boolean failedByGate = false;
        BuildConfig config = null;
        BuildWorker worker = null;
        DescriptorImpl globalConfig = this.getDescriptor();
        ConsoleLog console = new ConsoleLog("AnchorePlugin", listener.getLogger(), globalConfig.getDebug());
        try {
            String engineuser = null;
            String enginepass = null;
            if (!Strings.isNullOrEmpty((String)this.engineCredentialsId)) {
                console.logDebug("Found build override for anchore-engine credentials. Processing Jenkins credential ID ");
                try {
                    StandardUsernamePasswordCredentials creds = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.engineCredentialsId, StandardUsernamePasswordCredentials.class, run, Collections.emptyList());
                    if (null == creds) {
                        throw new AbortException("Cannot find Jenkins credentials by ID: '" + this.engineCredentialsId + "'. Ensure credentials are defined in Jenkins before using them");
                    }
                    engineuser = creds.getUsername();
                    enginepass = creds.getPassword().getPlainText();
                }
                catch (AbortException e) {
                    throw e;
                }
                catch (Exception e) {
                    console.logError("Error looking up Jenkins credentials by ID: '" + this.engineCredentialsId + "'", e);
                    throw new AbortException("Error looking up Jenkins credentials by ID: '" + this.engineCredentialsId);
                }
            }
            config = new BuildConfig(this.name, this.engineRetries, this.bailOnFail, this.bailOnPluginFail, this.policyBundleId, this.annotations, this.autoSubscribeTagUpdates, this.forceAnalyze, globalConfig.getDebug(), !Strings.isNullOrEmpty((String)this.engineurl) ? this.engineurl : globalConfig.getEngineurl(), !Strings.isNullOrEmpty((String)engineuser) ? engineuser : globalConfig.getEngineuser(), !Strings.isNullOrEmpty((String)enginepass) ? enginepass : globalConfig.getEnginepass().getPlainText(), this.isEngineverifyOverrride ? this.engineverify : globalConfig.getEngineverify());
            worker = new BuildWorker(run, workspace, launcher, listener, config);
            if (!Strings.isNullOrEmpty((String)this.engineurl)) {
                console.logInfo("Build override set for Anchore Engine URL");
            }
            if (!Strings.isNullOrEmpty((String)engineuser) && !Strings.isNullOrEmpty((String)enginepass)) {
                console.logInfo("Build override set for Anchore Engine credentials");
            }
            if (this.isEngineverifyOverrride) {
                console.logInfo("Build override set for Anchore Engine verify SSL");
            }
            worker.runAnalyzer();
            Util.GATE_ACTION finalAction = worker.runGates();
            try {
                worker.runQueries();
            }
            catch (Exception e) {
                console.logWarn("Recording failure to execute Anchore queries and moving on with plugin operation", e);
            }
            worker.setupBuildReports();
            if (null != finalAction) {
                if (config.getBailOnFail() && (Util.GATE_ACTION.STOP.equals((Object)finalAction) || Util.GATE_ACTION.FAIL.equals((Object)finalAction))) {
                    console.logWarn("Failing Anchore Container Image Scanner Plugin step due to final result " + (Object)((Object)finalAction));
                    failedByGate = true;
                    throw new AbortException("Failing Anchore Container Image Scanner Plugin step due to final result " + (Object)((Object)finalAction));
                }
                console.logInfo("Marking Anchore Container Image Scanner step as successful, final result " + (Object)((Object)finalAction));
            } else {
                console.logInfo("Marking Anchore Container Image Scanner step as successful, no final result");
            }
        }
        catch (Exception e) {
            if (failedByGate) {
                throw e;
            }
            if (null != config && config.getBailOnPluginFail() || this.bailOnPluginFail) {
                console.logError("Failing Anchore Container Image Scanner Plugin step due to errors in plugin execution", e);
                if (e instanceof AbortException) {
                    throw e;
                }
                throw new AbortException("Failing Anchore Container Image Scanner Plugin step due to errors in plugin execution");
            }
            console.logWarn("Marking Anchore Container Image Scanner step as successful despite errors in plugin execution");
        }
        finally {
            if (null != worker) {
                try {
                    worker.cleanup();
                }
                catch (Exception e) {
                    console.logDebug("Failed to cleanup after the plugin, ignoring the errors", e);
                }
            }
            console.logInfo("Completed Anchore Container Image Scanner step");
            LOG.warning("Completed Anchore Container Image Scanner step, project: " + run.getParent().getDisplayName() + ", job: " + run.getNumber());
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"anchore"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String DEFAULT_NAME = "anchore_images";
        public static final String DEFAULT_ENGINE_RETRIES = "300";
        public static final boolean DEFAULT_BAIL_ON_FAIL = true;
        public static final boolean DEFAULT_BAIL_ON_PLUGIN_FAIL = true;
        public static final String DEFAULT_PLUGIN_MODE = "anchoreengine";
        public static final String DEFAULT_POLICY_BUNDLE_ID = "";
        public static final String EMPTY_STRING = "";
        public static final boolean DEFAULT_AUTOSUBSCRIBE_TAG_UPDATES = true;
        public static final boolean DEFAULT_FORCE_ANALYZE = false;
        private boolean debug;
        private String engineurl;
        private String engineuser;
        private Secret enginepass;
        private boolean engineverify;
        @Deprecated
        private boolean enabled;

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @Deprecated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setEngineurl(String engineurl) {
            this.engineurl = engineurl;
        }

        public void setEngineuser(String engineuser) {
            this.engineuser = engineuser;
        }

        public void setEnginepass(Secret enginepass) {
            this.enginepass = enginepass;
        }

        public void setEngineverify(boolean engineverify) {
            this.engineverify = engineverify;
        }

        public boolean getDebug() {
            return this.debug;
        }

        @Deprecated
        public boolean getEnabled() {
            return this.enabled;
        }

        public String getEngineurl() {
            return this.engineurl;
        }

        public String getEngineuser() {
            return this.engineuser;
        }

        public Secret getEnginepass() {
            return this.enginepass;
        }

        public boolean getEngineverify() {
            return this.engineverify;
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Anchore Container Image Scanner";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Please enter a valid file name");
        }

        public ListBoxModel doFillEngineCredentialsIdItems(@QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (!Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getActiveInstance(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }
    }
}

