/*
 * Decompiled with CFR 0.152.
 */
package com.anchore.jenkins.plugins.anchore;

import com.anchore.jenkins.plugins.anchore.AnchoreProjectAction;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;

public class AnchoreAction
implements SimpleBuildStep.LastBuildAction {
    private Run<?, ?> build;
    private String gateStatus;
    private String gateOutputUrl;
    private Map<String, String> queryOutputUrls;
    private String gateSummary;
    private String cveListingUrl;
    private int stopActionCount;
    private int warnActionCount;
    private int goActionCount;
    @Deprecated
    private String gateReportUrl;
    @Deprecated
    private Map<String, String> queries;

    public AnchoreAction(Run<?, ?> build, String gateStatus, String jenkinsOutputDirName, String gateReport, Map<String, String> queryReports, String gateSummary, String cveListingFileName, int stopActionCount, int warnActionCount, int goActionCount) {
        this.build = build;
        this.gateStatus = gateStatus;
        this.stopActionCount = stopActionCount;
        this.warnActionCount = warnActionCount;
        this.goActionCount = goActionCount;
        this.gateOutputUrl = "../artifact/" + jenkinsOutputDirName + "/" + gateReport;
        this.queryOutputUrls = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : queryReports.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            String newv = "../artifact/" + jenkinsOutputDirName + "/" + v;
            this.queryOutputUrls.put(k, newv);
        }
        this.gateSummary = gateSummary;
        if (null != cveListingFileName && cveListingFileName.trim().length() > 0) {
            this.cveListingUrl = "../artifact/" + jenkinsOutputDirName + "/" + cveListingFileName;
        }
    }

    public String getIconFileName() {
        return Jenkins.RESOURCE_PATH + "/plugin/anchore-container-scanner/images/anchore.png";
    }

    public String getDisplayName() {
        return "Anchore Report (" + this.gateStatus + ")";
    }

    public String getUrlName() {
        return "anchore-results";
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getGateStatus() {
        return this.gateStatus;
    }

    public String getGateOutputUrl() {
        return this.gateOutputUrl;
    }

    public Map<String, String> getQueryOutputUrls() {
        HashMap<String, String> fixedQueryOutputUrls;
        block3: {
            fixedQueryOutputUrls = new HashMap<String, String>();
            try {
                if (null == this.queryOutputUrls) break block3;
                fixedQueryOutputUrls.putAll(this.queryOutputUrls);
            }
            catch (Exception e) {
                String base_path = this.gateOutputUrl.substring(0, this.gateOutputUrl.lastIndexOf(47));
                int query_num = 0;
                for (String key : this.queryOutputUrls.keySet()) {
                    fixedQueryOutputUrls.put(key, base_path + "/anchore_query_" + String.valueOf(++query_num) + ".json");
                }
            }
        }
        return fixedQueryOutputUrls;
    }

    public JSONObject getGateSummary() {
        if (null != this.gateSummary && this.gateSummary.trim().length() > 0) {
            return JSONObject.fromObject((Object)this.gateSummary);
        }
        return null;
    }

    public String getCveListingUrl() {
        return this.cveListingUrl;
    }

    public String getGateReportUrl() {
        return this.gateReportUrl;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public int getGoActionCount() {
        return this.goActionCount;
    }

    public int getStopActionCount() {
        return this.stopActionCount;
    }

    public int getWarnActionCount() {
        return this.warnActionCount;
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.build.getParent();
        return Collections.singleton(new AnchoreProjectAction(job));
    }

    public AnchoreAction getPreviousResult() {
        AnchoreAction r;
        Run b = this.build;
        do {
            if ((b = b.getPreviousBuild()) != null) continue;
            return null;
        } while ((r = (AnchoreAction)b.getAction(AnchoreAction.class)) == null);
        if (r == this) {
            throw new IllegalStateException(this + " was attached to both " + b + " and " + this.build);
        }
        if (r.build.number != b.number) {
            throw new IllegalStateException(r + " was attached to both " + b + " and " + r.build);
        }
        return r;
    }
}

