/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryDomain;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.CacheAuthenticationException;
import hudson.plugins.active_directory.CacheConfiguration;
import hudson.plugins.active_directory.GroupLookupStrategy;
import hudson.plugins.active_directory.LDAPSearchBuilder;
import hudson.plugins.active_directory.MultiCauseBadCredentialsException;
import hudson.plugins.active_directory.MultiCauseUserMayOrMayNotExistException;
import hudson.plugins.active_directory.MultiCauseUserNotFoundException;
import hudson.plugins.active_directory.SocketInfo;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import hudson.util.TimeUnit2;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class ActiveDirectoryUnixAuthenticationProvider
extends AbstractActiveDirectoryAuthenticationProvider {
    private final List<ActiveDirectoryDomain> domains;
    private final String site;
    private final ActiveDirectorySecurityRealm.DescriptorImpl descriptor;
    private GroupLookupStrategy groupLookupStrategy;
    protected static final String DN_FORMATTED = "distinguishedNameFormatted";
    private CacheConfiguration cache;
    private final Cache<String, UserDetails> userCache;
    private final Cache<String, ActiveDirectoryGroupDetails> groupCache;
    private final ExecutorService threadPoolExecutor;
    private Hashtable<String, String> props = new Hashtable();
    private static final String DEFAULT_LDAP_CONNECTION_TIMEOUT = "30000";
    private static final String DEFAULT_LDAP_READ_TIMEOUT = "60000";
    private static final String LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String LDAP_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final int corePoolSize = Integer.parseInt(System.getProperty("hudson.plugins.active_directory.threadPoolExecutor.corePoolSize", "4"));
    private static final int maxPoolSize = Integer.parseInt(System.getProperty("hudson.plugins.active_directory.threadPoolExecutor.maxPoolSize", "8"));
    private static final long keepAliveTime = Long.parseLong(System.getProperty("hudson.plugins.active_directory.threadPoolExecutor.keepAliveTime", "10000"));
    private static final int queueSize = Integer.parseInt(System.getProperty("hudson.plugins.active_directory.threadPoolExecutor.queueSize", "25"));
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUnixAuthenticationProvider.class.getName());
    private static final String NO_AUTHENTICATION = "\u0000\u0000\u0000\u0000\u0000\u0000";

    public ActiveDirectoryUnixAuthenticationProvider(ActiveDirectorySecurityRealm realm) {
        this.site = realm.site;
        this.domains = realm.domains;
        this.groupLookupStrategy = realm.getGroupLookupStrategy();
        this.descriptor = realm.getDescriptor();
        this.cache = realm.cache;
        if (this.cache == null) {
            this.cache = new CacheConfiguration(0, 0);
        }
        if (this.cache.getUserCache() == null || this.cache.getGroupCache() == null) {
            this.cache = new CacheConfiguration(this.cache.getSize(), this.cache.getTtl());
        }
        this.userCache = this.cache.getUserCache();
        this.groupCache = this.cache.getGroupCache();
        this.threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueSize), (ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), "ActiveDirectory.updateUserCache"), new ThreadPoolExecutor.DiscardPolicy());
        Map<String, String> extraEnvVarsMap = ActiveDirectorySecurityRealm.EnvironmentProperty.toMap(realm.environmentProperties);
        this.props.put(LDAP_CONNECT_TIMEOUT, System.getProperty(LDAP_CONNECT_TIMEOUT, DEFAULT_LDAP_CONNECTION_TIMEOUT));
        this.props.put(LDAP_READ_TIMEOUT, System.getProperty(LDAP_READ_TIMEOUT, DEFAULT_LDAP_READ_TIMEOUT));
        this.props.putAll(extraEnvVarsMap);
    }

    @Override
    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            ArrayList<BadCredentialsException> errors = new ArrayList<BadCredentialsException>();
            ArrayList<UsernameNotFoundException> notFound = new ArrayList<UsernameNotFoundException>();
            for (ActiveDirectoryDomain domain : this.domains) {
                try {
                    return this.retrieveUser(username, authentication, domain);
                }
                catch (UsernameNotFoundException e) {
                    notFound.add(e);
                }
                catch (BadCredentialsException bce) {
                    LOGGER.log(Level.WARNING, String.format("Credential exception trying to authenticate against %s domain", domain.getName()), bce);
                    errors.add(bce);
                }
            }
            switch (errors.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    throw (BadCredentialsException)((Object)errors.get(0));
                }
                default: {
                    throw new MultiCauseBadCredentialsException("Either no such user '" + username + "' or incorrect password", errors);
                }
            }
            if (notFound.size() == 1) {
                throw (UsernameNotFoundException)((Object)notFound.get(0));
            }
            if (!Util.filter(notFound, UserMayOrMayNotExistException.class).isEmpty()) {
                throw new MultiCauseUserMayOrMayNotExistException("We can't tell if the user exists or not: " + username, notFound);
            }
            if (!notFound.isEmpty()) {
                throw new MultiCauseUserNotFoundException("No such user: " + username, notFound);
            }
            throw new AssertionError((Object)"No domain is configured");
        }
        catch (AuthenticationException e) {
            LOGGER.log(Level.FINE, String.format("Failed to retrieve user %s", username), e);
            throw e;
        }
    }

    @Override
    protected boolean canRetrieveUserByName(ActiveDirectoryDomain domain) {
        return domain.getBindName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication, ActiveDirectoryDomain domain) throws AuthenticationException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            String password = NO_AUTHENTICATION;
            if (authentication != null) {
                password = (String)authentication.getCredentials();
            }
            UserDetails userDetails = this.retrieveUser(username, password, domain, this.obtainLDAPServers(domain));
            return userDetails;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private List<SocketInfo> obtainLDAPServers(ActiveDirectoryDomain domain) throws AuthenticationServiceException {
        try {
            return this.descriptor.obtainLDAPServer(domain);
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to find the LDAP service", e);
            throw new AuthenticationServiceException("Failed to find the LDAP service for the domain " + domain.getName(), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="Intentional instance check.")
    public UserDetails retrieveUser(final String username, final String password, final ActiveDirectoryDomain domain, final List<SocketInfo> ldapServers) {
        UserDetails userDetails;
        String hashKey = username + "@@" + DigestUtils.sha1Hex((String)password);
        final String bindName = domain.getBindName();
        final String bindPassword = domain.getBindPassword().getPlainText();
        try {
            final ActiveDirectoryUserDetail[] cacheMiss = new ActiveDirectoryUserDetail[1];
            userDetails = (UserDetails)this.userCache.get((Object)hashKey, (Callable)new Callable<UserDetails>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public UserDetails call() throws AuthenticationException {
                    DirContext context;
                    boolean anonymousBind = false;
                    if (StringUtils.isEmpty((String)password)) {
                        throw new BadCredentialsException("Empty password");
                    }
                    String userPrincipalName = ActiveDirectoryUnixAuthenticationProvider.this.getPrincipalName(username, domain.getName());
                    String samAccountName = userPrincipalName.substring(0, userPrincipalName.indexOf(64));
                    if (bindName != null) {
                        try {
                            context = ActiveDirectoryUnixAuthenticationProvider.this.descriptor.bind(bindName, bindPassword, ldapServers, (Hashtable<String, String>)ActiveDirectoryUnixAuthenticationProvider.this.props);
                            anonymousBind = false;
                        }
                        catch (BadCredentialsException e) {
                            throw new AuthenticationServiceException("Failed to bind to LDAP server with the bind name/password", (Throwable)e);
                        }
                    }
                    if (password.equals(ActiveDirectoryUnixAuthenticationProvider.NO_AUTHENTICATION)) {
                        anonymousBind = true;
                    }
                    try {
                        context = ActiveDirectoryUnixAuthenticationProvider.this.descriptor.bind(userPrincipalName, anonymousBind ? "" : password, ldapServers, (Hashtable<String, String>)ActiveDirectoryUnixAuthenticationProvider.this.props);
                    }
                    catch (BadCredentialsException e) {
                        if (anonymousBind) {
                            throw new UserMayOrMayNotExistException("Unable to retrieve the user information without bind DN/password configured");
                        }
                        throw e;
                    }
                    try {
                        String domainDN = ActiveDirectoryUnixAuthenticationProvider.toDC(domain.getName());
                        Attributes user = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (userPrincipalName={0})(objectCategory=user))", userPrincipalName);
                        if (user == null) {
                            LOGGER.log(Level.FINE, "Failed to find {0} in userPrincipalName. Trying sAMAccountName", userPrincipalName);
                            user = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (sAMAccountName={0})(objectCategory=user))", samAccountName);
                            if (user == null) {
                                throw new UsernameNotFoundException("Authentication was successful but cannot locate the user information for " + username);
                            }
                        }
                        LOGGER.fine("Found user " + username + " : " + user);
                        Object dnObject = user.get(ActiveDirectoryUnixAuthenticationProvider.DN_FORMATTED).get();
                        if (dnObject == null) {
                            throw new AuthenticationServiceException("No distinguished name for " + username);
                        }
                        String dn = dnObject.toString();
                        LdapName ldapName = new LdapName(dn);
                        String dnFormatted = ldapName.toString();
                        if (bindName != null && !password.equals(ActiveDirectoryUnixAuthenticationProvider.NO_AUTHENTICATION)) {
                            LOGGER.log(Level.FINE, "Attempting to validate password for DN={0}", dn);
                            DirContext test = ActiveDirectoryUnixAuthenticationProvider.this.descriptor.bind(dnFormatted, password, ldapServers, (Hashtable<String, String>)ActiveDirectoryUnixAuthenticationProvider.this.props);
                            try {
                                new LDAPSearchBuilder(test, domainDN).searchOne("(& (userPrincipalName={0})(objectCategory=user))", userPrincipalName);
                            }
                            finally {
                                ActiveDirectoryUnixAuthenticationProvider.this.closeQuietly(test);
                            }
                        }
                        Set groups = ActiveDirectoryUnixAuthenticationProvider.this.resolveGroups(domainDN, dnFormatted, context);
                        groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                        cacheMiss[0] = new ActiveDirectoryUserDetail(username, password, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]), ActiveDirectoryUnixAuthenticationProvider.this.getStringAttribute(user, "displayName"), ActiveDirectoryUnixAuthenticationProvider.this.getStringAttribute(user, "mail"), ActiveDirectoryUnixAuthenticationProvider.this.getStringAttribute(user, "telephoneNumber"));
                        ActiveDirectoryUserDetail activeDirectoryUserDetail = cacheMiss[0];
                        return activeDirectoryUserDetail;
                    }
                    catch (NamingException e) {
                        if (anonymousBind && e.getMessage().contains("successful bind must be completed") && e.getMessage().contains("000004DC")) {
                            throw new UserMayOrMayNotExistException("Unable to retrieve the user information without bind DN/password configured");
                        }
                        LOGGER.log(Level.WARNING, String.format("Failed to retrieve user information for %s", username), e);
                        throw new BadCredentialsException("Failed to retrieve user information for " + username, (Throwable)e);
                    }
                    finally {
                        ActiveDirectoryUnixAuthenticationProvider.this.closeQuietly(context);
                    }
                }
            });
            if (cacheMiss[0] != null) {
                this.threadPoolExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String threadName = Thread.currentThread().getName();
                        Thread.currentThread().setName(threadName + " updating-cache-for-user-" + cacheMiss[0].getUsername());
                        LOGGER.log(Level.FINEST, "Starting the cache update {0}", new Date());
                        try {
                            long t0 = System.currentTimeMillis();
                            cacheMiss[0].updateUserInfo();
                            LOGGER.log(Level.FINEST, "Finished the cache update {0}", new Date());
                            long t1 = System.currentTimeMillis();
                            LOGGER.log(Level.FINE, "The cache for user {0} took {1} msec", new Object[]{cacheMiss[0].getUsername(), String.valueOf(t1 - t0)});
                        }
                        finally {
                            Thread.currentThread().setName(threadName);
                        }
                    }
                });
            }
        }
        catch (UncheckedExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof AuthenticationException) {
                AuthenticationException authenticationException = (AuthenticationException)t;
                throw authenticationException;
            }
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching user " + username, (Exception)((Object)e));
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "There was a problem caching user " + username, e);
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching user " + username, e);
        }
        if (password != null && !password.equals(NO_AUTHENTICATION) && userDetails != null && !password.equals(userDetails.getPassword())) {
            throw new BadCredentialsException("Failed to retrieve user information from the cache for " + username);
        }
        return userDetails;
    }

    @Override
    public GroupDetails loadGroupByGroupname(final String groupname) {
        try {
            return (GroupDetails)this.groupCache.get((Object)groupname, (Callable)new Callable<ActiveDirectoryGroupDetails>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ActiveDirectoryGroupDetails call() {
                    for (ActiveDirectoryDomain domain : ActiveDirectoryUnixAuthenticationProvider.this.domains) {
                        if (domain == null) {
                            throw new UserMayOrMayNotExistException("Unable to retrieve group information without bind DN/password configured");
                        }
                        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        try {
                            ActiveDirectoryGroupDetails activeDirectoryGroupDetails;
                            Attributes group;
                            DirContext context;
                            block16: {
                                context = ActiveDirectoryUnixAuthenticationProvider.this.descriptor.bind(domain.getBindName(), domain.getBindPassword().getPlainText(), ActiveDirectoryUnixAuthenticationProvider.this.obtainLDAPServers(domain));
                                String domainDN = ActiveDirectoryUnixAuthenticationProvider.toDC(domain.getName());
                                group = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (cn={0})(objectCategory=group))", groupname);
                                if (group != null) break block16;
                                LOGGER.log(Level.FINE, "Failed to find {0} in cn. Trying sAMAccountName", groupname);
                                group = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (sAMAccountName={0})(objectCategory=group))", groupname);
                                if (group != null) break block16;
                                ActiveDirectoryUnixAuthenticationProvider.this.closeQuietly(context);
                                continue;
                            }
                            try {
                                LOGGER.log(Level.FINE, "Found group {0} : {1}", new Object[]{groupname, group});
                                activeDirectoryGroupDetails = new ActiveDirectoryGroupDetails(groupname);
                            }
                            catch (NamingException e) {
                                try {
                                    try {
                                        LOGGER.log(Level.WARNING, String.format("Failed to retrieve user information for %s", groupname), e);
                                        throw new BadCredentialsException("Failed to retrieve user information for " + groupname, (Throwable)e);
                                    }
                                    catch (Throwable throwable) {
                                        ActiveDirectoryUnixAuthenticationProvider.this.closeQuietly(context);
                                        throw throwable;
                                    }
                                }
                                catch (UsernameNotFoundException e2) {
                                    LOGGER.log(Level.WARNING, String.format("Failed to find the group %s in %s domain", groupname, domain.getName()), e2);
                                    Thread.currentThread().setContextClassLoader(ccl);
                                    continue;
                                }
                                catch (AuthenticationException e3) {
                                    LOGGER.log(Level.WARNING, String.format("Failed to find the group %s in %s domain", groupname, domain.getName()), e3);
                                    continue;
                                }
                            }
                            ActiveDirectoryUnixAuthenticationProvider.this.closeQuietly(context);
                            return activeDirectoryGroupDetails;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(ccl);
                        }
                    }
                    LOGGER.log(Level.WARNING, "Exhausted all configured domains and could not authenticate against any");
                    throw new UserMayOrMayNotExistException(groupname);
                }
            });
        }
        catch (UncheckedExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof AuthenticationException) {
                AuthenticationException authenticationException = (AuthenticationException)t;
                throw authenticationException;
            }
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching group " + groupname, (Exception)((Object)e));
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, String.format("There was a problem caching group %s", groupname), e);
            throw new CacheAuthenticationException("Authentication failed because there was a problem caching group " + groupname, e);
        }
    }

    private void closeQuietly(DirContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.INFO, "Failed to close DirContext: " + context, e);
        }
    }

    private String getStringAttribute(Attributes user, String name) throws NamingException {
        Attribute a = user.get(name);
        if (a == null) {
            return null;
        }
        Object v = a.get();
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    private String getPrincipalName(String username, String domainName) {
        int slash = username.indexOf(92);
        String principalName = slash > 0 ? username.substring(slash + 1) + '@' + domainName : (username.contains("@") ? username : username + '@' + domainName);
        return principalName;
    }

    private Set<GrantedAuthority> resolveGroups(String domainDN, String userDN, DirContext context) throws NamingException {
        if (userDN.contains("/")) {
            userDN = userDN.replace("/", "\\/");
        }
        HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
        LOGGER.log(Level.FINER, "Looking up group of {0}", userDN);
        Attributes id = context.getAttributes(userDN, new String[]{"tokenGroups", "memberOf", "CN"});
        Attribute tga = id.get("tokenGroups");
        if (tga == null) {
            LOGGER.log(Level.FINE, "Failed to retrieve tokenGroups for {0}", userDN);
        } else {
            StringBuilder query = new StringBuilder("(|");
            ArrayList<byte[]> sids = new ArrayList<byte[]>();
            NamingEnumeration<?> tokenGroups = tga.getAll();
            while (tokenGroups.hasMore()) {
                byte[] gsid = (byte[])tokenGroups.next();
                query.append("(objectSid={" + sids.size() + "})");
                sids.add(gsid);
            }
            tokenGroups.close();
            query.append(")");
            NamingEnumeration<SearchResult> renum = new LDAPSearchBuilder(context, domainDN).subTreeScope().returns("cn").search(query.toString(), sids.toArray());
            this.parseMembers(userDN, groups, renum);
            renum.close();
        }
        LOGGER.fine("Stage 2: looking up via memberOf");
        block10: while (true) {
            switch (this.groupLookupStrategy) {
                case TOKENGROUPS: {
                    return groups;
                }
                case AUTO: {
                    long start = System.nanoTime();
                    boolean found = false;
                    long duration = 0L;
                    try {
                        found = this.chainGroupLookup(domainDN, userDN, context, groups);
                        duration = TimeUnit2.NANOSECONDS.toSeconds(System.nanoTime() - start);
                    }
                    catch (TimeLimitExceededException e) {
                        LOGGER.log(Level.WARNING, "The LDAP request did not terminate within the specified time limit. AD will fall back to recursive lookup", e);
                    }
                    catch (NamingException e) {
                        if (e.getMessage().contains("LDAP response read timed out")) {
                            LOGGER.log(Level.WARNING, "LDAP response read time out. AD will fall back to recursive lookup", e);
                        }
                        throw e;
                    }
                    if (!found && duration >= 10L) {
                        LOGGER.log(Level.WARNING, "Group lookup via Active Directory's 'LDAP_MATCHING_RULE_IN_CHAIN' extension timed out after {0} seconds. Falling back to recursive group lookup strategy for this and future queries", duration);
                        this.groupLookupStrategy = GroupLookupStrategy.RECURSIVE;
                        continue block10;
                    }
                    if (found && duration >= 10L) {
                        LOGGER.log(Level.WARNING, "Group lookup via Active Directory's 'LDAP_MATCHING_RULE_IN_CHAIN' extension matched user's groups but took {0} seconds to run. Switching to recursive lookup for future group lookup queries", duration);
                        this.groupLookupStrategy = GroupLookupStrategy.RECURSIVE;
                        return groups;
                    }
                    if (!found) {
                        LOGGER.log(Level.WARNING, "Group lookup via Active Directory's 'LDAP_MATCHING_RULE_IN_CHAIN' extension failed. Falling back to recursive group lookup strategy for this and future queries");
                        this.groupLookupStrategy = GroupLookupStrategy.RECURSIVE;
                        continue block10;
                    }
                    this.groupLookupStrategy = GroupLookupStrategy.CHAIN;
                    return groups;
                }
                case RECURSIVE: {
                    this.recursiveGroupLookup(context, id, groups);
                    return groups;
                }
                case CHAIN: {
                    this.chainGroupLookup(domainDN, userDN, context, groups);
                    return groups;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean chainGroupLookup(String domainDN, String userDN, DirContext context, Set<GrantedAuthority> groups) throws NamingException {
        NamingEnumeration<SearchResult> renum = new LDAPSearchBuilder(context, domainDN).subTreeScope().returns("cn").search("(member:1.2.840.113556.1.4.1941:={0})", userDN);
        try {
            if (renum.hasMore()) {
                this.parseMembers(userDN, groups, renum);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            renum.close();
        }
    }

    private void recursiveGroupLookup(DirContext context, Attributes id, Set<GrantedAuthority> groups) throws NamingException {
        Stack<Attributes> q = new Stack<Attributes>();
        q.push(id);
        while (!q.isEmpty()) {
            Attributes identity = (Attributes)q.pop();
            LOGGER.finer("Looking up group of " + identity);
            Attribute memberOf = identity.get("memberOf");
            if (memberOf == null) continue;
            for (int i = 0; i < memberOf.size(); ++i) {
                try {
                    LOGGER.log(Level.FINE, "Trying to get the CN of {0}", memberOf.get(i));
                    Attributes group = context.getAttributes(new LdapName(memberOf.get(i).toString()), new String[]{"CN", "memberOf"});
                    Attribute cn = group.get("CN");
                    if (cn == null) {
                        LOGGER.fine("Failed to obtain CN of " + memberOf.get(i));
                        continue;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(cn.get() + " is a member of " + memberOf.get(i));
                    }
                    if (!groups.add((GrantedAuthority)new GrantedAuthorityImpl(cn.get().toString()))) continue;
                    q.add(group);
                    continue;
                }
                catch (NameNotFoundException e) {
                    LOGGER.fine("Failed to obtain CN of " + memberOf.get(i));
                }
            }
        }
    }

    private void parseMembers(String userDN, Set<GrantedAuthority> groups, NamingEnumeration<SearchResult> renum) throws NamingException {
        try {
            while (renum.hasMore()) {
                Attributes a = renum.next().getAttributes();
                Attribute cn = a.get("cn");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(userDN + " is a member of " + cn);
                }
                groups.add((GrantedAuthority)new GrantedAuthorityImpl(cn.get().toString()));
            }
        }
        catch (PartialResultException e) {
            LOGGER.log(Level.WARNING, String.format("JENKINS-42687 Might be more members for user  %s", userDN), e);
        }
    }

    static String toDC(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }
}

