/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import java.util.concurrent.TimeUnit;
import org.acegisecurity.userdetails.UserDetails;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheConfiguration<K, V, E extends Exception> {
    private final int size;
    private final int ttl;
    private final Cache<String, UserDetails> userCache;
    private final Cache<String, ActiveDirectoryGroupDetails> groupCache;

    @DataBoundConstructor
    public CacheConfiguration(int size, int ttl) {
        this.size = Math.max(0, Math.min(size, 1000));
        this.ttl = Math.max(0, Math.min(ttl, 3600));
        this.userCache = CacheBuilder.newBuilder().maximumSize((long)this.getSize()).expireAfterWrite((long)this.getTtl(), TimeUnit.SECONDS).build();
        this.groupCache = CacheBuilder.newBuilder().maximumSize((long)this.getSize()).expireAfterWrite((long)this.getTtl(), TimeUnit.SECONDS).build();
    }

    public int getSize() {
        return this.size;
    }

    public int getTtl() {
        return this.ttl;
    }

    public Cache<String, UserDetails> getUserCache() {
        return this.userCache;
    }

    public Cache<String, ActiveDirectoryGroupDetails> getGroupCache() {
        return this.groupCache;
    }
}

