/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.util.TimeUnit2;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cache<K, V, E extends Exception> {
    private final LRUMap store = new LRUMap(256);

    public synchronized V get(K key) throws E {
        Entry e = (Entry)this.store.get(key);
        if (e != null) {
            if (!e.isStale()) {
                return e.value;
            }
            this.store.remove(key);
        }
        V val = this.compute(key);
        this.store.put(key, new Entry<V>(val));
        return val;
    }

    protected abstract V compute(K var1) throws E;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V> {
        final V value;
        long timestamp = System.currentTimeMillis();

        Entry(V value) {
            this.value = value;
        }

        public boolean isStale() {
            return System.currentTimeMillis() - this.timestamp > TimeUnit2.MINUTES.toMillis(10L);
        }
    }
}

