/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryGroupDetails;
import hudson.plugins.active_directory.ActiveDirectorySecurityRealm;
import hudson.plugins.active_directory.ActiveDirectoryUserDetail;
import hudson.plugins.active_directory.LDAPSearchBuilder;
import hudson.plugins.active_directory.MultiCauseBadCredentialsException;
import hudson.plugins.active_directory.SocketInfo;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.Secret;
import hudson.util.TimeUnit2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveDirectoryUnixAuthenticationProvider
extends AbstractActiveDirectoryAuthenticationProvider {
    private final String[] domainNames;
    private final String site;
    private final String server;
    private final String bindName;
    private final String bindPassword;
    private final ActiveDirectorySecurityRealm.DesciprotrImpl descriptor;
    private final LRUMap groupCache = new LRUMap(256);
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectoryUnixAuthenticationProvider.class.getName());
    private static final String NO_AUTHENTICATION = "\u0000\u0000\u0000\u0000\u0000\u0000";

    public ActiveDirectoryUnixAuthenticationProvider(ActiveDirectorySecurityRealm realm) {
        if (realm.domain == null) {
            throw new IllegalArgumentException("Active Directory domain name is required but it is not set");
        }
        this.domainNames = realm.domain.split(",");
        this.site = realm.site;
        this.bindName = realm.bindName;
        this.server = realm.server;
        this.bindPassword = Secret.toString((Secret)realm.bindPassword);
        this.descriptor = realm.getDescriptor();
    }

    @Override
    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        ArrayList<BadCredentialsException> causes = new ArrayList<BadCredentialsException>();
        for (String domainName : this.domainNames) {
            try {
                UserDetails userDetails = this.retrieveUser(username, authentication, domainName);
                if (userDetails == null) continue;
                return userDetails;
            }
            catch (BadCredentialsException bce) {
                LOGGER.log(Level.WARNING, "Credential exception tying to authenticate against " + domainName + " domain", bce);
                causes.add(bce);
            }
        }
        LOGGER.log(Level.WARNING, "Exhausted all configured domains and could not authenticate against any.");
        switch (causes.size()) {
            case 0: {
                throw new BadCredentialsException("Either no such user '" + username + "' or incorrect password");
            }
            case 1: {
                throw (BadCredentialsException)((Object)causes.get(0));
            }
        }
        throw new MultiCauseBadCredentialsException("Either no such user '" + username + "' or incorrect password", causes);
    }

    @Override
    protected boolean canRetrieveUserByName() {
        return this.bindName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication, String domainName) throws AuthenticationException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            String password = NO_AUTHENTICATION;
            if (authentication != null) {
                password = (String)authentication.getCredentials();
            }
            UserDetails userDetails = this.retrieveUser(username, password, domainName, this.obtainLDAPServers(domainName));
            return userDetails;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private List<SocketInfo> obtainLDAPServers(String domainName) throws AuthenticationServiceException {
        try {
            return this.descriptor.obtainLDAPServer(domainName, this.site, this.server);
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to find the LDAP service", e);
            throw new AuthenticationServiceException("Failed to find the LDAP service for the domain " + domainName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails retrieveUser(String username, String password, String domainName, List<SocketInfo> ldapServers) {
        DirContext context;
        String id;
        if (this.bindName != null) {
            try {
                id = username;
                context = this.descriptor.bind(this.bindName, this.bindPassword, ldapServers);
            }
            catch (BadCredentialsException e) {
                throw new AuthenticationServiceException("Failed to bind to LDAP server with the bind name/password", (Throwable)e);
            }
        } else {
            if (password == NO_AUTHENTICATION) {
                throw new UserMayOrMayNotExistException("Unable to retrieve the user information without bind DN/password configured");
            }
            String principalName = this.getPrincipalName(username, domainName);
            id = principalName.substring(0, principalName.indexOf(64));
            context = this.descriptor.bind(principalName, password, ldapServers);
        }
        try {
            String domainDN = ActiveDirectoryUnixAuthenticationProvider.toDC(domainName);
            Attributes user = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (userPrincipalName={0})(objectClass=user))", id);
            if (user == null) {
                LOGGER.fine("Failed to find " + id + " in userPrincipalName. Trying sAMAccountName");
                user = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (sAMAccountName={0})(objectClass=user))", id);
                if (user == null) {
                    throw new UsernameNotFoundException("Authentication was successful but cannot locate the user information for " + username);
                }
            }
            LOGGER.fine("Authentication successful as " + id + " : " + user);
            Object dn = user.get("distinguishedName").get();
            if (dn == null) {
                throw new AuthenticationServiceException("No distinguished name for " + username);
            }
            if (this.bindName != null && password != NO_AUTHENTICATION) {
                LOGGER.fine("Attempting to validate password for DN=" + dn);
                DirContext test = this.descriptor.bind(dn.toString(), password, ldapServers);
                try {
                    new LDAPSearchBuilder(test, domainDN).searchOne("(& (userPrincipalName={0})(objectClass=user))", id);
                }
                finally {
                    this.closeQuietly(test);
                }
            }
            Set<GrantedAuthority> groups = this.resolveGroups(domainDN, dn.toString(), context);
            groups.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
            UserDetails userDetails = new ActiveDirectoryUserDetail(id, password, true, true, true, true, groups.toArray(new GrantedAuthority[groups.size()]), this.getStringAttribute(user, "displayName"), this.getStringAttribute(user, "mail"), this.getStringAttribute(user, "telephoneNumber")).updateUserInfo();
            return userDetails;
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve user information for " + username, e);
            throw new BadCredentialsException("Failed to retrieve user information for " + username, (Throwable)e);
        }
        finally {
            this.closeQuietly(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupDetails loadGroupByGroupname(String groupname) {
        if (this.bindName == null) {
            throw new UserMayOrMayNotExistException("Unable to retrieve group information without bind DN/password configured");
        }
        LRUMap lRUMap = this.groupCache;
        synchronized (lRUMap) {
            GroupCacheEntry v = (GroupCacheEntry)this.groupCache.get((Object)groupname);
            if (v != null) {
                if (!v.isStale()) {
                    return v.detail;
                }
                this.groupCache.remove((Object)groupname);
            }
        }
        boolean problem = false;
        for (String domainName : this.domainNames) {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                DirContext context = this.descriptor.bind(this.bindName, this.bindPassword, this.obtainLDAPServers(domainName));
                try {
                    String domainDN = ActiveDirectoryUnixAuthenticationProvider.toDC(domainName);
                    Attributes group = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (cn={0})(objectClass=group))", groupname);
                    if (group == null) {
                        LOGGER.fine("Failed to find " + groupname + " in cn. Trying sAMAccountName");
                        group = new LDAPSearchBuilder(context, domainDN).subTreeScope().searchOne("(& (sAMAccountName={0})(objectClass=group))", groupname);
                        if (group == null) {
                            throw new UsernameNotFoundException(groupname);
                        }
                    }
                    LOGGER.fine("Found group " + groupname + " : " + group);
                    GroupCacheEntry e = new GroupCacheEntry(groupname);
                    Object object = this.groupCache;
                    synchronized (object) {
                        this.groupCache.put((Object)groupname, (Object)e);
                    }
                    object = e.detail;
                    this.closeQuietly(context);
                    return object;
                }
                catch (NamingException e) {
                    try {
                        try {
                            LOGGER.log(Level.WARNING, "Failed to retrieve user information for " + groupname, e);
                            throw new BadCredentialsException("Failed to retrieve user information for " + groupname, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            this.closeQuietly(context);
                            throw throwable;
                        }
                    }
                    catch (UsernameNotFoundException e2) {
                        LOGGER.log(Level.FINE, "Failed to find the group " + groupname + " in " + domainName + " domain", e2);
                        Thread.currentThread().setContextClassLoader(ccl);
                    }
                    catch (AuthenticationException e3) {
                        LOGGER.log(Level.WARNING, "Failed to find the group " + groupname + " in " + domainName + " domain", e3);
                        problem = true;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        LOGGER.log(Level.WARNING, "Exhausted all configured domains and could not authenticate against any.");
        if (!problem) {
            throw new UsernameNotFoundException(groupname);
        }
        throw new UserMayOrMayNotExistException(groupname);
    }

    private void closeQuietly(DirContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.INFO, "Failed to close DirContext: " + context, e);
        }
    }

    private String getStringAttribute(Attributes user, String name) throws NamingException {
        Attribute a = user.get(name);
        if (a == null) {
            return null;
        }
        Object v = a.get();
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    private String getPrincipalName(String username, String domainName) {
        int slash = username.indexOf(92);
        String principalName = slash > 0 ? username.substring(slash + 1) + '@' + username.substring(0, slash) + '.' + domainName : (username.contains("@") ? username + '.' + domainName : username + '@' + domainName);
        return principalName;
    }

    private Set<GrantedAuthority> resolveGroups(String domainDN, String userDN, DirContext context) throws NamingException {
        LOGGER.finer("Looking up group of " + userDN);
        Attributes id = context.getAttributes(userDN, new String[]{"tokenGroups", "memberOf", "CN"});
        Attribute tga = id.get("tokenGroups");
        if (tga == null) {
            LOGGER.warning("Failed to retrieve tokenGroups for " + userDN);
            HashSet<GrantedAuthority> r = new HashSet<GrantedAuthority>();
            r.add((GrantedAuthority)new GrantedAuthorityImpl("unable-to-retrieve-tokenGroups"));
            return r;
        }
        StringBuilder query = new StringBuilder("(|");
        ArrayList<byte[]> sids = new ArrayList<byte[]>();
        NamingEnumeration<?> tokenGroups = tga.getAll();
        while (tokenGroups.hasMore()) {
            byte[] gsid = (byte[])tokenGroups.next();
            query.append("(objectSid={" + sids.size() + "})");
            sids.add(gsid);
        }
        tokenGroups.close();
        query.append(")");
        HashSet<GrantedAuthority> groups = new HashSet<GrantedAuthority>();
        NamingEnumeration<SearchResult> renum = new LDAPSearchBuilder(context, domainDN).subTreeScope().returns("cn").search(query.toString(), sids.toArray());
        while (renum.hasMore()) {
            Attributes a = renum.next().getAttributes();
            Attribute cn = a.get("cn");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(userDN + " is a member of " + cn);
            }
            groups.add((GrantedAuthority)new GrantedAuthorityImpl(cn.get().toString()));
        }
        renum.close();
        LOGGER.fine("Stage 2: looking up via memberOf");
        Stack<Attributes> q = new Stack<Attributes>();
        q.push(id);
        while (!q.isEmpty()) {
            Attributes identity = (Attributes)q.pop();
            LOGGER.finer("Looking up group of " + identity);
            Attribute memberOf = identity.get("memberOf");
            if (memberOf == null) continue;
            for (int i = 0; i < memberOf.size(); ++i) {
                Attributes group = context.getAttributes("\"" + memberOf.get(i) + '\"', new String[]{"CN", "memberOf"});
                Attribute cn = group.get("CN");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(cn.get() + " is a member of " + memberOf.get(i));
                }
                if (!groups.add((GrantedAuthority)new GrantedAuthorityImpl(cn.get().toString()))) continue;
                q.add(group);
            }
        }
        return groups;
    }

    static String toDC(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }

    static class GroupCacheEntry {
        final ActiveDirectoryGroupDetails detail;
        long timestamp = System.currentTimeMillis();

        GroupCacheEntry(String name) {
            this.detail = new ActiveDirectoryGroupDetails(name);
        }

        public boolean isStale() {
            return System.currentTimeMillis() - this.timestamp > TimeUnit2.MINUTES.toMillis(10L);
        }
    }
}

