/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.sun.jndi.ldap.LdapCtxFactory;
import com4j.typelibs.ado20.ClassFactory;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.active_directory.AbstractActiveDirectoryAuthenticationProvider;
import hudson.plugins.active_directory.ActiveDirectoryUnixAuthenticationProvider;
import hudson.plugins.active_directory.Messages;
import hudson.plugins.active_directory.SocketInfo;
import hudson.plugins.active_directory.TrustAllSocketFactory;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class ActiveDirectorySecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String domain;
    public final String site;
    public final String bindName;
    public final Secret bindPassword;
    public final String server;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectorySecurityRealm.class.getName());
    public static String DOMAIN_CONTROLLERS = System.getProperty(ActiveDirectorySecurityRealm.class.getName() + ".domainControllers");

    @DataBoundConstructor
    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server) {
        this.domain = Util.fixEmpty((String)domain);
        this.site = Util.fixEmpty((String)site);
        this.bindName = Util.fixEmpty((String)bindName);
        this.bindPassword = Secret.fromString((String)Util.fixEmpty((String)bindPassword));
        server = Util.fixEmpty((String)server);
        if (server != null && !server.contains(":")) {
            server = server + ":3268";
        }
        this.server = server;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
        Binding binding = new Binding();
        binding.setVariable("realm", (Object)this);
        builder.parse(((Object)((Object)this)).getClass().getResourceAsStream("ActiveDirectory.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return new SecurityRealm.SecurityComponents((AuthenticationManager)ActiveDirectorySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)context), (UserDetailsService)ActiveDirectorySecurityRealm.findBean(UserDetailsService.class, (ApplicationContext)context));
    }

    public DesciprotrImpl getDescriptor() {
        return (DesciprotrImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthTest(StaplerRequest req, StaplerResponse rsp, @QueryParameter String username, @QueryParameter String password) throws IOException, ServletException {
        StringWriter out;
        block11: {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                AbstractActiveDirectoryAuthenticationProvider uds = this.getAuthenticationProvider();
                if (uds instanceof ActiveDirectoryUnixAuthenticationProvider) {
                    ActiveDirectoryUnixAuthenticationProvider p = (ActiveDirectoryUnixAuthenticationProvider)uds;
                    DesciprotrImpl descriptor = this.getDescriptor();
                    try {
                        pw.println("Domain=" + this.domain + " site=" + this.site);
                        List<SocketInfo> ldapServers = descriptor.obtainLDAPServer(this.domain, this.site, this.server);
                        pw.println("List of domain controllers: " + ldapServers);
                        SocketInfo preferredServer = this.server != null ? new SocketInfo(this.server) : null;
                        for (SocketInfo ldapServer : ldapServers) {
                            pw.println("Trying a domain controller at " + ldapServer);
                            try {
                                UserDetails d = p.retrieveUser(username, password, this.domain, Collections.singletonList(ldapServer), preferredServer);
                                pw.println("Authenticated as " + d);
                            }
                            catch (AuthenticationException e) {
                                e.printStackTrace(pw);
                            }
                        }
                        break block11;
                    }
                    catch (NamingException e) {
                        pw.println("Failing to resolve domain controllers");
                        e.printStackTrace(pw);
                        break block11;
                    }
                }
                pw.println("Using Windows ADSI. No diagnostics available.");
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        req.setAttribute("output", (Object)out.toString());
        req.getView((Object)this, "test.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadGroupByGroupname(groupname);
    }

    public AbstractActiveDirectoryAuthenticationProvider getAuthenticationProvider() {
        return (AbstractActiveDirectoryAuthenticationProvider)this.getSecurityComponents().userDetails;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getAuthenticationProvider().loadUserByUsername(username);
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        return this.getAuthenticationProvider().retrieveUser(username, new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DesciprotrImpl
    extends Descriptor<SecurityRealm> {
        private static boolean WARNED = false;
        private static final List<SocketInfo> CANDIDATES = Arrays.asList(new SocketInfo("_gc._tcp.", 3269), new SocketInfo("_ldap._tcp.", 636));

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/active-directory/help/realm.html";
        }

        public boolean canDoNativeAuth() {
            if (!Functions.isWindows()) {
                return false;
            }
            try {
                ClassFactory.createConnection().dispose();
                return true;
            }
            catch (Throwable t) {
                if (!WARNED) {
                    LOGGER.log(Level.INFO, "COM4J isn't working. Falling back to non-native authentication", t);
                    WARNED = true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public FormValidation doValidate(@QueryParameter(fixEmpty=true) String domain, @QueryParameter(fixEmpty=true) String site, @QueryParameter(fixEmpty=true) String bindName, @QueryParameter(fixEmpty=true) String bindPassword, @QueryParameter(fixEmpty=true) String server) throws IOException, ServletException, NamingException {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                String[] names;
                Functions.checkPermission((Permission)Hudson.ADMINISTER);
                String n = Util.fixEmptyAndTrim((String)domain);
                if (n == null) {
                    FormValidation formValidation = FormValidation.error((String)"No domain name set");
                    return formValidation;
                }
                Secret password = Secret.fromString((String)bindPassword);
                if (bindName != null && password == null) {
                    FormValidation formValidation = FormValidation.error((String)"DN is specified but not password");
                    return formValidation;
                }
                for (String name : names = n.split(",")) {
                    FormValidation formValidation;
                    List<SocketInfo> servers;
                    Object ns;
                    DirContext ictx;
                    if (!name.endsWith(".")) {
                        name = name + '.';
                    }
                    try {
                        LOGGER.fine("Attempting to resolve " + name + " to NS record");
                        ictx = this.createDNSLookupContext();
                        Attributes attributes = ictx.getAttributes(name, new String[]{"NS"});
                        ns = attributes.get("NS");
                        if (ns == null) {
                            LOGGER.fine("Attempting to resolve " + name + " to A record");
                            attributes = ictx.getAttributes(name, new String[]{"A"});
                            Attribute a = attributes.get("A");
                            if (a == null) {
                                throw new NamingException(name + " doesn't look like a domain name");
                            }
                        }
                        LOGGER.fine(name + " resolved to " + ns.get());
                    }
                    catch (NamingException e) {
                        LOGGER.log(Level.WARNING, "Failed to resolve " + name + " to A record", e);
                        ns = FormValidation.error((Throwable)e, (String)(name + " doesn't look like a valid domain name"));
                        Thread.currentThread().setContextClassLoader(ccl);
                        return ns;
                    }
                    try {
                        servers = this.obtainLDAPServer(ictx, name, site, server);
                    }
                    catch (NamingException e) {
                        String msg = site == null ? "No LDAP server was found in " + name : "No LDAP server was found in the " + site + " site of " + name;
                        LOGGER.log(Level.WARNING, msg, e);
                        formValidation = FormValidation.error((Throwable)e, (String)msg);
                        Thread.currentThread().setContextClassLoader(ccl);
                        return formValidation;
                    }
                    if (bindName != null) {
                        SocketInfo prefSock = server == null ? null : new SocketInfo(server);
                        try {
                            this.bind(bindName, Secret.toString((Secret)password), servers, prefSock).close();
                            continue;
                        }
                        catch (BadCredentialsException e) {
                            formValidation = FormValidation.error((Throwable)e, (String)"Bad bind username or password");
                            Thread.currentThread().setContextClassLoader(ccl);
                            return formValidation;
                        }
                        catch (Exception e) {
                            formValidation = FormValidation.error((Throwable)e, (String)e.getMessage());
                            Thread.currentThread().setContextClassLoader(ccl);
                            return formValidation;
                        }
                    }
                    IOException error = null;
                    for (SocketInfo si : servers) {
                        try {
                            si.connect().close();
                            break;
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINE, "Failed to connect to " + si, e);
                            error = e;
                        }
                    }
                    if (error == null) continue;
                    LOGGER.log(Level.WARNING, "Failed to connect to " + servers, error);
                    FormValidation formValidation2 = FormValidation.error((Throwable)error, (String)("Failed to connect to " + servers));
                    return formValidation2;
                }
                FormValidation formValidation = FormValidation.ok((String)"Success");
                return formValidation;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }

        public DirContext bind(String principalName, String password, List<SocketInfo> ldapServers, SocketInfo preferredServer) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("java.naming.referral", "follow");
            props.put("java.naming.ldap.attributes.binary", "tokenGroups objectSid");
            NamingException error = null;
            if (preferredServer != null) {
                try {
                    LdapContext context = this.bind(principalName, password, preferredServer, props);
                    LOGGER.fine("Bound to " + preferredServer);
                    return context;
                }
                catch (NamingException e) {
                    LOGGER.log(Level.WARNING, "Failed to bind to preferred server " + preferredServer, e);
                    error = e;
                }
            }
            for (SocketInfo ldapServer : ldapServers) {
                try {
                    LdapContext context = this.bind(principalName, password, ldapServer, props);
                    LOGGER.fine("Bound to " + ldapServer);
                    return context;
                }
                catch (NamingException e) {
                    LOGGER.log(Level.WARNING, "Failed to bind to " + ldapServer, e);
                    error = e;
                }
            }
            throw new BadCredentialsException("Either no such user '" + principalName + "' or incorrect password", (Throwable)error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LdapContext bind(String principalName, String password, SocketInfo server, Hashtable<String, String> props) throws NamingException {
            String ldapUrl = "ldap://" + server + '/';
            String oldName = Thread.currentThread().getName();
            Thread.currentThread().setName("Connecting to " + ldapUrl + " : " + oldName);
            LOGGER.fine("Connecting to " + ldapUrl);
            try {
                LdapContext context = (LdapContext)LdapCtxFactory.getLdapCtxInstance(ldapUrl, props);
                try {
                    StartTlsResponse rsp = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
                    rsp.negotiate((SSLSocketFactory)TrustAllSocketFactory.getDefault());
                    LOGGER.fine("Connection upgraded to TLS");
                }
                catch (NamingException e) {
                    LOGGER.log(Level.FINE, "Failed to start TLS. Authentication will be done via plain-text LDAP", e);
                    context.addToEnvironment("java.naming.ldap.factory.socket", null);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failed to start TLS. Authentication will be done via plain-text LDAP", e);
                    context.addToEnvironment("java.naming.ldap.factory.socket", null);
                }
                context.addToEnvironment("java.naming.security.principal", principalName);
                context.addToEnvironment("java.naming.security.credentials", password);
                LdapContext ldapContext = context;
                return ldapContext;
            }
            finally {
                Thread.currentThread().setName(oldName);
            }
        }

        public DirContext createDNSLookupContext() throws NamingException {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            return new InitialDirContext(env);
        }

        public List<SocketInfo> obtainLDAPServer(String domainName, String site, String preferredServer) throws NamingException {
            return this.obtainLDAPServer(this.createDNSLookupContext(), domainName, site, preferredServer);
        }

        public List<SocketInfo> obtainLDAPServer(DirContext ictx, String domainName, String site, String preferredServer) throws NamingException {
            if (DOMAIN_CONTROLLERS != null) {
                ArrayList<SocketInfo> r = new ArrayList<SocketInfo>();
                for (String token : DOMAIN_CONTROLLERS.split(",")) {
                    String[] x = token.trim().split(":");
                    if (x.length != 2) {
                        throw new NamingException("Invalid domain controller override: " + token);
                    }
                    r.add(new SocketInfo(x[0], Integer.parseInt(x[1])));
                }
                return r;
            }
            String ldapServer = null;
            Attribute a = null;
            NamingException failure = null;
            for (SocketInfo candidate : CANDIDATES) {
                ldapServer = candidate.host + (site != null ? site + "._sites." : "") + domainName;
                LOGGER.fine("Attempting to resolve " + ldapServer + " to SRV record");
                try {
                    Attributes attributes = ictx.getAttributes(ldapServer, new String[]{"SRV"});
                    a = attributes.get("SRV");
                    if (a == null) continue;
                    break;
                }
                catch (NamingException e) {
                    failure = e;
                }
            }
            int priority = -1;
            ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
            if (preferredServer != null) {
                result.add(new SocketInfo(preferredServer));
            }
            if (a != null) {
                NamingEnumeration<?> ne = a.getAll();
                while (ne.hasMoreElements()) {
                    String record = ne.next().toString();
                    LOGGER.fine("SRV record found: " + record);
                    String[] fields = record.split(" ");
                    int p = Integer.parseInt(fields[0]);
                    if (priority == -1 || p < priority) {
                        priority = p;
                        result.clear();
                    }
                    if (priority != p) continue;
                    String hostName = fields[3];
                    if (hostName.endsWith(".")) {
                        hostName = hostName.substring(0, hostName.length() - 1);
                    }
                    result.add(new SocketInfo(hostName, Integer.parseInt(fields[2])));
                }
            }
            if (result.isEmpty()) {
                NamingException x = new NamingException("No SRV record found for " + ldapServer);
                if (failure != null) {
                    x.initCause(failure);
                }
                throw x;
            }
            LOGGER.fine(ldapServer + " resolved to " + result);
            return result;
        }
    }
}

