/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.active_directory;

import com.sun.jndi.ldap.LdapCtxFactory;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.active_directory.ActiveDirectoryUnixAuthenticationProvider;
import hudson.plugins.active_directory.GroupDetailsService;
import hudson.plugins.active_directory.Messages;
import hudson.plugins.active_directory.SocketInfo;
import hudson.plugins.active_directory.TrustAllSocketFactory;
import hudson.security.GroupDetails;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class ActiveDirectorySecurityRealm
extends SecurityRealm {
    public final String domain;
    public final String site;
    public final String bindName;
    public final Secret bindPassword;
    public final String server;
    private static final Logger LOGGER = Logger.getLogger(ActiveDirectorySecurityRealm.class.getName());
    public static String DOMAIN_CONTROLLERS = System.getProperty(ActiveDirectorySecurityRealm.class.getName() + ".domainControllers");

    @DataBoundConstructor
    public ActiveDirectorySecurityRealm(String domain, String site, String bindName, String bindPassword, String server) {
        this.domain = Util.fixEmpty((String)domain);
        this.site = Util.fixEmpty((String)site);
        this.bindName = Util.fixEmpty((String)bindName);
        this.server = Util.fixEmpty((String)server);
        this.bindPassword = Secret.fromString((String)Util.fixEmpty((String)bindPassword));
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        BeanBuilder builder = new BeanBuilder(((Object)((Object)this)).getClass().getClassLoader());
        Binding binding = new Binding();
        binding.setVariable("realm", (Object)this);
        builder.parse(((Object)((Object)this)).getClass().getResourceAsStream("ActiveDirectory.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return new SecurityRealm.SecurityComponents((AuthenticationManager)ActiveDirectorySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)context), (UserDetailsService)ActiveDirectorySecurityRealm.findBean(UserDetailsService.class, (ApplicationContext)context));
    }

    public DesciprotrImpl getDescriptor() {
        return (DesciprotrImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthTest(StaplerRequest req, StaplerResponse rsp, @QueryParameter String username, @QueryParameter String password) throws IOException, ServletException {
        StringWriter out;
        block11: {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                UserDetailsService uds = this.getSecurityComponents().userDetails;
                if (uds instanceof ActiveDirectoryUnixAuthenticationProvider) {
                    ActiveDirectoryUnixAuthenticationProvider p = (ActiveDirectoryUnixAuthenticationProvider)uds;
                    DesciprotrImpl descriptor = this.getDescriptor();
                    try {
                        pw.println("Domain=" + this.domain + " site=" + this.site);
                        List<SocketInfo> ldapServers = descriptor.obtainLDAPServer(this.domain, this.site);
                        pw.println("List of domain controllers: " + ldapServers);
                        for (SocketInfo ldapServer : ldapServers) {
                            pw.println("Trying a domain controller at " + ldapServer);
                            try {
                                UserDetails d = p.retrieveUser(username, password, this.domain, Collections.singletonList(ldapServer));
                                pw.println("Authenticated as " + d);
                            }
                            catch (AuthenticationException e) {
                                e.printStackTrace(pw);
                            }
                        }
                        break block11;
                    }
                    catch (NamingException e) {
                        pw.println("Failing to resolve domain controllers");
                        e.printStackTrace(pw);
                        break block11;
                    }
                }
                pw.println("Using Windows ADSI. No diagnostics available.");
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        req.setAttribute("output", (Object)out.toString());
        req.getView((Object)this, "test.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        GroupDetailsService groupDetailsService = (GroupDetailsService)this.getSecurityComponents().userDetails;
        return groupDetailsService.loadGroupByGroupname(groupname);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DesciprotrImpl
    extends Descriptor<SecurityRealm> {
        private static final List<SocketInfo> CANDIDATES = Arrays.asList(new SocketInfo("_gc._tcp.", 3269), new SocketInfo("_ldap._tcp.", 636));

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/active-directory/help/realm.html";
        }

        public boolean canDoNativeAuth() {
            return Functions.isWindows() && "32".equals(System.getProperty("sun.arch.data.model"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public FormValidation doValidate(@QueryParameter(fixEmpty=true) String domain, @QueryParameter(fixEmpty=true) String site, @QueryParameter(fixEmpty=true) String bindName, @QueryParameter(fixEmpty=true) String bindPassword, @QueryParameter(fixEmpty=true) String server) throws IOException, ServletException, NamingException {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                String[] names;
                Functions.checkPermission((Permission)Hudson.ADMINISTER);
                String n = Util.fixEmptyAndTrim((String)domain);
                if (n == null) {
                    FormValidation formValidation = FormValidation.error((String)"No domain name set");
                    return formValidation;
                }
                Secret password = Secret.fromString((String)bindPassword);
                if (bindName != null && password == null) {
                    FormValidation formValidation = FormValidation.error((String)"DN is specified but not password");
                    return formValidation;
                }
                for (String name : names = n.split(",")) {
                    String msg;
                    List<SocketInfo> servers;
                    Object a;
                    DirContext ictx;
                    if (!name.endsWith(".")) {
                        name = name + '.';
                    }
                    try {
                        LOGGER.fine("Attempting to resolve " + name + " to A record");
                        ictx = this.createDNSLookupContext();
                        Attributes attributes = ictx.getAttributes(name, new String[]{"A"});
                        a = attributes.get("A");
                        if (a == null) {
                            throw new NamingException();
                        }
                        LOGGER.fine(name + " resolved to " + a.get());
                    }
                    catch (NamingException e) {
                        LOGGER.log(Level.WARNING, "Failed to resolve " + name + " to A record", e);
                        a = FormValidation.error((Throwable)e, (String)(name + " doesn't look like a valid domain name"));
                        Thread.currentThread().setContextClassLoader(ccl);
                        return a;
                    }
                    try {
                        servers = this.obtainLDAPServer(ictx, name, site);
                    }
                    catch (NamingException e) {
                        msg = site == null ? "No LDAP server was found in " + name : "No LDAP server was found in the " + site + " site of " + name;
                        LOGGER.log(Level.WARNING, msg, e);
                        FormValidation formValidation = FormValidation.error((Throwable)e, (String)msg);
                        Thread.currentThread().setContextClassLoader(ccl);
                        return formValidation;
                    }
                    if (bindName != null) {
                        try {
                            this.bind(bindName, Secret.toString((Secret)password), servers, server).close();
                            continue;
                        }
                        catch (BadCredentialsException e) {
                            msg = FormValidation.error((Throwable)e, (String)"Bad bind username or password");
                            Thread.currentThread().setContextClassLoader(ccl);
                            return msg;
                        }
                        catch (Exception e) {
                            msg = FormValidation.error((Throwable)e, (String)e.getMessage());
                            Thread.currentThread().setContextClassLoader(ccl);
                            return msg;
                        }
                    }
                    IOException error = null;
                    for (SocketInfo si : servers) {
                        try {
                            si.connect().close();
                            break;
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINE, "Failed to connect to " + si, e);
                            error = e;
                        }
                    }
                    if (error == null) continue;
                    LOGGER.log(Level.WARNING, "Failed to connect to " + servers, error);
                    FormValidation formValidation = FormValidation.error((Throwable)error, (String)("Failed to connect to " + servers));
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.ok((String)"Success");
                return formValidation;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }

        public DirContext bind(String principalName, String password, List<SocketInfo> ldapServers, String server) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("java.naming.security.principal", principalName);
            props.put("java.naming.security.credentials", password);
            props.put("java.naming.referral", "follow");
            props.put("java.naming.ldap.factory.socket", TrustAllSocketFactory.class.getName());
            NamingException error = null;
            if (server != null && !server.equals("")) {
                try {
                    DirContext context = LdapCtxFactory.getLdapCtxInstance("ldaps://" + server + '/', props);
                    LOGGER.fine("Bound to " + server);
                    return context;
                }
                catch (NamingException e) {
                    LOGGER.log(Level.WARNING, "Failed to bind to " + server, e);
                    error = e;
                }
            }
            for (SocketInfo ldapServer : ldapServers) {
                try {
                    DirContext context = LdapCtxFactory.getLdapCtxInstance("ldaps://" + ldapServer + '/', props);
                    LOGGER.fine("Bound to " + ldapServer);
                    return context;
                }
                catch (NamingException e) {
                    LOGGER.log(Level.WARNING, "Failed to bind to " + ldapServer, e);
                    error = e;
                }
            }
            throw new BadCredentialsException("Either no such user '" + principalName + "' or incorrect password", error);
        }

        public DirContext createDNSLookupContext() throws NamingException {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            return new InitialDirContext(env);
        }

        public List<SocketInfo> obtainLDAPServer(String domainName, String site) throws NamingException {
            return this.obtainLDAPServer(this.createDNSLookupContext(), domainName, site);
        }

        public List<SocketInfo> obtainLDAPServer(DirContext ictx, String domainName, String site) throws NamingException {
            if (DOMAIN_CONTROLLERS != null) {
                ArrayList<SocketInfo> r = new ArrayList<SocketInfo>();
                for (String token : DOMAIN_CONTROLLERS.split(",")) {
                    String[] x = token.trim().split(":");
                    if (x.length != 2) {
                        throw new NamingException("Invalid domain controller override: " + token);
                    }
                    r.add(new SocketInfo(x[0], Integer.parseInt(x[1])));
                }
                return r;
            }
            String ldapServer = null;
            Attribute a = null;
            SocketInfo mode = null;
            NamingException failure = null;
            Iterator<SocketInfo> i$ = CANDIDATES.iterator();
            while (i$.hasNext()) {
                SocketInfo candidate;
                mode = candidate = i$.next();
                ldapServer = candidate.host + (site != null ? site + "._sites." : "") + domainName;
                LOGGER.fine("Attempting to resolve " + ldapServer + " to SRV record");
                try {
                    Attributes attributes = ictx.getAttributes(ldapServer, new String[]{"SRV"});
                    a = attributes.get("SRV");
                    if (a == null) continue;
                    break;
                }
                catch (NamingException e) {
                    failure = e;
                }
            }
            if (a == null) {
                if (failure != null) {
                    throw failure;
                }
                throw new NamingException();
            }
            int priority = -1;
            ArrayList<SocketInfo> result = new ArrayList<SocketInfo>();
            NamingEnumeration<?> ne = a.getAll();
            while (ne.hasMoreElements()) {
                String[] fields = ne.next().toString().split(" ");
                int p = Integer.parseInt(fields[0]);
                if (priority == -1 || p < priority) {
                    priority = p;
                    result.clear();
                }
                if (priority != p) continue;
                String hostName = fields[3];
                if (hostName.endsWith(".")) {
                    hostName = hostName.substring(0, hostName.length() - 1);
                }
                result.add(new SocketInfo(hostName, mode.port));
            }
            if (result.isEmpty()) {
                throw new NamingException("No SRV record found for " + ldapServer);
            }
            LOGGER.fine(ldapServer + " resolved to " + result);
            return result;
        }
    }
}

