/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.accurev.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import java.util.Date;
import jenkins.model.Jenkins;

public class AccurevUtils {
    public static String cleanAccurevPath(String str) {
        return str.replace("\\", "/").replaceFirst("^/[.]/", "");
    }

    @CheckForNull
    public static Node workspaceToNode(FilePath workspace) {
        Computer computer = workspace.toComputer();
        Node node = null;
        if (null != computer) {
            node = computer.getNode();
        }
        return null != node ? node : Jenkins.getInstance();
    }

    public static String getRootPath(FilePath workspace) {
        Node n = AccurevUtils.workspaceToNode(workspace);
        String path = null;
        FilePath filePath = null;
        if (null != n) {
            filePath = n.getRootPath();
        }
        if (null != filePath) {
            path = filePath.getRemote();
        }
        return path;
    }

    public static Date convertAccurevTimestamp(@CheckForNull String timeInSeconds) {
        if (timeInSeconds == null) {
            return null;
        }
        try {
            long time = Long.parseLong(timeInSeconds);
            long date = time * 1000L;
            return new Date(date);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

