/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.accurev;

import hudson.EnvVars;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AccurevTool
extends ToolInstallation
implements NodeSpecific<AccurevTool>,
EnvironmentSpecific<AccurevTool> {
    public static final transient String DEFAULT = "Default";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AccurevTool.class.getName());

    @DataBoundConstructor
    public AccurevTool(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    private static AccurevTool[] getInstallations(DescriptorImpl descriptor) {
        AccurevTool[] installations;
        try {
            installations = (AccurevTool[])descriptor.getInstallations();
        }
        catch (NullPointerException e) {
            installations = new AccurevTool[]{};
        }
        return installations;
    }

    public static AccurevTool getDefaultInstallation() {
        Jenkins jenkinsInstance = Jenkins.getInstance();
        DescriptorImpl AccurevTools = (DescriptorImpl)jenkinsInstance.getDescriptorByType(DescriptorImpl.class);
        AccurevTool tool = AccurevTools.getInstallation(DEFAULT);
        if (tool != null) {
            return tool;
        }
        AccurevTool[] installations = (AccurevTool[])AccurevTools.getInstallations();
        if (installations.length > 0) {
            return installations[0];
        }
        AccurevTool.onLoaded();
        return ((AccurevTool[])AccurevTools.getInstallations())[0];
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void onLoaded() {
        Jenkins jenkinsInstance = Jenkins.getInstance();
        DescriptorImpl descriptor = (DescriptorImpl)jenkinsInstance.getDescriptor(AccurevTool.class);
        AccurevTool[] installations = AccurevTool.getInstallations(descriptor);
        if (installations != null && installations.length > 0) {
            return;
        }
        String defaultAccurevExe = "accurev";
        AccurevTool tool = new AccurevTool(DEFAULT, defaultAccurevExe, Collections.emptyList());
        if (descriptor != null) {
            descriptor.setInstallations(new AccurevTool[]{tool});
            descriptor.save();
        }
    }

    public AccurevTool forNode(@Nonnull Node node, TaskListener log) throws IOException, InterruptedException {
        return new AccurevTool(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public AccurevTool forEnvironment(EnvVars environment) {
        return new AccurevTool(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        Jenkins jenkinsInstance = Jenkins.getInstance();
        return (DescriptorImpl)jenkinsInstance.getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    @Symbol(value={"accurev"})
    public static class DescriptorImpl
    extends ToolDescriptor<AccurevTool> {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return "Accurev";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setInstallations(req.bindJSONToList(this.clazz, json.get("tool")).toArray(new AccurevTool[0]));
            this.save();
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            String path = value.getPath();
            return FormValidation.validateExecutable((String)path);
        }

        public AccurevTool getInstallation(String name) {
            for (AccurevTool i : (AccurevTool[])this.getInstallations()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

