/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.accurev;

import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Project;
import hudson.plugins.accurev.AccurevSCM;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.accurev.util.UUIDUtils;

public class AccurevPlugin {
    private static final Logger LOGGER = Logger.getLogger(AccurevPlugin.class.getName());

    @Initializer(after=InitMilestone.JOB_LOADED, before=InitMilestone.COMPLETED)
    public static void migrateJobsToServerUUID() throws Exception {
        Jenkins jenkins = Jenkins.getInstance();
        boolean changed = false;
        AccurevSCM.AccurevSCMDescriptor descriptor = (AccurevSCM.AccurevSCMDescriptor)jenkins.getDescriptorByType(AccurevSCM.AccurevSCMDescriptor.class);
        for (Project p : jenkins.getAllItems(Project.class)) {
            AccurevSCM scm;
            String serverUUID;
            if (!(p.getScm() instanceof AccurevSCM) || !UUIDUtils.isNotValid(serverUUID = (scm = (AccurevSCM)p.getScm()).getServerUUID()) && descriptor.getServer(serverUUID) != null) continue;
            AccurevSCM.AccurevServer server = descriptor.getServer(scm.getServerName());
            if (server == null) {
                LOGGER.warning("No server found with that name, Project: " + p.getName() + " Server Name: " + scm.getServerName());
                continue;
            }
            changed = true;
            String uuid = server.getUuid();
            scm.setServerUUID(uuid);
            p.save();
        }
        if (changed) {
            descriptor.save();
        }
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void migrateServersToCredentials() throws Exception {
        boolean changed = false;
        AccurevSCM.AccurevSCMDescriptor descriptor = AccurevSCM.configuration();
        boolean migratedCredentials = false;
        for (AccurevSCM.AccurevServer server : descriptor.getServers()) {
            if (!server.migrateCredentials()) continue;
            changed = true;
        }
        if (changed) {
            descriptor.save();
            SystemCredentialsProvider.getInstance().save();
        }
    }
}

