/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.parsers.xml;

import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevWorkspace;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ParseShowWorkspaces
implements AccurevLauncher.ICmdOutputXmlParser<Map<String, AccurevWorkspace>, Void> {
    @Override
    public Map<String, AccurevWorkspace> parse(XmlPullParser parser, Void context) throws AccurevLauncher.UnhandledAccurevCommandOutput, IOException, XmlPullParserException {
        HashMap<String, AccurevWorkspace> workspaces = new HashMap<String, AccurevWorkspace>();
        while (parser.next() != 1) {
            if (parser.getEventType() != 2 || !"Element".equalsIgnoreCase(parser.getName())) continue;
            String name = parser.getAttributeValue("", "Name");
            String storage = parser.getAttributeValue("", "Storage");
            String host = parser.getAttributeValue("", "Host");
            String streamNumber = parser.getAttributeValue("", "Stream");
            String depot = parser.getAttributeValue("", "depot");
            try {
                Long streamNumberOrNull = streamNumber == null ? null : Long.valueOf(streamNumber);
                workspaces.put(name, new AccurevWorkspace(depot, streamNumberOrNull, name, host, storage));
            }
            catch (NumberFormatException e) {
                throw new AccurevLauncher.UnhandledAccurevCommandOutput(e);
            }
        }
        return workspaces;
    }
}

