/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.parsers.xml;

import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jenkins.plugins.accurev.util.AccurevUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ParseShowStreams
implements AccurevLauncher.ICmdOutputXmlParser<Map<String, AccurevStream>, String> {
    @Override
    public Map<String, AccurevStream> parse(XmlPullParser parser, String depot) throws AccurevLauncher.UnhandledAccurevCommandOutput, IOException, XmlPullParserException {
        HashMap<String, AccurevStream> streams = new HashMap<String, AccurevStream>();
        while (parser.next() != 1) {
            if (parser.getEventType() != 2 || !"stream".equalsIgnoreCase(parser.getName())) continue;
            String streamName = parser.getAttributeValue("", "name");
            String streamNumberStr = parser.getAttributeValue("", "streamNumber");
            String basisStreamName = parser.getAttributeValue("", "basis");
            String basisStreamNumberStr = parser.getAttributeValue("", "basisStreamNumber");
            String streamTypeStr = parser.getAttributeValue("", "type");
            String streamIsDynamic = parser.getAttributeValue("", "isDynamic");
            String streamTimeString = parser.getAttributeValue("", "time");
            Date streamTime = streamTimeString == null ? null : AccurevUtils.convertAccurevTimestamp(streamTimeString);
            String streamStartTimeString = parser.getAttributeValue("", "startTime");
            Date streamStartTime = streamTimeString == null ? null : AccurevUtils.convertAccurevTimestamp(streamStartTimeString);
            try {
                Long streamNumber = streamNumberStr == null ? null : Long.valueOf(streamNumberStr);
                Long basisStreamNumber = basisStreamNumberStr == null ? null : Long.valueOf(basisStreamNumberStr);
                AccurevStream.StreamType streamType = AccurevStream.StreamType.parseStreamType(streamTypeStr);
                boolean isDynamic = streamIsDynamic != null && Boolean.parseBoolean(streamIsDynamic);
                AccurevStream stream = new AccurevStream(streamName, streamNumber, depot, basisStreamName, basisStreamNumber, isDynamic, streamType, streamTime, streamStartTime);
                streams.put(streamName, stream);
            }
            catch (NumberFormatException e) {
                throw new AccurevLauncher.UnhandledAccurevCommandOutput(e);
            }
        }
        return streams;
    }
}

