/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.parsers.xml;

import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevReferenceTree;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParseShowReftrees
implements AccurevLauncher.ICmdOutputXmlParser<Map<String, AccurevReferenceTree>, Void> {
    @Override
    public Map<String, AccurevReferenceTree> parse(XmlPullParser parser, Void context) throws AccurevLauncher.UnhandledAccurevCommandOutput, IOException, XmlPullParserException {
        HashMap<String, AccurevReferenceTree> reftrees = new HashMap<String, AccurevReferenceTree>();
        while (parser.next() != 1) {
            if (parser.getEventType() != 2 || !"Element".equalsIgnoreCase(parser.getName())) continue;
            String name = parser.getAttributeValue("", "Name");
            String storage = parser.getAttributeValue("", "Storage");
            String host = parser.getAttributeValue("", "Host");
            String streamNumber = parser.getAttributeValue("", "Stream");
            String depot = parser.getAttributeValue("", "depot");
            try {
                Long streamNumberOrNull = streamNumber == null ? null : Long.valueOf(streamNumber);
                reftrees.put(name, new AccurevReferenceTree(depot, streamNumberOrNull, name, host, storage));
            }
            catch (NumberFormatException e) {
                throw new AccurevLauncher.UnhandledAccurevCommandOutput(e);
            }
        }
        return reftrees;
    }
}

