/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.parsers.xml;

import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevTransaction;
import java.io.IOException;
import java.util.List;
import jenkins.plugins.accurev.util.AccurevUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ParseHistory
implements AccurevLauncher.ICmdOutputXmlParser<Boolean, List<AccurevTransaction>> {
    @Override
    public Boolean parse(XmlPullParser parser, List<AccurevTransaction> context) throws AccurevLauncher.UnhandledAccurevCommandOutput, IOException, XmlPullParserException {
        AccurevTransaction resultTransaction = null;
        while (parser.next() != 1) {
            if (parser.getEventType() != 2) continue;
            if ("transaction".equalsIgnoreCase(parser.getName())) {
                resultTransaction = new AccurevTransaction();
                resultTransaction.setId(parser.getAttributeValue("", "id"));
                resultTransaction.setAction(parser.getAttributeValue("", "type"));
                resultTransaction.setDate(AccurevUtils.convertAccurevTimestamp(parser.getAttributeValue("", "time")));
                resultTransaction.setUser(parser.getAttributeValue("", "user"));
                continue;
            }
            if ("comment".equalsIgnoreCase(parser.getName()) && resultTransaction != null) {
                resultTransaction.setMsg(parser.nextText());
                continue;
            }
            if (!"version".equalsIgnoreCase(parser.getName()) || resultTransaction == null) continue;
            String path = parser.getAttributeValue("", "path");
            if (path != null) {
                path = AccurevUtils.cleanAccurevPath(path);
            }
            resultTransaction.addAffectedPath(path);
        }
        context.add(resultTransaction);
        return resultTransaction != null;
    }

    @Override
    public Boolean parseAll(XmlPullParser parser, List<AccurevTransaction> context) throws IOException, XmlPullParserException {
        AccurevTransaction resultTransaction = null;
        while (parser.next() != 1) {
            if (parser.getEventType() == 2) {
                String path;
                if ("transaction".equalsIgnoreCase(parser.getName())) {
                    resultTransaction = new AccurevTransaction();
                    resultTransaction.setId(parser.getAttributeValue("", "id"));
                    resultTransaction.setAction(parser.getAttributeValue("", "type"));
                    resultTransaction.setDate(AccurevUtils.convertAccurevTimestamp(parser.getAttributeValue("", "time")));
                    resultTransaction.setUser(parser.getAttributeValue("", "user"));
                } else if ("comment".equalsIgnoreCase(parser.getName()) && resultTransaction != null) {
                    resultTransaction.setMsg(parser.nextText());
                } else if ("version".equalsIgnoreCase(parser.getName()) && resultTransaction != null && (path = parser.getAttributeValue("", "path")) != null) {
                    resultTransaction.addAffectedPath(path);
                }
            }
            context.add(resultTransaction);
        }
        return context != null;
    }
}

