/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.parsers.output;

import hudson.plugins.accurev.AccurevLauncher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public final class ParseLastFewLines
implements AccurevLauncher.ICmdOutputParser<List<String>, Integer> {
    @Override
    public List<String> parse(InputStream cmdOutput, Integer numberOfLines) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        InputStreamReader stringReader = new InputStreamReader(cmdOutput, Charset.defaultCharset());
        int linesRemainingBeforeWeAreFull = numberOfLines;
        try (BufferedReader reader = new BufferedReader(stringReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(line);
                if (linesRemainingBeforeWeAreFull > 0) {
                    --linesRemainingBeforeWeAreFull;
                    continue;
                }
                result.removeFirst();
            }
        }
        return result;
    }
}

