/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.delegates;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.AccurevStream;
import hudson.plugins.accurev.AccurevWorkspace;
import hudson.plugins.accurev.RemoteWorkspaceDetails;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.cmd.ShowStreams;
import hudson.plugins.accurev.delegates.ReftreeDelegate;
import hudson.plugins.accurev.delegates.Relocation;
import hudson.plugins.accurev.parsers.xml.ParseShowWorkspaces;
import hudson.scm.PollingResult;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.xmlpull.v1.XmlPullParserFactory;

public class WorkspaceDelegate
extends ReftreeDelegate {
    private static final Logger logger = Logger.getLogger(WorkspaceDelegate.class.getName());

    public WorkspaceDelegate(AccurevSCM scm) {
        super(scm);
    }

    @Override
    public String getRefTree() {
        return null;
    }

    @Override
    protected PollingResult checkForChanges(Job<?, ?> project) throws IOException, InterruptedException, IllegalArgumentException {
        this.localStream = this.scm.getPollingStream(project, this.listener);
        return super.checkForChanges(project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Relocation checkForRelocation() throws IOException, InterruptedException {
        String depot = this.scm.getDepot();
        String _accurevWorkspace = this.scm.getWorkspace();
        Map<String, AccurevWorkspace> workspaces = this.getWorkspaces();
        Map<String, AccurevStream> streams = ShowStreams.getStreams(this.scm, _accurevWorkspace, this.server, this.accurevEnv, this.jenkinsWorkspace, this.listener, this.launcher);
        if (workspaces == null) {
            throw new IllegalArgumentException("Cannot determine workspace configuration information");
        }
        if (!workspaces.containsKey(_accurevWorkspace)) {
            throw new IllegalArgumentException("The specified workspace does not appear to exist!");
        }
        AccurevWorkspace accurevWorkspace = workspaces.get(_accurevWorkspace);
        if (!depot.equals(accurevWorkspace.getDepot())) {
            throw new IllegalArgumentException("The specified workspace, " + _accurevWorkspace + ", is based in the depot " + accurevWorkspace.getDepot() + " not " + depot);
        }
        if (this.scm.isIgnoreStreamParent()) {
            if (streams.isEmpty()) throw new IllegalArgumentException("Workspace stream not found " + _accurevWorkspace);
            AccurevStream workspaceStream = streams.values().iterator().next();
            accurevWorkspace.setStream(workspaceStream);
            String workspaceBasisStream = workspaceStream.getBasisName();
            if (streams.containsKey(workspaceBasisStream)) {
                workspaceStream.setParent(streams.get(workspaceBasisStream));
            } else {
                Map<String, AccurevStream> workspaceBasis = ShowStreams.getStreams(this.scm, workspaceBasisStream, this.server, this.accurevEnv, this.jenkinsWorkspace, this.listener, this.launcher);
                if (workspaceBasis == null) {
                    throw new IllegalArgumentException("Could not determine the workspace basis stream");
                }
                workspaceStream.setParent(workspaceBasis.get(workspaceBasisStream));
            }
        } else {
            for (AccurevStream accurevStream : streams.values()) {
                if (!accurevWorkspace.getStreamNumber().equals(accurevStream.getNumber())) continue;
                accurevWorkspace.setStream(accurevStream);
                break;
            }
        }
        RemoteWorkspaceDetails remoteDetails = this.getRemoteWorkspaceDetails();
        ArrayList<Relocation.RelocationOption> relocationOptions = new ArrayList<Relocation.RelocationOption>();
        for (WorkspaceRelocation workspaceRelocationvalue : WorkspaceRelocation.values()) {
            if (!workspaceRelocationvalue.isRequired(accurevWorkspace, remoteDetails, this.localStream)) continue;
            relocationOptions.add(workspaceRelocationvalue);
        }
        return new Relocation(relocationOptions, remoteDetails.getHostName(), this.accurevWorkingSpace.getRemote(), this.localStream);
    }

    private Map<String, AccurevWorkspace> getWorkspaces() throws IOException {
        this.listener.getLogger().println("Getting a list of workspaces...");
        String depot = this.scm.getDepot();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("show");
        Command.addServer(cmd, this.server);
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(depot);
        cmd.add("wspaces");
        XmlPullParserFactory parser = XmlParserFactory.getFactory();
        if (parser == null) {
            throw new IOException("No XML Parser");
        }
        return AccurevLauncher.runCommand("Show workspaces command", this.scm.getAccurevTool(), this.launcher, cmd, this.scm.getOptionalLock(), this.accurevEnv, this.jenkinsWorkspace, this.listener, logger, parser, new ParseShowWorkspaces(), null);
    }

    @Override
    protected boolean validateCheckout(Run<?, ?> build) {
        String workspace = this.scm.getWorkspace();
        if (StringUtils.isEmpty((String)workspace)) {
            this.listener.fatalError("Must specify a workspace");
            return false;
        }
        return true;
    }

    @Override
    protected String getPopulateFromMessage() {
        return "from workspace";
    }

    @Override
    protected ArgumentListBuilder getRelocateCommand() {
        ArgumentListBuilder chwscmd = new ArgumentListBuilder();
        chwscmd.add("chws");
        Command.addServer(chwscmd, this.server);
        chwscmd.add("-w");
        chwscmd.add(this.scm.getWorkspace());
        return chwscmd;
    }

    @Override
    protected boolean isSteamColorEnabled() {
        return true;
    }

    @Override
    protected String getStreamColorStream() {
        return this.scm.getWorkspace();
    }

    @Override
    protected String getStreamColor() {
        return "#FFEBB4";
    }

    @Override
    protected String getChangeLogStream() {
        return this.scm.getWorkspace();
    }

    @Override
    protected void buildEnvVarsCustom(Run<?, ?> build, Map<String, String> env) {
        env.put("ACCUREV_WORKSPACE", this.scm.getWorkspace());
    }

    private static enum WorkspaceRelocation implements Relocation.RelocationOption
    {
        HOST{

            @Override
            protected boolean isRequired(AccurevWorkspace accurevWorkspace, RemoteWorkspaceDetails remoteDetails, String localStream) {
                return !accurevWorkspace.getHost().equalsIgnoreCase(remoteDetails.getHostName());
            }

            @Override
            public void appendCommand(ArgumentListBuilder cmd, Relocation relocation) {
                cmd.add("-m");
                cmd.add(relocation.getNewHost());
            }
        }
        ,
        STORAGE{

            @Override
            protected boolean isRequired(AccurevWorkspace accurevWorkspace, RemoteWorkspaceDetails remoteDetails, String localStream) {
                String oldStorage = accurevWorkspace.getStorage().replace("/", remoteDetails.getFileSeparator()).replace("\\", remoteDetails.getFileSeparator());
                return !new File(oldStorage).equals(new File(remoteDetails.getPath()));
            }

            @Override
            public void appendCommand(ArgumentListBuilder cmd, Relocation relocation) {
                cmd.add("-l");
                cmd.add(relocation.getNewPath());
            }
        }
        ,
        REPARENT{

            @Override
            protected boolean isRequired(AccurevWorkspace accurevWorkspace, RemoteWorkspaceDetails remoteDetails, String localStream) {
                return !localStream.equals(accurevWorkspace.getStream().getParent().getName());
            }

            @Override
            public boolean isPopRequired() {
                return false;
            }

            @Override
            public void appendCommand(ArgumentListBuilder cmd, Relocation relocation) {
                cmd.add("-b");
                cmd.add(relocation.getNewParent());
            }
        };


        @Override
        public boolean isPopRequired() {
            return true;
        }

        protected abstract boolean isRequired(AccurevWorkspace var1, RemoteWorkspaceDetails var2, String var3);
    }
}

