/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.delegates;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.AccurevStream;
import hudson.plugins.accurev.CheckForChanges;
import hudson.plugins.accurev.cmd.ShowStreams;
import hudson.plugins.accurev.delegates.AbstractModeDelegate;
import hudson.scm.PollingResult;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;

public class StreamDelegate
extends AbstractModeDelegate {
    private static final Logger logger = Logger.getLogger(StreamDelegate.class.getName());

    public StreamDelegate(AccurevSCM scm) {
        super(scm);
    }

    @Override
    protected boolean checkout(Run<?, ?> build, File changeLogFile) throws IOException, InterruptedException {
        return true;
    }

    @Override
    protected String getPopulateFromMessage() {
        return "from stream";
    }

    @Override
    protected String getPopulateStream() {
        return this.localStream;
    }

    @Override
    protected boolean isSteamColorEnabled() {
        return true;
    }

    @Override
    protected String getStreamColorStream() {
        return this.localStream;
    }

    @Override
    protected String getStreamColor() {
        return "#FFFFFF";
    }

    @Override
    protected PollingResult checkForChanges(Job<?, ?> project) throws IOException, InterruptedException {
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            this.listener.getLogger().println("Project has never been built");
            return PollingResult.BUILD_NOW;
        }
        Date buildDate = lastBuild.getTimestamp().getTime();
        try {
            this.localStream = this.scm.getPollingStream(project, this.listener);
        }
        catch (IllegalArgumentException ex) {
            this.listener.getLogger().println(ex.getMessage());
            return PollingResult.NO_CHANGES;
        }
        Map<String, AccurevStream> streams = ShowStreams.getStreams(this.scm, this.localStream, this.server, this.accurevEnv, this.jenkinsWorkspace, this.listener, this.launcher);
        if (streams == null) {
            this.listener.getLogger().println("Could not retrieve any Streams from Accurev, please check credentials");
            return PollingResult.NO_CHANGES;
        }
        AccurevStream stream = streams.get(this.localStream);
        if (stream == null) {
            this.listener.getLogger().println("Tried to find '" + this.localStream + "' Stream, could not found it.");
            return PollingResult.NO_CHANGES;
        }
        do {
            if (!CheckForChanges.checkStreamForChanges(this.server, this.accurevEnv, this.jenkinsWorkspace, this.listener, this.launcher, stream, buildDate, logger, this.scm)) continue;
            return PollingResult.BUILD_NOW;
        } while ((stream = stream.getParent()) != null && stream.isReceivingChangesFromParent() && !this.scm.isIgnoreStreamParent());
        return PollingResult.NO_CHANGES;
    }
}

