/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.delegates;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.delegates.StreamDelegate;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class SnapshotDelegate
extends StreamDelegate {
    private static final Logger logger = Logger.getLogger(SnapshotDelegate.class.getName());
    private static final String DEFAULT_SNAPSHOT_NAME_FORMAT = "${JOB_NAME}_${BUILD_NUMBER}";
    private String snapshotName;

    public SnapshotDelegate(AccurevSCM scm) {
        super(scm);
    }

    private String calculateSnapshotName(Run<?, ?> build) throws IOException, InterruptedException {
        String snapshotNameFormat = this.scm.getSnapshotNameFormat();
        String actualFormat = StringUtils.isBlank((String)snapshotNameFormat) ? DEFAULT_SNAPSHOT_NAME_FORMAT : snapshotNameFormat.trim();
        EnvVars environment = build.getEnvironment(this.listener);
        return environment.expand(actualFormat);
    }

    @Override
    protected boolean checkout(Run<?, ?> build, File changeLogFile) throws IOException, InterruptedException {
        this.snapshotName = this.calculateSnapshotName(build);
        this.listener.getLogger().println("Creating snapshot: " + this.snapshotName + "...");
        build.getEnvironment(this.listener).put("ACCUREV_SNAPSHOT", this.snapshotName);
        ArgumentListBuilder mksnapcmd = new ArgumentListBuilder();
        mksnapcmd.add("mksnap");
        Command.addServer(mksnapcmd, this.server);
        mksnapcmd.add("-s");
        mksnapcmd.add(this.snapshotName);
        mksnapcmd.add("-b");
        mksnapcmd.add(this.localStream);
        mksnapcmd.add("-t");
        mksnapcmd.add("now");
        if (!AccurevLauncher.runCommand("Create snapshot command", this.scm.getAccurevTool(), this.launcher, mksnapcmd, this.scm.getOptionalLock(), this.accurevEnv, this.jenkinsWorkspace, this.listener, logger, true)) {
            return false;
        }
        this.listener.getLogger().println("Snapshot created successfully.");
        return true;
    }

    @Override
    protected boolean isSteamColorEnabled() {
        return false;
    }

    @Override
    protected String getPopulateFromMessage() {
        return "from snapshot";
    }

    @Override
    protected String getPopulateStream() {
        return this.snapshotName;
    }
}

