/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.delegates;

import hudson.util.ArgumentListBuilder;
import java.util.List;

public class Relocation {
    private final List<RelocationOption> relocationOptions;
    private final String newHost;
    private final String newPath;
    private final String newParent;

    public Relocation(List<RelocationOption> relocationOptions, String newHost, String newPath, String newParent) {
        this.relocationOptions = relocationOptions;
        this.newHost = newHost;
        this.newPath = newPath;
        this.newParent = newParent;
    }

    public boolean isRelocationRequired() {
        return !this.relocationOptions.isEmpty();
    }

    public String getNewParent() {
        return this.newParent;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public String getNewHost() {
        return this.newHost;
    }

    public boolean isPopRequired() {
        for (RelocationOption relocationOption : this.relocationOptions) {
            if (!relocationOption.isPopRequired()) continue;
            return true;
        }
        return false;
    }

    public void appendCommands(ArgumentListBuilder relocateCommand) {
        for (RelocationOption relocationOption : this.relocationOptions) {
            relocationOption.appendCommand(relocateCommand, this);
        }
    }

    public static interface RelocationOption {
        public boolean isPopRequired();

        public void appendCommand(ArgumentListBuilder var1, Relocation var2);
    }
}

