/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.delegates;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevReferenceTree;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.DetermineRemoteHostname;
import hudson.plugins.accurev.RemoteWorkspaceDetails;
import hudson.plugins.accurev.XmlConsolidateStreamChangeLog;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.cmd.Update;
import hudson.plugins.accurev.delegates.AbstractModeDelegate;
import hudson.plugins.accurev.delegates.Relocation;
import hudson.plugins.accurev.parsers.xml.ParseShowReftrees;
import hudson.remoting.Callable;
import hudson.scm.PollingResult;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.xmlpull.v1.XmlPullParserFactory;

public class ReftreeDelegate
extends AbstractModeDelegate {
    private static final Logger logger = Logger.getLogger(ReftreeDelegate.class.getName());
    protected boolean popRequired = false;
    private File updateLogFile;

    public ReftreeDelegate(AccurevSCM scm) {
        super(scm);
    }

    public String getRefTree() {
        return this.scm.getReftree();
    }

    @Override
    protected PollingResult checkForChanges(Job<?, ?> project) throws IOException, InterruptedException {
        try {
            Relocation relocation = this.checkForRelocation();
            if (relocation.isRelocationRequired()) {
                this.listener.getLogger().println("Relocation required triggering build");
                return PollingResult.BUILD_NOW;
            }
            if (Update.hasChanges(this.scm, this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, this.getRefTree()).booleanValue()) {
                return PollingResult.BUILD_NOW;
            }
            return PollingResult.NO_CHANGES;
        }
        catch (IllegalArgumentException ex) {
            this.listener.fatalError(ex.getMessage());
            return PollingResult.NO_CHANGES;
        }
    }

    protected Relocation checkForRelocation() throws IOException, InterruptedException {
        Map<String, AccurevReferenceTree> reftrees = this.getReftrees();
        String reftree = this.scm.getReftree();
        if (reftrees == null) {
            throw new IllegalArgumentException("Cannot determine reference tree configuration information");
        }
        if (!reftrees.containsKey(reftree)) {
            throw new IllegalArgumentException("The specified reference tree does not appear to exist!");
        }
        AccurevReferenceTree accurevReftree = reftrees.get(reftree);
        if (!this.scm.getDepot().equals(accurevReftree.getDepot())) {
            throw new IllegalArgumentException("The specified reference tree, " + reftree + ", is based in the depot " + accurevReftree.getDepot() + " not " + this.scm.getDepot());
        }
        RemoteWorkspaceDetails remoteDetails = this.getRemoteWorkspaceDetails();
        ArrayList<Relocation.RelocationOption> relocationOptions = new ArrayList<Relocation.RelocationOption>();
        for (RefTreeRelocation refTreeRelocation : RefTreeRelocation.values()) {
            if (!refTreeRelocation.isRequired(accurevReftree, remoteDetails)) continue;
            relocationOptions.add(refTreeRelocation);
        }
        return new Relocation(relocationOptions, remoteDetails.getHostName(), this.accurevWorkingSpace.getRemote(), null);
    }

    protected RemoteWorkspaceDetails getRemoteWorkspaceDetails() throws InterruptedException {
        try {
            return (RemoteWorkspaceDetails)this.jenkinsWorkspace.act((Callable)new DetermineRemoteHostname(this.accurevWorkingSpace.getRemote()));
        }
        catch (IOException e) {
            e.printStackTrace(this.listener.getLogger());
            throw new IllegalArgumentException("Unable to validate reference tree host.");
        }
    }

    private Map<String, AccurevReferenceTree> getReftrees() throws IOException {
        this.listener.getLogger().println("Getting a list of reference trees...");
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("show");
        Command.addServer(cmd, this.server);
        cmd.add("-fx");
        cmd.add("refs");
        XmlPullParserFactory parser = XmlParserFactory.getFactory();
        if (parser == null) {
            throw new IOException("No XML Parser");
        }
        return AccurevLauncher.runCommand("Show ref trees command", this.scm.getAccurevTool(), this.launcher, cmd, this.scm.getOptionalLock(), this.accurevEnv, this.jenkinsWorkspace, this.listener, logger, parser, new ParseShowReftrees(), null);
    }

    @Override
    protected boolean checkout(Run<?, ?> build, File changeLogFile) throws IOException, InterruptedException {
        if (!this.validateCheckout(build)) {
            return false;
        }
        Relocation relocation = this.checkForRelocation();
        if (relocation.isRelocationRequired()) {
            if (!this.relocate(relocation)) {
                return false;
            }
            if (!this.populate(build, this.popRequired)) {
                return false;
            }
        }
        return this.doUpdate(changeLogFile);
    }

    private boolean doUpdate(File changeLogFile) throws IOException {
        this.updateLogFile = XmlConsolidateStreamChangeLog.getUpdateChangeLogFile(changeLogFile);
        return Update.performUpdate(this.scm, this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, this.getRefTree(), this.updateLogFile);
    }

    @Override
    protected String getUpdateFileName() {
        return this.updateLogFile.getName();
    }

    @Override
    protected String getPopulateFromMessage() {
        return "from reftree";
    }

    @Override
    protected String getPopulateStream() {
        return null;
    }

    private boolean relocate(Relocation relocation) throws IOException, InterruptedException {
        ArgumentListBuilder relocateCommand = this.getRelocateCommand();
        this.popRequired = relocation.isPopRequired();
        if (this.popRequired) {
            this.listener.getLogger().println("Clearing path: " + this.accurevWorkingSpace.getRemote());
            this.accurevWorkingSpace.deleteContents();
        }
        relocation.appendCommands(relocateCommand);
        return AccurevLauncher.runCommand("relocation command", this.scm.getAccurevTool(), this.launcher, relocateCommand, this.scm.getOptionalLock(), this.accurevEnv, this.accurevWorkingSpace, this.listener, logger, true);
    }

    protected ArgumentListBuilder getRelocateCommand() {
        ArgumentListBuilder chrefcmd = new ArgumentListBuilder();
        chrefcmd.add("chref");
        Command.addServer(chrefcmd, this.server);
        chrefcmd.add("-r");
        chrefcmd.add(this.getRefTree());
        return chrefcmd;
    }

    protected boolean validateCheckout(Run<?, ?> build) {
        String reftree = this.getRefTree();
        if (StringUtils.isEmpty((String)reftree)) {
            this.listener.fatalError("Must specify a reference tree");
            return false;
        }
        return true;
    }

    @Override
    protected void buildEnvVarsCustom(Run<?, ?> build, Map<String, String> env) {
        env.put("ACCUREV_REFTREE", this.scm.getReftree());
    }

    private static enum RefTreeRelocation implements Relocation.RelocationOption
    {
        HOST{

            @Override
            protected boolean isRequired(AccurevReferenceTree accurevReftree, RemoteWorkspaceDetails remoteDetails) {
                return !accurevReftree.getHost().equals(remoteDetails.getHostName());
            }

            @Override
            public void appendCommand(ArgumentListBuilder cmd, Relocation relocation) {
                cmd.add("-m");
                cmd.add(relocation.getNewHost());
            }
        }
        ,
        STORAGE{

            @Override
            protected boolean isRequired(AccurevReferenceTree accurevReftree, RemoteWorkspaceDetails remoteDetails) {
                String oldStorage = accurevReftree.getStorage().replace("/", remoteDetails.getFileSeparator()).replace("\\", remoteDetails.getFileSeparator());
                return !new File(oldStorage).equals(new File(remoteDetails.getPath()));
            }

            @Override
            public void appendCommand(ArgumentListBuilder cmd, Relocation relocation) {
                cmd.add("-l");
                cmd.add(relocation.getNewPath());
            }
        };


        @Override
        public boolean isPopRequired() {
            return true;
        }

        protected abstract boolean isRequired(AccurevReferenceTree var1, RemoteWorkspaceDetails var2);
    }
}

