/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.delegates;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccuRevHiddenParametersAction;
import hudson.plugins.accurev.AccurevElement;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.AccurevStream;
import hudson.plugins.accurev.AccurevTransaction;
import hudson.plugins.accurev.GetConfigWebURL;
import hudson.plugins.accurev.XmlConsolidateStreamChangeLog;
import hudson.plugins.accurev.cmd.ChangeLogCmd;
import hudson.plugins.accurev.cmd.FilesCmd;
import hudson.plugins.accurev.cmd.GetAccuRevVersion;
import hudson.plugins.accurev.cmd.History;
import hudson.plugins.accurev.cmd.Login;
import hudson.plugins.accurev.cmd.PopulateCmd;
import hudson.plugins.accurev.cmd.SetProperty;
import hudson.plugins.accurev.cmd.ShowStreams;
import hudson.plugins.accurev.cmd.Synctime;
import hudson.scm.PollingResult;
import hudson.scm.SCMRevisionState;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public abstract class AbstractModeDelegate {
    protected static final String ACCUREV_WORKSPACE = "ACCUREV_WORKSPACE";
    protected static final String ACCUREV_REFTREE = "ACCUREV_REFTREE";
    private static final Logger logger = Logger.getLogger(AbstractModeDelegate.class.getName());
    private static final String ACCUREV_DEPOT = "ACCUREV_DEPOT";
    private static final String ACCUREV_STREAM = "ACCUREV_STREAM";
    private static final String ACCUREV_SERVER = "JENKINS_ACCUREV_SERVER";
    private static final String ACCUREV_SERVER_HOSTNAME = "ACCUREV_SERVER_HOSTNAME";
    private static final String ACCUREV_SERVER_PORT = "ACCUREV_SERVER_PORT";
    private static final String ACCUREV_SUBPATH = "ACCUREV_SUBPATH";
    private static final String ACCUREV_LATEST_TRANSACTION_ID = "ACCUREV_LATEST_TRANSACTION_ID";
    private static final String ACCUREV_LATEST_TRANSACTION_DATE = "ACCUREV_LATEST_TRANSACTION_DATE";
    private static final String ACCUREV_HOME = "ACCUREV_HOME";
    private static final String ACCUREVLASTTRANSFILENAME = "AccurevLastTrans.txt";
    public final AccurevSCM scm;
    protected Launcher launcher;
    protected AccurevSCM.AccurevServer server;
    protected EnvVars accurevEnv;
    protected FilePath jenkinsWorkspace;
    protected TaskListener listener;
    protected FilePath accurevWorkingSpace;
    protected String localStream;
    protected Date startDateOfPopulate;

    public AbstractModeDelegate(AccurevSCM scm) {
        this.scm = scm;
    }

    public static void setLastTransaction(Job<?, ?> job, String previous) throws IOException {
        if (job == null) {
            throw new IOException("Job is null");
        }
        File f = new File(job.getRootDir(), ACCUREVLASTTRANSFILENAME);
        try (BufferedWriter br = Files.newBufferedWriter(f.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            br.write(previous);
        }
    }

    public void setup(Launcher launcher, FilePath jenkinsWorkspace, TaskListener listener) throws IOException, IllegalArgumentException, InterruptedException {
        this.launcher = launcher;
        this.jenkinsWorkspace = jenkinsWorkspace;
        this.listener = listener;
        this.server = this.scm.getServer();
        this.accurevEnv = new EnvVars();
        if (jenkinsWorkspace != null) {
            this.accurevWorkingSpace = new FilePath(jenkinsWorkspace, this.scm.getDirectoryOffset() == null ? "" : this.scm.getDirectoryOffset());
            if (!this.accurevWorkingSpace.exists()) {
                this.accurevWorkingSpace.mkdirs();
            }
            if (!Login.ensureLoggedInToAccurev(this.scm, this.server, this.accurevEnv, jenkinsWorkspace, listener, launcher)) {
                throw new IllegalArgumentException("Authentication failure");
            }
            if (this.scm.isSynctime()) {
                listener.getLogger().println("Synchronizing clock with the server...");
                if (!Synctime.synctime(this.scm, this.server, this.accurevEnv, jenkinsWorkspace, listener, launcher)) {
                    throw new IllegalArgumentException("Synchronizing clock failure");
                }
            }
        }
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath jenkinsWorkspace, TaskListener listener, SCMRevisionState state) throws IOException, InterruptedException {
        if (project.isInQueue()) {
            listener.getLogger().println("Project build is currently in queue.");
            return PollingResult.NO_CHANGES;
        }
        if (jenkinsWorkspace == null) {
            listener.getLogger().println("No workspace required.");
            File projectDir = project.getRootDir();
            jenkinsWorkspace = new FilePath(projectDir);
            launcher = Jenkins.getInstance().createLauncher(listener);
        }
        listener.getLogger().println("Running commands from folder \"" + jenkinsWorkspace + '\"');
        this.setup(launcher, jenkinsWorkspace, listener);
        return this.checkForChanges(project);
    }

    protected abstract PollingResult checkForChanges(Job<?, ?> var1) throws IOException, InterruptedException;

    public boolean checkout(Run<?, ?> build, Launcher launcher, FilePath jenkinsWorkspace, TaskListener listener, File changelogFile) throws IOException, InterruptedException {
        this.setup(launcher, jenkinsWorkspace, listener);
        if (this.server.isServerDisabled()) {
            listener.fatalError("Checkout skipped due to server disabled!");
            throw new InterruptedException("Checkout skipped");
        }
        if (StringUtils.isEmpty((String)this.scm.getDepot())) {
            throw new IllegalStateException("Must specify a depot");
        }
        if (StringUtils.isEmpty((String)this.scm.getStream())) {
            throw new IllegalStateException("Must specify a stream");
        }
        EnvVars environment = build.getEnvironment(listener);
        this.accurevEnv.putAll((Map)environment);
        this.localStream = environment.expand(this.scm.getStream());
        listener.getLogger().println("Getting a list of streams...");
        Map<String, AccurevStream> streams = ShowStreams.getStreams(this.scm, this.localStream, this.server, this.accurevEnv, jenkinsWorkspace, listener, launcher);
        if (streams == null) {
            throw new IllegalStateException("Stream(s) not found");
        }
        if (!streams.containsKey(this.localStream)) {
            listener.fatalError("The specified stream, '" + this.localStream + "' does not appear to exist!");
            throw new IllegalStateException("Specified stream not found");
        }
        if (this.server.isUseColor()) {
            this.setStreamColor();
        }
        return this.checkout(build, changelogFile) && this.populate(build) && this.captureChangeLog(build, changelogFile, streams);
    }

    private boolean captureChangeLog(Run<?, ?> build, File changelogFile, Map<String, AccurevStream> streams) throws IOException {
        AccurevStream stream;
        Calendar startTime;
        try {
            AccurevTransaction latestTransaction = this.getLatestTransactionFromStreams(streams);
            if (latestTransaction == null) {
                throw new NullPointerException("The 'hist' command did not return a transaction. Does this stream have any history yet?");
            }
            String latestTransactionID = latestTransaction.getId();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String latestTransactionDate = formatter.format(latestTransaction.getDate());
            this.listener.getLogger().println("Latest Transaction ID: " + latestTransactionID);
            this.listener.getLogger().println("Latest transaction Date: " + latestTransactionDate);
            EnvVars envVars = new EnvVars();
            envVars.put(ACCUREV_LATEST_TRANSACTION_ID, latestTransactionID);
            envVars.put(ACCUREV_LATEST_TRANSACTION_DATE, latestTransactionDate);
            AbstractModeDelegate.setLastTransaction(build.getParent(), latestTransactionID);
            build.addAction((Action)new AccuRevHiddenParametersAction(envVars));
        }
        catch (Exception e) {
            this.listener.error("There was a problem getting the latest transaction info from the stream.");
            e.printStackTrace(this.listener.getLogger());
        }
        this.listener.getLogger().println("Calculating changelog" + (this.scm.isIgnoreStreamParent() ? ", ignoring changes in parent" : "") + "...");
        Run previousBuild = null;
        if (build != null) {
            previousBuild = build.getPreviousBuild();
        }
        if (previousBuild != null) {
            startTime = previousBuild.getTimestamp();
        } else {
            Calendar c = Calendar.getInstance();
            c.add(6, -7);
            startTime = c;
        }
        Map<String, GetConfigWebURL> webURL = ChangeLogCmd.retrieveWebURL(this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, logger, this.scm);
        AccurevStream accurevStream = stream = streams == null ? null : streams.get(this.localStream);
        if (stream == null) {
            return ChangeLogCmd.captureChangelog(this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, this.startDateOfPopulate, startTime.getTime(), this.localStream, changelogFile, logger, this.scm, webURL);
        }
        if (!this.getChangesFromStreams(startTime, stream, changelogFile, webURL)) {
            return ChangeLogCmd.captureChangelog(this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, this.startDateOfPopulate, startTime.getTime(), this.localStream, changelogFile, logger, this.scm, webURL);
        }
        return true;
    }

    protected String getChangeLogStream() {
        return this.localStream;
    }

    private boolean getChangesFromStreams(Calendar startTime, AccurevStream stream, File changelogFile, Map<String, GetConfigWebURL> webURL) throws IOException {
        boolean capturedChangelog;
        ArrayList<String> changedStreams = new ArrayList<String>();
        do {
            File streamChangeLog = XmlConsolidateStreamChangeLog.getStreamChangeLogFile(changelogFile, stream);
            capturedChangelog = ChangeLogCmd.captureChangelog(this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, this.startDateOfPopulate, startTime == null ? null : startTime.getTime(), stream.getName(), streamChangeLog, logger, this.scm, webURL);
            if (!capturedChangelog) continue;
            changedStreams.add(streamChangeLog.getName());
        } while ((stream = stream.getParent()) != null && stream.isReceivingChangesFromParent() && capturedChangelog && startTime != null && !this.scm.isIgnoreStreamParent());
        XmlConsolidateStreamChangeLog.createChangeLog(changedStreams, changelogFile, this.getUpdateFileName());
        return capturedChangelog;
    }

    private AccurevTransaction getLatestTransactionFromStreams(Map<String, AccurevStream> streams) throws Exception {
        AccurevTransaction transaction = null;
        AccurevStream stream = streams.get(this.getChangeLogStream());
        do {
            AccurevTransaction other = History.getLatestTransaction(this.scm, this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, stream.getName(), null);
            if (null == transaction && null != other) {
                transaction = other;
                continue;
            }
            if (null == transaction || null == other || Integer.parseInt(other.getId()) <= Integer.parseInt(transaction.getId())) continue;
            transaction = other;
        } while ((stream = stream.getParent()) != null && stream.isReceivingChangesFromParent() && !this.scm.isIgnoreStreamParent());
        return transaction;
    }

    public EnvVars getAccurevEnv() {
        return this.accurevEnv;
    }

    protected String getUpdateFileName() {
        return null;
    }

    protected abstract boolean checkout(Run<?, ?> var1, File var2) throws IOException, InterruptedException;

    protected abstract String getPopulateFromMessage();

    protected abstract String getPopulateStream();

    protected boolean isPopulateRequired() {
        return !this.scm.isDontPopContent();
    }

    protected boolean isSteamColorEnabled() {
        return false;
    }

    protected String getStreamColor() {
        return "";
    }

    protected String getStreamColorStream() {
        return null;
    }

    private void setStreamColor() throws IOException {
        if (this.isSteamColorEnabled()) {
            SetProperty.setproperty(this.scm, this.accurevWorkingSpace, this.listener, this.launcher, this.accurevEnv, this.server, this.getStreamColorStream(), this.getStreamColor(), this.getStreamTypeParameter());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean populate(Run<?, ?> build, boolean populateRequired) throws IOException, InterruptedException {
        if (populateRequired) {
            String stream = this.getPopulateStream();
            int lastTransaction = NumberUtils.toInt((String)this.getLastBuildTransaction(build), (int)0);
            PopulateCmd pop = new PopulateCmd();
            if (lastTransaction == 0 || this.accurevWorkingSpace.list("*", ".accurev").length == 0) {
                if (!pop.populate(this.scm, this.launcher, this.listener, this.server, stream, true, this.getPopulateFromMessage(), this.accurevWorkingSpace, this.accurevEnv, null)) return false;
                this.startDateOfPopulate = pop.get_startDateOfPopulate();
                return true;
            } else {
                FilePath populateFile = this.getFileRevisionsTobePopulated(lastTransaction, this.getChangeLogStream());
                if (populateFile != null) {
                    logger.info("populate file path " + populateFile.getRemote());
                    if (pop.populate(this.scm, this.launcher, this.listener, this.server, stream, true, this.getPopulateFromMessage(), this.accurevWorkingSpace, this.accurevEnv, populateFile)) {
                        this.startDateOfPopulate = pop.get_startDateOfPopulate();
                        this.deleteTempFile(populateFile);
                    } else {
                        this.deleteTempFile(populateFile);
                        return false;
                    }
                }
                this.startDateOfPopulate = new Date();
            }
            return true;
        } else {
            this.startDateOfPopulate = new Date();
        }
        return true;
    }

    protected boolean populate(Run<?, ?> build) throws IOException, InterruptedException {
        return this.populate(build, this.isPopulateRequired());
    }

    public void buildEnvVars(Run<?, ?> build, Map<String, String> env) {
        try {
            this.setup(null, null, TaskListener.NULL);
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, "buildEnvVars", ex);
        }
        if (this.scm.getDepot() != null) {
            env.put(ACCUREV_DEPOT, this.scm.getDepot());
        } else {
            env.put(ACCUREV_DEPOT, "");
        }
        if (this.scm.getStream() != null) {
            env.put(ACCUREV_STREAM, this.scm.getStream());
        } else {
            env.put(ACCUREV_STREAM, "");
        }
        if (this.server != null && this.server.getName() != null) {
            env.put(ACCUREV_SERVER, this.server.getName());
        } else {
            env.put(ACCUREV_SERVER, "");
        }
        if (this.server != null && this.server.getHost() != null) {
            env.put(ACCUREV_SERVER_HOSTNAME, this.server.getHost());
        } else {
            env.put(ACCUREV_SERVER_HOSTNAME, "");
        }
        if (this.server != null && this.server.getPort() > 0) {
            env.put(ACCUREV_SERVER_PORT, Integer.toString(this.server.getPort()));
        } else {
            env.put(ACCUREV_SERVER_PORT, "");
        }
        env.put(ACCUREV_WORKSPACE, "");
        env.put(ACCUREV_REFTREE, "");
        if (this.scm.getSubPath() != null) {
            env.put(ACCUREV_SUBPATH, this.scm.getSubPath());
        } else {
            env.put(ACCUREV_SUBPATH, "");
        }
        if (System.getenv(ACCUREV_HOME) != null) {
            env.put(ACCUREV_HOME, System.getenv(ACCUREV_HOME));
        }
        this.buildEnvVarsCustom(build, env);
    }

    protected void buildEnvVarsCustom(Run<?, ?> build, Map<String, String> env) {
    }

    private String getStreamTypeParameter() {
        String fullVersion = GetAccuRevVersion.getAccuRevVersion().trim();
        String partialversion = fullVersion.substring(fullVersion.indexOf(" ") + 1);
        String version = partialversion.substring(0, partialversion.indexOf(" "));
        String[] versionSplits = version.split("\\.");
        String type = Integer.parseInt(versionSplits[0]) < 6 || Integer.parseInt(versionSplits[0]) == 6 && Integer.parseInt(versionSplits[1]) < 1 ? "style" : "streamStyle";
        logger.info("Current AccuRev version " + fullVersion + " color type parameter " + type);
        return type;
    }

    private String getLastBuildTransaction(Run<?, ?> build) throws IOException {
        File f = new File(build.getParent().getRootDir(), ACCUREVLASTTRANSFILENAME);
        if (!f.exists()) {
            return null;
        }
        try (BufferedReader br = Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8);){
            String string = br.readLine();
            return string;
        }
    }

    private FilePath getFileRevisionsTobePopulated(int lastTransaction, String stream) throws IOException, InterruptedException {
        List<AccurevTransaction> transactions = History.getTransactionsAfterLastTransaction(this.scm, this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, stream, lastTransaction);
        if (transactions.isEmpty()) {
            return null;
        }
        HashSet<String> fileRevisions = new HashSet<String>();
        transactions.stream().filter(t -> t != null && !t.getAction().equals("defunct") && !t.getAffectedPaths().isEmpty()).map(AccurevTransaction::getAffectedPaths).forEach(fileRevisions::addAll);
        if (fileRevisions.isEmpty()) {
            return null;
        }
        return this.checkFilesOnStream(this.getPopulateFilePath(fileRevisions));
    }

    private FilePath getPopulateFilePath(Set<String> fileRevisions) throws IOException, InterruptedException {
        FilePath populateFiles = this.accurevWorkingSpace.createTextTempFile("PopulateFiles", ".txt", String.join((CharSequence)"\n", fileRevisions));
        populateFiles.chmod(384);
        return populateFiles;
    }

    private FilePath checkFilesOnStream(FilePath filePath) throws IOException, InterruptedException {
        HashSet fileRevisions = new HashSet();
        List<AccurevElement> accurevElements = FilesCmd.checkFiles(this.scm, this.server, this.accurevEnv, this.accurevWorkingSpace, this.listener, this.launcher, filePath);
        accurevElements.stream().filter(e -> e != null && !e.getStatus().matches(".*(defunct|no such elem).*")).map(AccurevElement::getLocation).forEach(fileRevisions::add);
        for (String str : fileRevisions) {
            this.listener.getLogger().print(str);
        }
        filePath.write(String.join((CharSequence)"\n", fileRevisions), "UTF-8");
        return filePath;
    }

    private void deleteTempFile(FilePath tempFile) throws InterruptedException, IOException {
        block3: {
            if (tempFile != null) {
                try {
                    tempFile.delete();
                }
                catch (IOException ex) {
                    if (!tempFile.exists()) break block3;
                    this.listener.getLogger().println("[WARNING] temp file " + tempFile + " not deleted");
                }
            }
        }
    }
}

