/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.cmd;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.parsers.output.ParseOutputToFile;
import hudson.plugins.accurev.parsers.xml.ParseUpdate;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserFactory;

public class Update
extends Command {
    private static final Logger logger = Logger.getLogger(Update.class.getName());
    private static final String FFPSCM_DELIM = ",";

    private static ArgumentListBuilder createCommand(AccurevSCM.AccurevServer server, boolean preview, String reftree, boolean minus9) {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("update");
        Update.addServer(cmd, server);
        cmd.add("-fx");
        if (reftree != null) {
            cmd.add("-r");
            cmd.add(reftree);
        }
        if (minus9) {
            cmd.add("-9");
        }
        if (preview) {
            cmd.add("-i");
        }
        return cmd;
    }

    public static Boolean hasChanges(AccurevSCM scm, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, String reftree) throws IOException {
        ArrayList files = new ArrayList();
        ArgumentListBuilder cmd = Update.createCommand(server, true, reftree, false);
        XmlPullParserFactory parser = XmlParserFactory.getFactory();
        if (parser == null) {
            throw new IOException("No XML Parser");
        }
        Boolean transactionFound = AccurevLauncher.runCommand("Update command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, parser, new ParseUpdate(), files);
        if (transactionFound != null && transactionFound.booleanValue()) {
            String filterForPollSCM = scm.getFilterForPollSCM();
            String subPath = scm.getSubPath();
            ArrayList<String> filterPaths = null;
            String filterList = null;
            if (filterForPollSCM != null && !filterForPollSCM.isEmpty()) {
                filterList = filterForPollSCM;
            } else if (subPath != null && !subPath.isEmpty()) {
                filterList = subPath;
            }
            if (filterList != null && !filterList.isEmpty()) {
                filterList = filterList.replace(", ", FFPSCM_DELIM);
                filterPaths = new ArrayList<String>(Arrays.asList(filterList.split(FFPSCM_DELIM)));
            }
            if (filterPaths != null) {
                transactionFound = false;
                for (String Filter_For_Poll_SCM1 : filterPaths) {
                    for (String file : files) {
                        if (!file.contains(Filter_For_Poll_SCM1)) continue;
                        transactionFound = true;
                        break;
                    }
                    if (!transactionFound.booleanValue()) continue;
                    break;
                }
            }
        } else {
            return false;
        }
        return transactionFound;
    }

    public static boolean performUpdate(AccurevSCM scm, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, String reftree, File changelogFile) throws IOException {
        ArgumentListBuilder cmd = Update.createCommand(server, false, reftree, false);
        Boolean result = AccurevLauncher.runCommand("Update command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, new ParseOutputToFile(), changelogFile);
        if (result == null) {
            return false;
        }
        return result;
    }
}

