/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.cmd;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.AccurevStream;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.parsers.xml.ParseShowStreams;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.xmlpull.v1.XmlPullParserFactory;

public class ShowStreams
extends Command {
    private static final Logger LOGGER = Logger.getLogger(ShowStreams.class.getName());

    @CheckForNull
    public static Map<String, AccurevStream> getStreams(AccurevSCM scm, String nameOfStreamRequired, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher) throws IOException {
        Map<String, AccurevStream> streams = scm.isIgnoreStreamParent() ? ShowStreams.getOneStream(nameOfStreamRequired, accurevEnv, workspace, listener, launcher, scm) : (server.isUseRestrictedShowStreams() ? ShowStreams.getAllAncestorStreams(nameOfStreamRequired, scm, accurevEnv, workspace, listener, launcher) : ShowStreams.getAllStreams(scm, server, scm.getDepot(), scm.getOptionalLock(), accurevEnv, workspace, listener, launcher));
        return streams;
    }

    public static Map<String, AccurevStream> getAllStreams(AccurevSCM scm, AccurevSCM.AccurevServer server, String depot, Lock lock, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher) throws IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("show");
        ShowStreams.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(depot);
        cmd.add("streams");
        XmlPullParserFactory parser = XmlParserFactory.getFactory();
        if (parser == null) {
            throw new IOException("No XML Parser");
        }
        Map<String, AccurevStream> streams = AccurevLauncher.runCommand("Show streams command", scm.getAccurevTool(), launcher, cmd, lock, accurevEnv, workspace, listener, LOGGER, parser, new ParseShowStreams(), depot);
        ShowStreams.setParents(streams);
        return streams;
    }

    private static Map<String, AccurevStream> getAllAncestorStreams(String nameOfStreamRequired, AccurevSCM scm, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher) throws IOException {
        HashMap<String, AccurevStream> streams = new HashMap<String, AccurevStream>();
        String streamName = nameOfStreamRequired;
        while (streamName != null && !streamName.isEmpty()) {
            Map<String, AccurevStream> oneStream = ShowStreams.getOneStream(streamName, accurevEnv, workspace, listener, launcher, scm);
            AccurevStream theStream = oneStream == null ? null : oneStream.get(streamName);
            streamName = null;
            if (theStream == null) continue;
            if (theStream.getBasisName() != null) {
                streamName = theStream.getBasisName();
            } else if (theStream.getBasisNumber() != null) {
                streamName = theStream.getBasisNumber().toString();
            }
            streams.putAll(oneStream);
        }
        ShowStreams.setParents(streams);
        return streams;
    }

    private static Map<String, AccurevStream> getOneStream(String streamName, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, AccurevSCM scm) throws IOException {
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("show");
        ShowStreams.addServer(cmd, scm.getServer());
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(scm.getDepot());
        cmd.add("-s");
        cmd.add(streamName);
        cmd.add("streams");
        XmlPullParserFactory parser = XmlParserFactory.getFactory();
        if (parser == null) {
            throw new IOException("No XML Parser");
        }
        return AccurevLauncher.runCommand("Restricted show streams command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, LOGGER, parser, new ParseShowStreams(), scm.getDepot());
    }

    private static void setParents(Map<String, AccurevStream> streams) {
        if (streams != null && streams.size() > 1) {
            streams.values().stream().filter(stream -> stream.getBasisName() != null).forEach(stream -> stream.setParent((AccurevStream)streams.get(stream.getBasisName())));
        }
    }
}

