/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.cmd;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.parsers.output.ParsePopulate;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class PopulateCmd
extends Command {
    private static final Logger logger = Logger.getLogger(PopulateCmd.class.getName());
    private Date _startDateOfPopulate;

    public Date get_startDateOfPopulate() {
        return (Date)this._startDateOfPopulate.clone();
    }

    public boolean populate(AccurevSCM scm, Launcher launcher, TaskListener listener, AccurevSCM.AccurevServer server, String streamName, boolean overwrite, String fromMessage, FilePath workspace, EnvVars accurevEnv, FilePath files) throws IOException {
        listener.getLogger().println("Populating " + fromMessage + "...");
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("pop");
        PopulateCmd.addServer(cmd, server);
        if (streamName != null) {
            cmd.add("-v");
            cmd.add(streamName);
        }
        cmd.add("-L");
        cmd.add(workspace.getRemote());
        if (files != null) {
            cmd.add("-l");
            cmd.add(files.getRemote());
        }
        if (overwrite) {
            cmd.add("-O");
        }
        cmd.add("-R");
        if (StringUtils.isBlank((String)scm.getSubPath())) {
            cmd.add(".");
        } else {
            StringTokenizer st = new StringTokenizer(scm.getSubPath(), ",");
            while (st.hasMoreElements()) {
                cmd.add(st.nextToken().trim());
            }
        }
        this._startDateOfPopulate = new Date();
        Boolean success = AccurevLauncher.runCommand("Populate " + fromMessage + " command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, new ParsePopulate(), listener.getLogger());
        if (success == null || !success.booleanValue()) {
            return false;
        }
        listener.getLogger().println("Populate completed successfully.");
        return true;
    }
}

