/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.cmd;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.parsers.output.ParseInfoToLoginName;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class Login
extends Command {
    private static final Logger logger = Logger.getLogger(Login.class.getName());

    private static String getLoggedInUsername(String accurevTool, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher) throws IOException {
        String commandDescription = "info command";
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("info");
        Login.addServer(cmd, server);
        return AccurevLauncher.runCommand("info command", accurevTool, launcher, cmd, null, accurevEnv, workspace, listener, logger, new ParseInfoToLoginName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureLoggedInToAccurev(AccurevSCM scm, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath pathToRunCommandsIn, TaskListener listener, Launcher launcher) throws IOException {
        String accurevTool;
        String string = accurevTool = scm == null ? null : scm.getAccurevTool();
        if (server == null) {
            listener.getLogger().println("Authentication failure - Server is empty");
            return false;
        }
        String requiredUsername = server.getUsername();
        if (StringUtils.isBlank((String)requiredUsername)) {
            listener.getLogger().println("Authentication failure - Username blank");
            return false;
        }
        AccurevSCM.AccurevSCMDescriptor.lock();
        try {
            boolean loginRequired;
            if (server.isMinimiseLogins()) {
                String currentUsername = Login.getLoggedInUsername(accurevTool, server, accurevEnv, pathToRunCommandsIn, listener, launcher);
                if (StringUtils.isEmpty((String)currentUsername)) {
                    loginRequired = true;
                    listener.getLogger().println("Not currently authenticated with Accurev server");
                } else {
                    loginRequired = !currentUsername.equals(requiredUsername);
                    listener.getLogger().println("Currently authenticated with Accurev server as '" + currentUsername + (loginRequired ? "', login required" : "', not logging in again."));
                }
            } else {
                loginRequired = true;
            }
            if (loginRequired) {
                boolean bl = Login.accurevLogin(accurevTool, server, accurevEnv, pathToRunCommandsIn, listener, launcher);
                return bl;
            }
        }
        finally {
            AccurevSCM.AccurevSCMDescriptor.unlock();
        }
        return true;
    }

    private static boolean accurevLogin(String accurevTool, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher) throws IOException {
        StandardUsernamePasswordCredentials credentials = server.getCredentials();
        if (credentials == null) {
            listener.getLogger().println("Credentials not found");
            return false;
        }
        if (StringUtils.isBlank((String)credentials.getUsername())) {
            listener.getLogger().println("Credentials username cannot be blank");
            return false;
        }
        listener.getLogger().println("Authenticating with Accurev server...");
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("login");
        Login.addServer(cmd, server);
        if (server.isUseNonexpiringLogin()) {
            cmd.add("-n");
        }
        cmd.add(credentials.getUsername());
        if (StringUtils.isEmpty((String)Secret.toString((Secret)credentials.getPassword()))) {
            if (launcher.isUnix()) {
                cmd.add("", true);
            } else {
                cmd.addQuoted("", true);
            }
        } else {
            cmd.add(server.getPassword(), true);
        }
        boolean success = AccurevLauncher.runCommand("login", accurevTool, launcher, cmd, null, accurevEnv, workspace, listener, logger, new boolean[0]);
        if (success) {
            listener.getLogger().println("Authentication completed successfully.");
            return true;
        }
        return false;
    }

    public static boolean accurevLoginFromGlobalConfig(AccurevSCM.AccurevServer server) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        TaskListener listener = TaskListener.NULL;
        Launcher launcher = jenkins.createLauncher(listener);
        EnvVars accurevEnv = new EnvVars();
        return Login.ensureLoggedInToAccurev(null, server, accurevEnv, jenkins.getRootPath(), listener, launcher);
    }
}

