/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.cmd;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.AccurevTransaction;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.parsers.xml.ParseHistory;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserFactory;

public class History
extends Command {
    private static final Logger logger = Logger.getLogger(History.class.getName());

    public static AccurevTransaction getLatestTransaction(AccurevSCM scm, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, String stream, String transactionType) throws IOException {
        XmlPullParserFactory parser;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("hist");
        History.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(scm.getDepot());
        cmd.add("-s");
        cmd.add(stream);
        cmd.add("-t");
        cmd.add("now.1");
        if (transactionType != null) {
            cmd.add("-k");
            cmd.add(transactionType);
        }
        if ((parser = XmlParserFactory.getFactory()) == null) {
            throw new IOException("No XML Parser");
        }
        ArrayList transaction = new ArrayList(1);
        Boolean transactionFound = AccurevLauncher.runCommand("History command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, parser, new ParseHistory(), transaction);
        if (transactionFound == null) {
            String msg = "History command failed when trying to get the latest transaction of type " + transactionType;
            throw new IOException(msg);
        }
        if (transactionFound.booleanValue()) {
            return (AccurevTransaction)((Object)transaction.get(0));
        }
        return null;
    }

    public static List<AccurevTransaction> getTransactionsAfterLastTransaction(AccurevSCM scm, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, String stream, int lastTransaction) throws IOException {
        XmlPullParserFactory parser;
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("hist");
        History.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-p");
        cmd.add(scm.getDepot());
        cmd.add("-s");
        cmd.add(stream);
        if (lastTransaction > 0) {
            cmd.add("-t");
            cmd.add("now-" + (lastTransaction + 1));
        }
        if ((parser = XmlParserFactory.getFactory()) == null) {
            throw new IOException("No XML Parser");
        }
        ArrayList<AccurevTransaction> transactions = new ArrayList<AccurevTransaction>();
        Boolean transactionFound = AccurevLauncher.runHistCommandForAll("History command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, parser, new ParseHistory(), transactions);
        if (transactionFound == null) {
            throw new IOException("History command failed when trying to get all the transactionse ");
        }
        return transactions;
    }
}

