/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.cmd;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevElement;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.cmd.Login;
import hudson.plugins.accurev.parsers.xml.ParseFiles;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserFactory;

public class FilesCmd
extends Command {
    private static final Logger logger = Logger.getLogger(Login.class.getName());

    public static List<AccurevElement> checkFiles(AccurevSCM scm, AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, FilePath file) throws IOException {
        String commandDescription = "files command";
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("files");
        FilesCmd.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add(new String[]{"-s", scm.getStream()});
        cmd.add(new String[]{"-l", file.getRemote()});
        ArrayList<AccurevElement> list = new ArrayList<AccurevElement>(1);
        XmlPullParserFactory parser = XmlParserFactory.getFactory();
        if (parser == null) {
            throw new IOException("No XML Parser");
        }
        Boolean filesFound = AccurevLauncher.runCommand("files command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, parser, new ParseFiles(), list);
        if (filesFound == null) {
            throw new IOException("FilesCmd command failed.");
        }
        return list;
    }
}

