/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev.cmd;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.GetConfigWebURL;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.cmd.Command;
import hudson.plugins.accurev.parsers.output.ParseOutputToFile;
import hudson.plugins.accurev.parsers.xml.ParseGetConfig;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ChangeLogCmd {
    public static boolean captureChangelog(AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, Date buildDate, Date startDate, String stream, File changelogFile, Logger logger, AccurevSCM scm, Map<String, GetConfigWebURL> webURL) throws IOException {
        String accurevACSYNCEnvVar = "AC_SYNC";
        if (!accurevEnv.containsKey((Object)"AC_SYNC")) {
            String accurevACSYNC = "IGNORE";
            accurevEnv.put("AC_SYNC", "IGNORE");
            listener.getLogger().println("Setting AC_SYNC to \"IGNORE\"");
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add("hist");
        Command.addServer(cmd, server);
        cmd.add("-fx");
        cmd.add("-a");
        cmd.add("-s");
        cmd.add(stream);
        cmd.add("-t");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String dateRange = formatter.format(buildDate);
        dateRange = startDate != null ? dateRange + "-" + formatter.format(startDate) : dateRange + ".100";
        cmd.add(dateRange);
        String commandDescription = "Changelog command";
        Boolean success = AccurevLauncher.runCommand("Changelog command", scm.getAccurevTool(), launcher, cmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, new ParseOutputToFile(), changelogFile);
        if (success == null || !success.booleanValue()) {
            return false;
        }
        if (changelogFile != null) {
            ChangeLogCmd.applyWebURL(webURL, changelogFile, scm);
        }
        listener.getLogger().println("Changelog calculated successfully.");
        return true;
    }

    public static Map<String, GetConfigWebURL> retrieveWebURL(AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, Logger logger, AccurevSCM scm) throws IOException {
        ArgumentListBuilder getConfigCmd = new ArgumentListBuilder();
        getConfigCmd.add("getconfig");
        Command.addServer(getConfigCmd, server);
        getConfigCmd.add("-s");
        getConfigCmd.add("-r");
        getConfigCmd.add("settings.xml");
        XmlPullParserFactory parser = XmlParserFactory.getFactory();
        if (parser == null) {
            throw new IOException("No XML Parser");
        }
        return AccurevLauncher.runCommand("Get config to fetch webURL", scm.getAccurevTool(), launcher, getConfigCmd, scm.getOptionalLock(), accurevEnv, workspace, listener, logger, parser, new ParseGetConfig(), null);
    }

    private static void applyWebURL(Map<String, GetConfigWebURL> webURL, File changelogFile, AccurevSCM scm) {
        if (webURL == null || webURL.isEmpty()) {
            return;
        }
        GetConfigWebURL webuiURL = webURL.get("webuiURL");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(changelogFile);
            NodeList nodes = document.getElementsByTagName("transaction");
            Element depotElement = document.createElement("depot");
            if (nodes != null && nodes.getLength() > 0) {
                nodes.item(0).getParentNode().insertBefore(depotElement, nodes.item(0));
            }
            depotElement.appendChild(document.createTextNode(scm.getDepot()));
            Element webuiElement = document.createElement("webuiURL");
            if (nodes != null && nodes.getLength() > 0) {
                nodes.item(0).getParentNode().insertBefore(webuiElement, nodes.item(0));
            }
            if (webuiURL != null) {
                webuiElement.appendChild(document.createTextNode(webuiURL.getWebURL().endsWith("/") ? webuiURL.getWebURL().substring(0, webuiURL.getWebURL().length() - 1) : webuiURL.getWebURL()));
            } else {
                webuiElement.appendChild(document.createTextNode(""));
            }
            DOMSource source = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult result = new StreamResult(changelogFile);
            transformer.transform(source, result);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            // empty catch block
        }
    }
}

