/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlParserFactory {
    private static final Logger logger = Logger.getLogger(AccurevSCM.class.getName());
    private static final Map<Object, XmlPullParserFactory> PARSER_FACTORY_CACHE = new WeakHashMap<Object, XmlPullParserFactory>(1);

    static XmlPullParser newParser() throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = null;
        XmlPullParser parser = null;
        if (null != XmlParserFactory.getFactory()) {
            factory = XmlParserFactory.getFactory();
        }
        if (null != factory) {
            parser = factory.newPullParser();
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlPullParserFactory getFactory() throws IOException {
        Map<Object, XmlPullParserFactory> map = PARSER_FACTORY_CACHE;
        synchronized (map) {
            XmlPullParserFactory newFactory;
            XmlPullParserFactory existingFactory = PARSER_FACTORY_CACHE.get(XmlPullParserFactory.class);
            if (existingFactory != null) {
                return existingFactory;
            }
            try {
                newFactory = XmlPullParserFactory.newInstance();
            }
            catch (XmlPullParserException ex) {
                AccurevLauncher.logException("Unable to create new " + XmlPullParserFactory.class.getSimpleName(), ex, logger, null);
                return null;
            }
            newFactory.setNamespaceAware(false);
            newFactory.setValidating(false);
            PARSER_FACTORY_CACHE.put(XmlPullParserFactory.class, newFactory);
            return newFactory;
        }
    }
}

