/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.accurev.AccurevChangeLogSet;
import hudson.plugins.accurev.AccurevLauncher;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.AccurevTransaction;
import hudson.plugins.accurev.XmlParserFactory;
import hudson.plugins.accurev.parsers.xml.ParseUpdate;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import jenkins.plugins.accurev.util.AccurevUtils;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParseChangeLog
extends ChangeLogParser {
    private static final Logger logger = Logger.getLogger(AccurevSCM.class.getName());

    public ChangeLogSet<AccurevTransaction> parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
        UpdateLog updateLog = new UpdateLog();
        List<AccurevTransaction> transactions = this.parse(changelogFile, updateLog);
        transactions = this.filterTransactions(transactions, updateLog);
        return new AccurevChangeLogSet(build, transactions);
    }

    private List<AccurevTransaction> filterTransactions(List<AccurevTransaction> transactions, UpdateLog updateLog) {
        List<AccurevTransaction> filteredTransactions;
        if (updateLog.hasUpdate()) {
            filteredTransactions = new ArrayList<AccurevTransaction>();
            if (updateLog.hasChanges()) {
                List changesFiles = updateLog.changedFiles;
                ArrayList filteredFiles = new ArrayList(changesFiles);
                for (AccurevTransaction transaction : transactions) {
                    List<String> rawPaths = transaction.getAffectedRawPaths();
                    boolean includeTransaction = true;
                    for (String rawPath : rawPaths) {
                        if (changesFiles.contains(rawPath)) continue;
                        includeTransaction = false;
                        break;
                    }
                    if (!includeTransaction) continue;
                    filteredTransactions.add(transaction);
                    filteredFiles.removeAll(rawPaths);
                }
                if (!filteredFiles.isEmpty()) {
                    AccurevTransaction extraFiles = new AccurevTransaction();
                    extraFiles.setDate(new Date());
                    extraFiles.setAction("promote");
                    extraFiles.setId("upstream");
                    extraFiles.setMsg("Upstream changes");
                    extraFiles.setUser("upstream");
                    filteredFiles.forEach(extraFiles::addAffectedPath);
                    filteredTransactions.add(extraFiles);
                }
            }
        } else {
            filteredTransactions = transactions;
        }
        filteredTransactions.removeIf(t -> t.getAction().equalsIgnoreCase("dispatch"));
        return filteredTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AccurevTransaction> parse(File changelogFile, UpdateLog updateLog) throws IOException {
        ArrayList<AccurevTransaction> transactions = new ArrayList<AccurevTransaction>();
        try {
            XmlPullParser parser = XmlParserFactory.newParser();
            try (BufferedReader br = Files.newBufferedReader(changelogFile.toPath());){
                parser.setInput((Reader)br);
                transactions.addAll(this.parseTransactions(parser, changelogFile, updateLog));
            }
            finally {
                parser.setInput(null);
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        return transactions;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    private List<AccurevTransaction> parseTransactions(XmlPullParser parser, File changeLogFile, UpdateLog updateLog) throws IOException, XmlPullParserException {
        ArrayList<AccurevTransaction> transactions = new ArrayList<AccurevTransaction>();
        AccurevTransaction currentTransaction = null;
        boolean inComment = false;
        boolean inIssueNum = false;
        boolean inVersion = false;
        String path = "";
        String realVersion = "";
        boolean inConsolidatedChangeLog = false;
        boolean inUpdateLog = false;
        boolean inDepot = false;
        boolean inWebuiURL = false;
        String depotName = "";
        String webuiURL = "";
        block7: while (true) {
            switch (parser.next()) {
                case 0: {
                    break;
                }
                case 1: {
                    return transactions;
                }
                case 2: {
                    String tagName = parser.getName();
                    if ("transaction".equalsIgnoreCase(tagName)) {
                        currentTransaction = new AccurevTransaction();
                        transactions.add(currentTransaction);
                        currentTransaction.setId(parser.getAttributeValue("", "id"));
                        currentTransaction.setUser(parser.getAttributeValue("", "user"));
                        currentTransaction.setDate(AccurevUtils.convertAccurevTimestamp(parser.getAttributeValue("", "time")));
                        currentTransaction.setAction(parser.getAttributeValue("", "type"));
                        if (webuiURL == null || webuiURL.isEmpty()) continue block7;
                        currentTransaction.setWebuiURLforTrans(webuiURL + "/WebGui.jsp?tran_number=" + parser.getAttributeValue("", "id") + "&depot=" + depotName + "&view=trans_hist");
                        break;
                    }
                    if ("version".equalsIgnoreCase(tagName) && currentTransaction != null) {
                        path = parser.getAttributeValue("", "path");
                        if (path != null) {
                            path = AccurevUtils.cleanAccurevPath(path);
                        }
                        inVersion = true;
                        realVersion = parser.getAttributeValue("", "real");
                        break;
                    }
                    if ("issueNum".equalsIgnoreCase(tagName) && currentTransaction != null) {
                        inIssueNum = true;
                        break;
                    }
                    if ("comment".equalsIgnoreCase(tagName) && currentTransaction != null) {
                        inComment = true;
                        break;
                    }
                    if ("ChangeLog".equalsIgnoreCase(tagName)) {
                        inConsolidatedChangeLog = true;
                        break;
                    }
                    if ("UpdateLog".equalsIgnoreCase(tagName)) {
                        inUpdateLog = true;
                        break;
                    }
                    if ("depot".equalsIgnoreCase(tagName)) {
                        inDepot = true;
                        break;
                    }
                    if (!"webuiURL".equalsIgnoreCase(tagName)) break;
                    inWebuiURL = true;
                    break;
                }
                case 3: {
                    String affectedPathInfo;
                    String endTagName = parser.getName();
                    if ("issueNum".equalsIgnoreCase(endTagName) && inVersion && inIssueNum && currentTransaction != null) {
                        affectedPathInfo = path + " --- Version - " + realVersion;
                        currentTransaction.addAffectedPath(affectedPathInfo);
                        currentTransaction.addAffectedRawPath(path);
                        inIssueNum = false;
                        inVersion = false;
                        break;
                    }
                    if ("version".equalsIgnoreCase(endTagName) && inVersion && currentTransaction != null) {
                        affectedPathInfo = path + " --- Version - " + realVersion;
                        currentTransaction.addAffectedPath(affectedPathInfo);
                        currentTransaction.addAffectedRawPath(path);
                        inVersion = false;
                        break;
                    }
                    if ("comment".equalsIgnoreCase(endTagName)) {
                        inComment = false;
                        break;
                    }
                    if ("ChangeLog".equalsIgnoreCase(endTagName)) {
                        inConsolidatedChangeLog = false;
                        break;
                    }
                    if ("UpdateLog".equalsIgnoreCase(endTagName)) {
                        inUpdateLog = false;
                        break;
                    }
                    if ("depot".equalsIgnoreCase(endTagName)) {
                        inDepot = false;
                        break;
                    }
                    if (!"webuiURL".equalsIgnoreCase(endTagName)) break;
                    inWebuiURL = false;
                    break;
                }
                case 4: {
                    if (inComment && currentTransaction != null) {
                        currentTransaction.setMsg(parser.getText());
                    } else if (inVersion && inIssueNum && currentTransaction != null) {
                        String issueNum = parser.getText();
                        currentTransaction.setIssueNum(issueNum);
                        if (webuiURL != null && !webuiURL.isEmpty()) {
                            currentTransaction.setWebuiURLforIssue(webuiURL + "/WebGui.jsp?depot=" + depotName + "&issueNum=" + issueNum + "&view=issue");
                        }
                    } else if (inDepot) {
                        depotName = parser.getText();
                    } else if (inWebuiURL) {
                        webuiURL = parser.getText();
                    }
                    if (inConsolidatedChangeLog) {
                        File subChangeLog = new File(changeLogFile.getParent(), parser.getText());
                        transactions.addAll(this.parse(subChangeLog, updateLog));
                    }
                    if (!inUpdateLog) break;
                    File updateLogFile = new File(changeLogFile.getParent(), parser.getText());
                    this.parseUpdate(updateLogFile, updateLog);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUpdate(File updateLogFile, UpdateLog updateLog) throws IOException {
        ParseUpdate parseUpdate = new ParseUpdate();
        ArrayList<String> updatedFiles = new ArrayList<String>();
        updateLog.changedFiles = updatedFiles;
        try {
            try {
                XmlPullParser parser = XmlParserFactory.newParser();
                try (BufferedReader br = Files.newBufferedReader(updateLogFile.toPath());){
                    parser.setInput((Reader)br);
                    parseUpdate.parse(parser, (List<String>)updatedFiles);
                }
                finally {
                    parser.setInput(null);
                }
            }
            catch (XmlPullParserException e) {
                throw new IOException(e);
            }
        }
        catch (AccurevLauncher.UnhandledAccurevCommandOutput ex) {
            throw new IOException(ex);
        }
    }

    private static class UpdateLog {
        private List<String> changedFiles;

        private UpdateLog() {
        }

        public boolean hasUpdate() {
            return this.changedFiles != null;
        }

        public boolean hasChanges() {
            return this.hasUpdate() && !this.changedFiles.isEmpty();
        }
    }
}

