/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.plugins.accurev.RemoteWorkspaceDetails;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jenkinsci.remoting.RoleChecker;

public class DetermineRemoteHostname
implements Callable<RemoteWorkspaceDetails, UnknownHostException> {
    private final String path;

    public DetermineRemoteHostname(String path) {
        this.path = path;
    }

    public RemoteWorkspaceDetails call() throws UnknownHostException {
        String path;
        InetAddress addr = InetAddress.getLocalHost();
        File f = new File(this.path);
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            path = f.getAbsolutePath();
        }
        String ipPattern = "^(([01]?[0-9]?[0-9]|2([0-4][0-9]|5[0-5]))\\.){3}([01]?[0-9]?[0-9]|2([0-4][0-9]|5[0-5]))$";
        String hostName = addr.getCanonicalHostName();
        if (hostName.matches(ipPattern)) {
            hostName = addr.getHostName();
        }
        if (hostName.matches(ipPattern)) {
            throw new UnknownHostException("Found IP, but need HostName, ensure proper FQDN.");
        }
        return new RemoteWorkspaceDetails(hostName, path);
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }
}

