/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.AccurevStream;
import hudson.plugins.accurev.AccurevTransaction;
import hudson.plugins.accurev.cmd.History;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;

public class CheckForChanges {
    public static boolean checkStreamForChanges(AccurevSCM.AccurevServer server, EnvVars accurevEnv, FilePath workspace, TaskListener listener, Launcher launcher, AccurevStream stream, Date buildDate, Logger logger, AccurevSCM scm) {
        AccurevTransaction latestCodeChangeTransaction = new AccurevTransaction();
        String filterForPollSCM = scm.getFilterForPollSCM();
        String subPath = scm.getSubPath();
        latestCodeChangeTransaction.setDate(AccurevSCM.NO_TRANS_DATE);
        List<String> validTransactionTypes = stream.getType().name().equalsIgnoreCase("workspace") ? AccurevSCM.DEFAULT_VALID_WORKSPACE_TRANSACTION_TYPES : AccurevSCM.DEFAULT_VALID_STREAM_TRANSACTION_TYPES;
        listener.getLogger().println("Checking transactions of type " + String.join((CharSequence)", ", validTransactionTypes) + " in stream [" + stream.getName() + "]");
        boolean isTransLatestThanBuild = false;
        Set<String> pollingFilters = CheckForChanges.getListOfPollingFilters(filterForPollSCM, subPath);
        for (String transactionType : validTransactionTypes) {
            try {
                AccurevTransaction tempTransaction = History.getLatestTransaction(scm, server, accurevEnv, workspace, listener, launcher, stream.getName(), transactionType);
                if (tempTransaction != null) {
                    listener.getLogger().println("Last transaction of type [" + transactionType + "] is " + (Object)((Object)tempTransaction));
                    if (latestCodeChangeTransaction.getDate().before(tempTransaction.getDate())) {
                        Collection<String> serverPaths = tempTransaction.getAffectedPaths();
                        if (tempTransaction.getAffectedPaths().size() > 0 && !CheckForChanges.changesMatchFilter(serverPaths, pollingFilters)) continue;
                    }
                    if ((latestCodeChangeTransaction = tempTransaction).getDate().equals(AccurevSCM.NO_TRANS_DATE)) {
                        listener.getLogger().println("No last transaction found.");
                    }
                    if (buildDate == null || !buildDate.before(latestCodeChangeTransaction.getDate())) continue;
                    listener.getLogger().println("Last valid trans " + (Object)((Object)latestCodeChangeTransaction));
                    isTransLatestThanBuild = true;
                    continue;
                }
                listener.getLogger().println("No transactions of type [" + transactionType + "]");
            }
            catch (Exception e) {
                String msg = "getLatestTransaction failed when checking the stream " + stream.getName() + " for changes with transaction type " + transactionType;
                listener.getLogger().println(msg);
                e.printStackTrace(listener.getLogger());
                logger.log(Level.WARNING, msg, e);
            }
        }
        return isTransLatestThanBuild;
    }

    public static boolean changesMatchFilter(Collection<String> serverPaths, Collection<String> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return true;
        }
        for (String path : serverPaths) {
            path = CheckForChanges.sanitizeSlashes(path);
            for (String filter : filters) {
                if (!CheckForChanges.pathMatcher(path, filter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean pathMatcher(String path, String wildcard) {
        return FilenameUtils.wildcardMatch((String)path, (String)wildcard, (IOCase)IOCase.INSENSITIVE);
    }

    private static Set<String> getListOfPollingFilters(String filterForPollSCM, String subPath) {
        if (StringUtils.isNotBlank((String)filterForPollSCM)) {
            return CheckForChanges.splitAndSanitizeFilters(filterForPollSCM);
        }
        return CheckForChanges.splitAndSanitizeFilters(subPath);
    }

    private static Set<String> splitAndSanitizeFilters(String input) {
        if (StringUtils.isBlank((String)input)) {
            return null;
        }
        int DELIMITER = 44;
        String STRIP_CHARS = " \t\n\r/";
        String[] filters = StringUtils.split((String)CheckForChanges.sanitizeSlashes(input), (char)',');
        filters = StringUtils.stripAll((String[])filters, (String)" \t\n\r/");
        return new HashSet<String>(Arrays.asList(filters));
    }

    private static String sanitizeSlashes(String input) {
        return input.replace('\\', '/');
    }
}

