/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public final class AccurevTransaction
extends ChangeLogSet.Entry {
    private static final String FIELD_SEPARATOR = ", ";
    private static final String EQ = "=";
    private final List<String> affectedPaths = new ArrayList<String>();
    private final List<String> affectedRawPaths = new ArrayList<String>();
    private final List<String> fileRevisions = new ArrayList<String>();
    private User author;
    private Date date;
    private String msg;
    private String action;
    private String id;
    private String issueNum;
    private String webuiURLforTrans;
    private String webuiURLforIssue;

    @Exported
    public String getIssueNum() {
        return this.issueNum;
    }

    public void setIssueNum(String issueNum) {
        this.issueNum = issueNum;
    }

    @Exported
    public String getWebuiURLforTrans() {
        return this.webuiURLforTrans;
    }

    public void setWebuiURLforTrans(String webuiURLforTrans) {
        this.webuiURLforTrans = webuiURLforTrans;
    }

    @Exported
    public String getWebuiURLforIssue() {
        return this.webuiURLforIssue;
    }

    public void setWebuiURLforIssue(String webuiURLforIssue) {
        this.webuiURLforIssue = webuiURLforIssue;
    }

    public void addFileRevision(String revision) {
        this.fileRevisions.add(revision);
    }

    @Exported
    public User getAuthor() {
        return this.author;
    }

    @Exported
    public Collection<String> getAffectedPaths() {
        return this.affectedPaths;
    }

    public List<String> getAffectedRawPaths() {
        return this.affectedRawPaths;
    }

    @Exported
    public Collection<String> getFileRevisions() {
        return this.fileRevisions;
    }

    @Exported
    public String getUser() {
        return this.author.getDisplayName();
    }

    public void setUser(String author) {
        this.author = User.get((String)author);
    }

    @Exported
    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = (Date)date.clone();
    }

    @Exported
    public String getMsg() {
        return StringUtils.isEmpty((String)this.msg) ? "" : this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    @Exported
    public EditType getEditType() {
        if (this.action.equals("promote")) {
            return EditType.EDIT;
        }
        if (this.action.equals("defunct")) {
            return EditType.DELETE;
        }
        if (this.action.equals("chstream")) {
            return EditType.EDIT;
        }
        if (this.action.equals("add")) {
            return EditType.ADD;
        }
        return EditType.EDIT;
    }

    public void addAffectedPath(String path) {
        this.affectedPaths.add(path);
    }

    public void addAffectedRawPath(String path) {
        this.affectedRawPaths.add(path);
    }

    @Exported
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
        if ("chstream".equals(action) && StringUtils.isEmpty((String)this.msg)) {
            this.msg = "Changed Parent Stream";
        }
    }

    @Exported
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "[id=" + this.id + FIELD_SEPARATOR + "date" + EQ + this.date + FIELD_SEPARATOR + "author" + EQ + this.author + FIELD_SEPARATOR + "action" + EQ + this.action + FIELD_SEPARATOR + "msg" + EQ + this.getMsg() + ']';
    }
}

