/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.accurev.AccurevMode;
import hudson.plugins.accurev.ParseChangeLog;
import hudson.plugins.accurev.cmd.Login;
import hudson.plugins.accurev.delegates.AbstractModeDelegate;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.plugins.accurev.AccurevTool;
import jenkins.plugins.accurev.util.UUIDUtils;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AccurevSCM
extends SCM {
    protected static final List<String> DEFAULT_VALID_STREAM_TRANSACTION_TYPES = Collections.unmodifiableList(Arrays.asList("chstream", "defcomp", "mkstream", "promote", "demote_to", "demote_from", "purge"));
    protected static final List<String> DEFAULT_VALID_WORKSPACE_TRANSACTION_TYPES = Collections.unmodifiableList(Arrays.asList("add", "chstream", "co", "defcomp", "defunct", "keep", "mkstream", "move", "promote", "purge", "dispatch"));
    static final Date NO_TRANS_DATE = new Date(0L);
    private static final Logger LOGGER = Logger.getLogger(AccurevSCM.class.getName());
    private final String depot;
    private final String stream;
    private String serverName;
    private boolean ignoreStreamParent;
    private String wspaceORreftree;
    private boolean cleanreftree;
    private String workspace;
    private boolean useSnapshot;
    private boolean dontPopContent;
    private String snapshotNameFormat;
    private boolean synctime;
    private String reftree;
    private String subPath;
    private String filterForPollSCM;
    private String directoryOffset;
    private boolean useReftree;
    private boolean useWorkspace;
    private boolean noWspaceNoReftree;
    private String serverUUID;
    @CheckForNull
    private String accurevTool = null;
    private Job<?, ?> activeProject;

    @DataBoundConstructor
    public AccurevSCM(String serverName, String depot, String stream) {
        this.depot = depot;
        this.stream = stream;
        AccurevServer server = this.getDescriptor().getServer(serverName);
        if (server != null) {
            this.setServerName(server.getName());
            this.setServerUUID(server.getUuid());
        }
        this.updateMode();
    }

    public static AccurevSCMDescriptor configuration() {
        return (AccurevSCMDescriptor)Jenkins.getInstance().getDescriptorByType(AccurevSCMDescriptor.class);
    }

    public String getDepot() {
        return this.depot;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public void setServerUUID(String uuid) {
        this.serverUUID = uuid;
    }

    @CheckForNull
    public AccurevServer getServer() {
        AccurevServer server;
        AccurevSCMDescriptor descriptor = this.getDescriptor();
        if (this.serverUUID == null) {
            if (this.serverName == null) {
                LOGGER.severe("AccurevSCM.getServer called but serverName and serverUUID are NULL!");
                return null;
            }
            LOGGER.warning("Getting server by name (" + this.serverName + "), because UUID is not set.");
            server = descriptor.getServer(this.serverName);
            if (server != null) {
                this.setServerUUID(server.getUuid());
                descriptor.save();
            }
        } else {
            server = descriptor.getServer(this.serverUUID);
        }
        return server;
    }

    public String getStream() {
        return this.stream;
    }

    public String getWspaceORreftree() {
        return this.wspaceORreftree;
    }

    @DataBoundSetter
    public void setWspaceORreftree(String wspaceORreftree) {
        if (wspaceORreftree.equals("none")) {
            wspaceORreftree = null;
        }
        this.wspaceORreftree = wspaceORreftree;
        this.updateMode();
    }

    public String getReftree() {
        return this.reftree;
    }

    @DataBoundSetter
    public void setReftree(String reftree) {
        this.reftree = Util.fixEmpty((String)reftree);
    }

    public String getWorkspace() {
        return this.workspace;
    }

    @DataBoundSetter
    public void setWorkspace(String workspace) {
        this.workspace = Util.fixEmpty((String)workspace);
    }

    @CheckForNull
    public String getAccurevTool() {
        return this.accurevTool;
    }

    @DataBoundSetter
    public void setAccurevTool(String accurevTool) {
        this.accurevTool = Util.fixEmpty((String)accurevTool);
    }

    public String getSubPath() {
        return this.subPath;
    }

    @DataBoundSetter
    public void setSubPath(String subPath) {
        this.subPath = Util.fixEmpty((String)subPath);
    }

    public String getFilterForPollSCM() {
        return this.filterForPollSCM;
    }

    @DataBoundSetter
    public void setFilterForPollSCM(String filterForPollSCM) {
        this.filterForPollSCM = Util.fixEmpty((String)filterForPollSCM);
    }

    public String getSnapshotNameFormat() {
        return this.snapshotNameFormat;
    }

    @DataBoundSetter
    public void setSnapshotNameFormat(String snapshotNameFormat) {
        this.snapshotNameFormat = Util.fixEmpty((String)snapshotNameFormat);
    }

    public boolean isIgnoreStreamParent() {
        return this.ignoreStreamParent;
    }

    @DataBoundSetter
    public void setIgnoreStreamParent(boolean ignoreStreamParent) {
        this.ignoreStreamParent = ignoreStreamParent;
    }

    public boolean isSynctime() {
        return this.synctime;
    }

    @DataBoundSetter
    public void setSynctime(boolean synctime) {
        this.synctime = synctime;
    }

    public boolean isDontPopContent() {
        return this.dontPopContent;
    }

    @DataBoundSetter
    public void setDontPopContent(boolean dontPopContent) {
        this.dontPopContent = dontPopContent;
    }

    public boolean isCleanreftree() {
        return this.cleanreftree;
    }

    @DataBoundSetter
    public void setCleanreftree(boolean cleanreftree) {
        this.cleanreftree = cleanreftree;
    }

    public boolean isUseSnapshot() {
        return this.useSnapshot;
    }

    @DataBoundSetter
    public void setUseSnapshot(boolean useSnapshot) {
        this.useSnapshot = useSnapshot;
        if (!useSnapshot) {
            this.snapshotNameFormat = "";
        }
    }

    public boolean isUseReftree() {
        return this.useReftree;
    }

    public boolean isUseWorkspace() {
        return this.useWorkspace;
    }

    public boolean isNoWspaceNoReftree() {
        return this.noWspaceNoReftree;
    }

    public String getDirectoryOffset() {
        return this.directoryOffset;
    }

    @DataBoundSetter
    public void setDirectoryOffset(String directoryOffset) {
        this.directoryOffset = Util.fixEmpty((String)directoryOffset);
    }

    private void updateMode() {
        AccurevMode accurevMode = AccurevMode.findMode(this);
        this.useReftree = accurevMode.isReftree();
        this.useWorkspace = accurevMode.isWorkspace();
        this.noWspaceNoReftree = accurevMode.isNoWorkspaceOrRefTree();
    }

    public AccurevSCMDescriptor getDescriptor() {
        return (AccurevSCMDescriptor)super.getDescriptor();
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        this.buildEnvironment((Run<?, ?>)build, env);
    }

    public void buildEnvironment(Run<?, ?> build, Map<String, String> env) {
        AbstractModeDelegate delegate = AccurevMode.findDelegate(this);
        delegate.buildEnvVars(build, env);
    }

    public void checkout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        boolean checkout = AccurevMode.findDelegate(this).checkout(build, launcher, workspace, listener, changelogFile);
        if (checkout) {
            listener.getLogger().println("Checkout done");
        } else {
            listener.getLogger().println("Checkout failed");
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new AccurevChangeLogParser();
    }

    public boolean requiresWorkspaceForPolling() {
        boolean requiresWorkspace = AccurevMode.findMode(this).isRequiresWorkspace();
        if (this.getDescriptor().isPollOnMaster() && !requiresWorkspace) {
            return false;
        }
        if (this.activeProject != null && !this.activeProject.isBuilding()) {
            this.activeProject = null;
        }
        return requiresWorkspace && this.activeProject == null;
    }

    public Lock getOptionalLock() {
        boolean shouldLock;
        AccurevServer server = this.getServer();
        boolean bl = shouldLock = server != null && server.isSyncOperations();
        if (shouldLock) {
            return this.getMandatoryLock();
        }
        return null;
    }

    private Lock getMandatoryLock() {
        return AccurevSCMDescriptor.ACCUREV_LOCK;
    }

    public SCMRevisionState calcRevisionsFromBuild(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public PollingResult compareRemoteRevisionWith(@Nonnull Job<?, ?> project, @Nullable Launcher launcher, @Nullable FilePath workspace, @Nonnull TaskListener listener, @Nonnull SCMRevisionState baseline) throws IOException, InterruptedException {
        if (this.activeProject != null && this.activeProject.isBuilding()) {
            return PollingResult.NO_CHANGES;
        }
        this.activeProject = project;
        AbstractModeDelegate delegate = AccurevMode.findDelegate(this);
        return delegate.compareRemoteRevisionWith(project, launcher, workspace, listener, baseline);
    }

    public boolean hasStringVariableReference(String str) {
        return StringUtils.isNotEmpty((String)str) && str.startsWith("$");
    }

    public String getPollingStream(Job<?, ?> project, TaskListener listener) throws IllegalArgumentException {
        String parsedLocalStream;
        if (this.hasStringVariableReference(this.stream)) {
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (paramDefProp == null) {
                throw new IllegalArgumentException("Polling is not supported when stream name has a variable reference '" + this.stream + "'.");
            }
            TreeMap<String, String> keyValues = new TreeMap<String, String>();
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (!(defaultValue instanceof StringParameterValue)) continue;
                StringParameterValue strdefvalue = (StringParameterValue)defaultValue;
                keyValues.put(defaultValue.getName(), strdefvalue.value);
            }
            EnvVars environment = new EnvVars(keyValues);
            parsedLocalStream = environment.expand(this.getStream());
            listener.getLogger().println("... expanded '" + this.stream + "' to '" + parsedLocalStream + "'.");
        } else {
            parsedLocalStream = this.stream;
        }
        if (this.hasStringVariableReference(parsedLocalStream)) {
            throw new IllegalArgumentException("Failed to expand variable reference '" + this.stream + "'.");
        }
        return parsedLocalStream;
    }

    private static final class AccurevChangeLogParser
    extends ParseChangeLog {
        private AccurevChangeLogParser() {
        }
    }

    public static final class AccurevServer
    extends AbstractDescribableImpl<AccurevServer> {
        private static final transient String __OBFUSCATE = "OBF:";
        private final String name;
        private final String host;
        @Deprecated
        transient String username;
        @Deprecated
        transient String password;
        private int port = 5050;
        private String credentialsId;
        private UUID uuid;
        private boolean syncOperations;
        private boolean minimiseLogins;
        private boolean useNonexpiringLogin;
        private boolean useRestrictedShowStreams;
        private boolean useColor;
        private boolean usePromoteListen;
        private boolean serverDisabled;

        @DataBoundConstructor
        public AccurevServer(String uuid, String name, String host) {
            this.uuid = StringUtils.isEmpty((String)uuid) ? UUID.randomUUID() : UUID.fromString(uuid);
            this.name = name;
            this.host = host;
        }

        private static String deobfuscate(String s) {
            if (s.startsWith(__OBFUSCATE)) {
                s = s.substring(__OBFUSCATE.length());
            }
            if (StringUtils.isEmpty((String)s)) {
                return "";
            }
            byte[] b = new byte[s.length() / 2];
            int l = 0;
            for (int i = 0; i < s.length(); i += 4) {
                String x = s.substring(i, i + 4);
                int i0 = Integer.parseInt(x, 36);
                int i1 = i0 / 256;
                int i2 = i0 % 256;
                b[l++] = (byte)((i1 + i2 - 254) / 2);
            }
            return new String(b, 0, l, StandardCharsets.UTF_8);
        }

        private Object readResolve() {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            return this;
        }

        public String getUuid() {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            return this.uuid.toString();
        }

        public String getName() {
            return this.name;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        @DataBoundSetter
        public void setPort(int port) {
            this.port = port;
        }

        public String getCredentialsId() {
            return this.credentialsId;
        }

        @DataBoundSetter
        public void setCredentialsId(String credentialsId) {
            this.credentialsId = credentialsId;
        }

        @CheckForNull
        public StandardUsernamePasswordCredentials getCredentials() {
            if (StringUtils.isBlank((String)this.credentialsId)) {
                return null;
            }
            return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)"").withHostnamePort(this.host, this.port).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
        }

        public String getUsername() {
            StandardUsernamePasswordCredentials credentials = this.getCredentials();
            return credentials == null ? "jenkins" : credentials.getUsername();
        }

        @Deprecated
        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            StandardUsernamePasswordCredentials credentials = this.getCredentials();
            return credentials == null ? "" : Secret.toString((Secret)credentials.getPassword());
        }

        @Deprecated
        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isSyncOperations() {
            return this.syncOperations;
        }

        @DataBoundSetter
        public void setSyncOperations(boolean syncOperations) {
            this.syncOperations = syncOperations;
        }

        public boolean isMinimiseLogins() {
            return this.minimiseLogins;
        }

        @DataBoundSetter
        public void setMinimiseLogins(boolean minimiseLogins) {
            this.minimiseLogins = minimiseLogins;
        }

        public boolean isUseNonexpiringLogin() {
            return this.useNonexpiringLogin;
        }

        @DataBoundSetter
        public void setUseNonexpiringLogin(boolean useNonexpiringLogin) {
            this.useNonexpiringLogin = useNonexpiringLogin;
        }

        public boolean isUseRestrictedShowStreams() {
            return this.useRestrictedShowStreams;
        }

        @DataBoundSetter
        public void setUseRestrictedShowStreams(boolean useRestrictedShowStreams) {
            this.useRestrictedShowStreams = useRestrictedShowStreams;
        }

        public boolean isUseColor() {
            return this.useColor;
        }

        @DataBoundSetter
        public void setUseColor(boolean useColor) {
            this.useColor = useColor;
        }

        public boolean isUsePromoteListen() {
            return this.usePromoteListen;
        }

        @DataBoundSetter
        public void setUsePromoteListen(boolean usePromoteListen) {
            this.usePromoteListen = usePromoteListen;
        }

        public boolean isServerDisabled() {
            return this.serverDisabled;
        }

        @DataBoundSetter
        public void setServerDisabled(boolean serverDisabled) {
            this.serverDisabled = serverDisabled;
        }

        public boolean migrateCredentials() {
            if (this.username != null) {
                LOGGER.info("Migrating to credentials");
                String secret = AccurevServer.deobfuscate(this.password);
                String credentialsId = "";
                List domainRequirements = Util.fixNull((List)URIRequirementBuilder.fromUri((String)"").withHostnamePort(this.host, this.port).build());
                List credentials = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)domainRequirements), (CredentialsMatcher)CredentialsMatchers.withUsername((String)this.username));
                for (StandardUsernamePasswordCredentials cred : credentials) {
                    if (!StringUtils.equals((String)secret, (String)Secret.toString((Secret)cred.getPassword()))) continue;
                    this.credentialsId = credentialsId = cred.getId();
                    break;
                }
                if (StringUtils.isBlank((String)credentialsId)) {
                    UsernamePasswordCredentialsImpl newCredentials = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, null, "Migrated by Accurev Plugin", this.username, secret);
                    SystemCredentialsProvider.getInstance().getCredentials().add(newCredentials);
                    this.credentialsId = credentialsId = newCredentials.getId();
                }
                if (StringUtils.isNotEmpty((String)this.credentialsId)) {
                    LOGGER.info("Migrated successfully to credentials");
                    this.username = null;
                    this.password = null;
                    return true;
                }
                LOGGER.severe("Migration failed");
            }
            return false;
        }

        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<AccurevServer> {
            @Nonnull
            public String getDisplayName() {
                return "AccuRev Server";
            }

            public ListBoxModel doFillCredentialsIdItems(@QueryParameter String host, @QueryParameter int port, @QueryParameter String credentialsId) {
                if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                    return new StandardListBoxModel().includeCurrentValue(credentialsId);
                }
                return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)"").withHostnamePort(host, port).build(), CredentialsMatchers.always());
            }

            public FormValidation doTest(@QueryParameter String name, @QueryParameter String host, @QueryParameter int port, @QueryParameter String credentialsId) throws IOException {
                try {
                    if (null == host || host.isEmpty()) {
                        return FormValidation.warning((String)"No Host Provided");
                    }
                    AccurevServer server = new AccurevServer("", name, host);
                    server.setPort(port);
                    server.setCredentialsId(credentialsId);
                    if (Login.accurevLoginFromGlobalConfig(server)) {
                        return FormValidation.ok((String)"SUCCESS");
                    }
                    return FormValidation.error((String)"FAILURE");
                }
                catch (Exception e) {
                    return FormValidation.error((String)("FAILURE : " + e.getMessage()));
                }
            }
        }
    }

    @Extension
    public static class AccurevSCMDescriptor
    extends SCMDescriptor<AccurevSCM>
    implements ModelObject {
        static final transient Lock ACCUREV_LOCK = new ReentrantLock();
        private static final Logger DESCRIPTORLOGGER = Logger.getLogger(AccurevSCMDescriptor.class.getName());
        private List<AccurevServer> _servers;
        private transient List<AccurevServer> servers;
        private boolean pollOnMaster;

        public AccurevSCMDescriptor() {
            super(AccurevSCM.class, null);
            this.load();
        }

        public static void lock() {
            ACCUREV_LOCK.lock();
        }

        public static void unlock() {
            ACCUREV_LOCK.unlock();
        }

        @Nonnull
        public String getDisplayName() {
            return "AccuRev";
        }

        public boolean showAccurevToolOptions() {
            return ((AccurevTool[])((AccurevTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(AccurevTool.DescriptorImpl.class)).getInstallations()).length > 1;
        }

        public List<AccurevTool> getAccurevTools() {
            AccurevTool[] accurevToolInstallations = (AccurevTool[])((AccurevTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(AccurevTool.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(accurevToolInstallations);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        @Nonnull
        public List<AccurevServer> getServers() {
            if (this._servers == null) {
                this._servers = new ArrayList<AccurevServer>();
            }
            if (this.servers != null) {
                this._servers.addAll(this.servers);
                this.servers = null;
            }
            return this._servers;
        }

        public void setServers(List<AccurevServer> servers) {
            this._servers = servers;
        }

        public boolean isPollOnMaster() {
            return this.pollOnMaster;
        }

        @DataBoundSetter
        public void setPollOnMaster(boolean pollOnMaster) {
            this.pollOnMaster = pollOnMaster;
        }

        @CheckForNull
        public AccurevServer getServer(String uuid) {
            if (uuid == null || this._servers == null) {
                LOGGER.fine("No server found. - getServer(NULL)");
                return null;
            }
            for (AccurevServer server : this._servers) {
                if (UUIDUtils.isValid(uuid) && uuid.equals(server.getUuid())) {
                    return server;
                }
                if (!uuid.equals(server.getName())) continue;
                return server;
            }
            LOGGER.fine("No server found.");
            return null;
        }

        public ListBoxModel doFillServerNameItems() {
            ListBoxModel s = new ListBoxModel();
            if (this._servers == null) {
                DESCRIPTORLOGGER.warning("Failed to find AccuRev server. Add Server under AccuRev section in the Manage Jenkins > Configure System page.");
                return s;
            }
            for (AccurevServer server : this._servers) {
                s.add(server.getName());
            }
            return s;
        }

        public ListBoxModel doFillAccurevToolItems() {
            ListBoxModel r = new ListBoxModel();
            for (AccurevTool accurev : this.getAccurevTools()) {
                r.add(accurev.getName());
            }
            return r;
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        public FormValidation doCheckServerName(@QueryParameter String value) throws IOException {
            AccurevServer server;
            if (StringUtils.isBlank((String)value) && !this.getServers().isEmpty()) {
                value = this.getServers().get(0).getUuid();
            }
            if (null != value && null != (server = this.getServer(value)) && server.isServerDisabled()) {
                return FormValidation.error((String)"This server is disabled");
            }
            return FormValidation.ok();
        }
    }
}

