/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.plugins.accurev.AccurevSCM;
import hudson.plugins.accurev.delegates.AbstractModeDelegate;
import hudson.plugins.accurev.delegates.ReftreeDelegate;
import hudson.plugins.accurev.delegates.SnapshotDelegate;
import hudson.plugins.accurev.delegates.StreamDelegate;
import hudson.plugins.accurev.delegates.WorkspaceDelegate;

public enum AccurevMode {
    WORKSPACE(true){

        @Override
        protected AbstractModeDelegate createDelegate(AccurevSCM accurevSCM) {
            return new WorkspaceDelegate(accurevSCM);
        }

        @Override
        protected boolean isMode(AccurevSCM accurevSCM) {
            return "wspace".equals(accurevSCM.getWspaceORreftree());
        }

        @Override
        public boolean isWorkspace() {
            return true;
        }
    }
    ,
    REF_TREE(true){

        @Override
        protected AbstractModeDelegate createDelegate(AccurevSCM accurevSCM) {
            return new ReftreeDelegate(accurevSCM);
        }

        @Override
        protected boolean isMode(AccurevSCM accurevSCM) {
            return "reftree".equals(accurevSCM.getWspaceORreftree());
        }

        @Override
        public boolean isReftree() {
            return true;
        }
    }
    ,
    SNAPSHOT(false){

        @Override
        protected AbstractModeDelegate createDelegate(AccurevSCM accurevSCM) {
            return new SnapshotDelegate(accurevSCM);
        }

        @Override
        protected boolean isMode(AccurevSCM accurevSCM) {
            return !WORKSPACE.isMode(accurevSCM) && !REF_TREE.isMode(accurevSCM) && accurevSCM.isUseSnapshot();
        }

        @Override
        public boolean isNoWorkspaceOrRefTree() {
            return true;
        }
    }
    ,
    STREAM(false){

        @Override
        protected AbstractModeDelegate createDelegate(AccurevSCM accurevSCM) {
            return new StreamDelegate(accurevSCM);
        }

        @Override
        protected boolean isMode(AccurevSCM accurevSCM) {
            return !WORKSPACE.isMode(accurevSCM) && !REF_TREE.isMode(accurevSCM) && !accurevSCM.isUseSnapshot();
        }

        @Override
        public boolean isNoWorkspaceOrRefTree() {
            return true;
        }
    };

    private final boolean requiresWorkspace;

    private AccurevMode(boolean requiresWorkspace) {
        this.requiresWorkspace = requiresWorkspace;
    }

    public static AbstractModeDelegate findDelegate(AccurevSCM accurevSCM) {
        AccurevMode accurevMode = AccurevMode.findMode(accurevSCM);
        return accurevMode.createDelegate(accurevSCM);
    }

    public static AccurevMode findMode(AccurevSCM accurevSCM) {
        AccurevMode retVal = null;
        for (AccurevMode accurevMode : AccurevMode.values()) {
            if (!accurevMode.isMode(accurevSCM)) continue;
            retVal = accurevMode;
            break;
        }
        return retVal;
    }

    public boolean isRequiresWorkspace() {
        return this.requiresWorkspace;
    }

    public boolean isWorkspace() {
        return false;
    }

    public boolean isReftree() {
        return false;
    }

    public boolean isNoWorkspaceOrRefTree() {
        return false;
    }

    protected abstract boolean isMode(AccurevSCM var1);

    protected abstract AbstractModeDelegate createDelegate(AccurevSCM var1);
}

