/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.accurev.DetermineRemoteHostname;
import hudson.plugins.accurev.RemoteWorkspaceDetails;
import hudson.plugins.accurev.parsers.output.ParseIgnoreOutput;
import hudson.plugins.accurev.parsers.output.ParseLastFewLines;
import hudson.plugins.accurev.parsers.output.ParseOutputToStream;
import hudson.remoting.Callable;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.plugins.accurev.AccurevTool;
import jenkins.plugins.accurev.util.AccurevUtils;
import org.apache.commons.lang.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class AccurevLauncher {
    private static final Logger LOGGER = Logger.getLogger(AccurevLauncher.class.getName());

    public static boolean runCommand(@Nonnull String humanReadableCommandName, String accurevTool, @Nonnull Launcher launcher, @Nonnull ArgumentListBuilder machineReadableCommand, @Nullable Lock synchronizationLockObjectOrNull, @Nonnull EnvVars environmentVariables, @Nonnull FilePath directoryToRunCommandFrom, @Nonnull TaskListener listenerToLogFailuresTo, @Nonnull Logger loggerToLogFailuresTo, boolean ... optionalFlagToCopyAllOutputToTaskListener) throws IOException {
        boolean shouldLogEverything = optionalFlagToCopyAllOutputToTaskListener != null && optionalFlagToCopyAllOutputToTaskListener.length > 0 && optionalFlagToCopyAllOutputToTaskListener[0];
        Boolean result = shouldLogEverything ? AccurevLauncher.runCommand(humanReadableCommandName, accurevTool, launcher, machineReadableCommand, synchronizationLockObjectOrNull, environmentVariables, directoryToRunCommandFrom, listenerToLogFailuresTo, loggerToLogFailuresTo, new ParseOutputToStream(), listenerToLogFailuresTo.getLogger()) : AccurevLauncher.runCommand(humanReadableCommandName, accurevTool, launcher, machineReadableCommand, synchronizationLockObjectOrNull, environmentVariables, directoryToRunCommandFrom, listenerToLogFailuresTo, loggerToLogFailuresTo, new ParseIgnoreOutput(), null);
        if (result == null) {
            return false;
        }
        return result;
    }

    public static <TResult, TContext> TResult runCommand(@Nonnull String humanReadableCommandName, String accurevTool, @Nonnull Launcher launcher, @Nonnull ArgumentListBuilder machineReadableCommand, @Nullable Lock synchronizationLockObjectOrNull, @Nonnull EnvVars environmentVariables, @Nonnull FilePath directoryToRunCommandFrom, @Nonnull TaskListener listenerToLogFailuresTo, @Nonnull Logger loggerToLogFailuresTo, @Nonnull XmlPullParserFactory xmlParserFactory, @Nonnull ICmdOutputXmlParser<TResult, TContext> commandOutputParser, @Nullable TContext commandOutputParserContext) throws IOException {
        return (TResult)AccurevLauncher.runCommand(humanReadableCommandName, accurevTool, launcher, machineReadableCommand, synchronizationLockObjectOrNull, environmentVariables, directoryToRunCommandFrom, listenerToLogFailuresTo, loggerToLogFailuresTo, (cmdOutput, context) -> {
            XmlPullParser parser = null;
            try {
                parser = xmlParserFactory.newPullParser();
                parser.setInput(cmdOutput, null);
                Object result = commandOutputParser.parse(parser, context);
                parser.setInput(null);
                parser = null;
                Object TResult = result;
                return TResult;
            }
            catch (XmlPullParserException ex) {
                AccurevLauncher.logCommandException(machineReadableCommand, directoryToRunCommandFrom, humanReadableCommandName, ex, loggerToLogFailuresTo, listenerToLogFailuresTo);
                Object var11_13 = null;
                return var11_13;
            }
            finally {
                if (parser != null) {
                    try {
                        parser.setInput(null);
                    }
                    catch (XmlPullParserException ex) {
                        AccurevLauncher.logCommandException(machineReadableCommand, directoryToRunCommandFrom, humanReadableCommandName, ex, loggerToLogFailuresTo, listenerToLogFailuresTo);
                    }
                    cmdOutput.close();
                }
            }
        }, commandOutputParserContext);
    }

    public static <TResult, TContext> TResult runHistCommandForAll(@Nonnull String humanReadableCommandName, String accurevTool, @Nonnull Launcher launcher, @Nonnull ArgumentListBuilder machineReadableCommand, @Nullable Lock synchronizationLockObjectOrNull, @Nonnull EnvVars environmentVariables, @Nonnull FilePath directoryToRunCommandFrom, @Nonnull TaskListener listenerToLogFailuresTo, @Nonnull Logger loggerToLogFailuresTo, @Nonnull XmlPullParserFactory xmlParserFactory, @Nonnull ICmdOutputXmlParser<TResult, TContext> commandOutputParser, @Nullable TContext commandOutputParserContext) throws IOException {
        return (TResult)AccurevLauncher.runCommand(humanReadableCommandName, accurevTool, launcher, machineReadableCommand, synchronizationLockObjectOrNull, environmentVariables, directoryToRunCommandFrom, listenerToLogFailuresTo, loggerToLogFailuresTo, (cmdOutput, context) -> {
            XmlPullParser parser = null;
            try {
                parser = xmlParserFactory.newPullParser();
                parser.setInput(cmdOutput, null);
                Object result = commandOutputParser.parseAll(parser, context);
                parser.setInput(null);
                parser = null;
                Object TResult = result;
                return TResult;
            }
            catch (XmlPullParserException ex) {
                AccurevLauncher.logCommandException(machineReadableCommand, directoryToRunCommandFrom, humanReadableCommandName, ex, loggerToLogFailuresTo, listenerToLogFailuresTo);
                Object var11_13 = null;
                return var11_13;
            }
            finally {
                if (parser != null) {
                    try {
                        parser.setInput(null);
                    }
                    catch (XmlPullParserException ex) {
                        AccurevLauncher.logCommandException(machineReadableCommand, directoryToRunCommandFrom, humanReadableCommandName, ex, loggerToLogFailuresTo, listenerToLogFailuresTo);
                    }
                    cmdOutput.close();
                }
            }
        }, commandOutputParserContext);
    }

    /*
     * Exception decompiling
     */
    public static <TResult, TContext> TResult runCommand(@Nonnull String humanReadableCommandName, String accurevTool, @Nonnull Launcher launcher, @Nonnull ArgumentListBuilder machineReadableCommand, @Nullable Lock synchronizationLockObjectOrNull, @Nonnull EnvVars environmentVariables, @Nonnull FilePath directoryToRunCommandFrom, @Nonnull TaskListener listenerToLogFailuresTo, @Nonnull Logger loggerToLogFailuresTo, @Nonnull ICmdOutputParser<TResult, TContext> commandOutputParser, @Nullable TContext commandOutputParserContext) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static AccurevTool resolveAccurevTool(String accurevTool, TaskListener listener) {
        if (StringUtils.isBlank((String)accurevTool)) {
            AccurevTool defaultInstallation = AccurevTool.getDefaultInstallation();
            listener.getLogger().println(String.format("No Accurv tool is chosen, reverting to %s (%s)", defaultInstallation.getName(), defaultInstallation.getHome()));
            return defaultInstallation;
        }
        AccurevTool accurev = ((AccurevTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(AccurevTool.DescriptorImpl.class)).getInstallation(accurevTool);
        if (accurev == null) {
            accurev = AccurevTool.getDefaultInstallation();
            listener.getLogger().println(String.format("Selected Accurev installation does not exist. Using Default %s (%s)", accurev.getName(), accurev.getHome()));
        }
        return accurev;
    }

    public static String getAccurevExe(String accurevTool, Node builtOn, EnvVars env, TaskListener listener) {
        AccurevTool tool = AccurevLauncher.resolveAccurevTool(accurevTool, listener);
        if (builtOn != null) {
            try {
                tool = tool.forNode(builtOn, listener);
            }
            catch (IOException | InterruptedException e) {
                listener.getLogger().println("Failed to get accurev executable");
            }
        }
        if (env != null) {
            tool = tool.forEnvironment(env);
        }
        return tool.getHome();
    }

    private static Integer runCommandToCompletion(Launcher.ProcStarter starter, Lock synchronizationLockObjectOrNull) throws IOException, InterruptedException {
        try {
            if (synchronizationLockObjectOrNull != null) {
                synchronizationLockObjectOrNull.lock();
            }
            Integer n = starter.join();
            return n;
        }
        finally {
            if (synchronizationLockObjectOrNull != null) {
                synchronizationLockObjectOrNull.unlock();
            }
        }
    }

    private static Launcher.ProcStarter createProcess(@Nonnull Launcher launcher, @Nonnull ArgumentListBuilder machineReadableCommand, @Nonnull EnvVars environmentVariables, @Nonnull FilePath directoryToRunCommandFrom, @Nonnull TaskListener listener, @Nonnull OutputStream stdoutStream, @Nonnull OutputStream stderrStream, String accurevTool) throws IllegalStateException, IOException, InterruptedException {
        String accurevPath = AccurevLauncher.getAccurevExe(accurevTool, AccurevUtils.workspaceToNode(directoryToRunCommandFrom), environmentVariables, listener);
        if (StringUtils.isBlank((String)accurevPath)) {
            accurevPath = "accurev";
        }
        if (!accurevPath.equals(machineReadableCommand.toCommandArray()[0])) {
            machineReadableCommand.prepend(new String[]{accurevPath});
        }
        if (!AccurevLauncher.justAccurev(launcher, accurevPath)) {
            throw new IllegalStateException("Cannot find accurev executable. Please check installation/tool");
        }
        Launcher.ProcStarter starter = launcher.launch().cmds(machineReadableCommand);
        Node n = AccurevUtils.workspaceToNode(directoryToRunCommandFrom);
        environmentVariables.putAll((Map)AccurevLauncher.buildEnvironment(n, listener));
        String path = null;
        FilePath filePath = null;
        if (null != n) {
            filePath = n.getRootPath();
        }
        if (null != filePath) {
            path = filePath.getRemote();
        }
        if (StringUtils.isNotBlank(path)) {
            environmentVariables.putIfAbsent((Object)"ACCUREV_HOME", (Object)path);
        }
        starter = starter.envs((Map)environmentVariables);
        starter = starter.stdout(stdoutStream).stderr(stderrStream);
        starter = starter.pwd(directoryToRunCommandFrom);
        return starter;
    }

    private static void logCommandFailure(ArgumentListBuilder command, FilePath directoryToRunCommandFrom, String commandDescription, int commandExitCode, InputStream commandStdoutOrNull, InputStream commandStderrOrNull, Logger loggerToLogFailuresTo, TaskListener taskListener) throws IOException {
        String msg = commandDescription + " (" + command.toString() + ") failed with exit code " + commandExitCode;
        String stderr = null;
        try {
            stderr = AccurevLauncher.getCommandErrorOutput(commandStdoutOrNull, commandStderrOrNull);
        }
        catch (IOException ex) {
            AccurevLauncher.logCommandException(command, directoryToRunCommandFrom, commandDescription, ex, loggerToLogFailuresTo, taskListener);
        }
        if (loggerToLogFailuresTo != null && (loggerToLogFailuresTo.isLoggable(Level.WARNING) || loggerToLogFailuresTo.isLoggable(Level.INFO))) {
            String hostname = AccurevLauncher.getRemoteHostname(directoryToRunCommandFrom);
            loggerToLogFailuresTo.warning(hostname + ": " + msg);
            if (stderr != null) {
                loggerToLogFailuresTo.info(hostname + ": " + stderr);
            }
        }
        if (taskListener != null) {
            if (stderr != null) {
                taskListener.fatalError(stderr);
            }
            taskListener.fatalError(msg);
        }
    }

    private static String getCommandErrorOutput(InputStream commandStdoutOrNull, InputStream commandStderrOrNull) throws IOException {
        StringBuilder outputText = new StringBuilder();
        if (commandStdoutOrNull != null) {
            AccurevLauncher.parseCommandOutput(commandStdoutOrNull, 10, outputText);
        }
        if (commandStderrOrNull != null) {
            AccurevLauncher.parseCommandOutput(commandStderrOrNull, 5, outputText);
        }
        if (outputText.length() > 0) {
            return outputText.toString();
        }
        return null;
    }

    private static void parseCommandOutput(InputStream commandOutput, Integer maxNumberOfLines, StringBuilder outputText) throws IOException {
        String newLine = System.getProperty("line.separator");
        ParseLastFewLines tailParser = new ParseLastFewLines();
        List<String> outputLines = tailParser.parse(commandOutput, maxNumberOfLines);
        for (String line : outputLines) {
            if (outputText.length() > 0) {
                outputText.append(newLine);
            }
            outputText.append(line);
        }
    }

    private static void logCommandException(ArgumentListBuilder command, FilePath directoryToRunCommandFrom, String commandDescription, Throwable exception, Logger loggerToLogFailuresTo, TaskListener taskListener) throws IOException {
        String hostname = AccurevLauncher.getRemoteHostname(directoryToRunCommandFrom);
        String msg = hostname + ": " + commandDescription + " (" + command.toString() + ") failed with " + exception.toString();
        AccurevLauncher.logException(msg, exception, loggerToLogFailuresTo, taskListener);
    }

    static void logException(String summary, Throwable exception, Logger logger, TaskListener taskListener) throws IOException {
        if (logger != null) {
            logger.log(Level.SEVERE, summary, exception);
        }
        if (taskListener != null) {
            taskListener.fatalError(summary);
            exception.printStackTrace(taskListener.getLogger());
            throw new AbortException(exception.getMessage());
        }
    }

    private static void logCommandExecution(String commandDescription, ArgumentListBuilder command, FilePath directoryToRunCommandFrom, Logger loggerToLogFailuresTo, TaskListener taskListener) {
        if (loggerToLogFailuresTo != null && loggerToLogFailuresTo.isLoggable(Level.FINE)) {
            String hostname = AccurevLauncher.getRemoteHostname(directoryToRunCommandFrom);
            String msg = hostname + ": " + command.toString();
            loggerToLogFailuresTo.log(Level.FINE, msg);
        }
    }

    private static String getRemoteHostname(FilePath directoryToRunCommandFrom) {
        try {
            RemoteWorkspaceDetails act = (RemoteWorkspaceDetails)directoryToRunCommandFrom.act((Callable)new DetermineRemoteHostname("."));
            return act.getHostName();
        }
        catch (UnknownHostException e) {
            return "Unable to determine actual hostname, ensure proper FQDN.\n" + e.toString();
        }
        catch (IOException | InterruptedException e) {
            return e.toString();
        }
    }

    public static EnvVars buildEnvironment(Node node, TaskListener listener) throws IOException, InterruptedException {
        Computer computer;
        EnvVars env = null != node ? ((computer = node.toComputer()) != null ? computer.buildEnvironment(listener) : new EnvVars()) : new EnvVars();
        env.put("CLASSPATH", "");
        return env;
    }

    private static boolean justAccurev(Launcher launcher, String exe) {
        try {
            return launcher.launch().quiet(true).cmdAsSingleString(exe).join() == 0;
        }
        catch (IOException | InterruptedException e1) {
            return false;
        }
    }

    public static final class UnhandledAccurevCommandOutput
    extends Exception {
        public UnhandledAccurevCommandOutput(String message, Throwable cause) {
            super(message, cause);
        }

        public UnhandledAccurevCommandOutput(String message) {
            super(message);
        }

        public UnhandledAccurevCommandOutput(Throwable cause) {
            super(cause);
        }
    }

    public static interface ICmdOutputXmlParser<TResult, TContext> {
        public TResult parse(XmlPullParser var1, TContext var2) throws UnhandledAccurevCommandOutput, IOException, XmlPullParserException;

        default public TResult parseAll(XmlPullParser parser, TContext context) throws IOException, XmlPullParserException {
            return null;
        }
    }

    public static interface ICmdOutputParser<TResult, TContext> {
        public TResult parse(InputStream var1, TContext var2) throws UnhandledAccurevCommandOutput, IOException;
    }
}

