/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.accurev;

import hudson.model.Run;
import hudson.plugins.accurev.AccurevTransaction;
import hudson.scm.ChangeLogSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public final class AccurevChangeLogSet
extends ChangeLogSet<AccurevTransaction> {
    private final List<AccurevTransaction> transactions;

    AccurevChangeLogSet(Run build, List<AccurevTransaction> transactions) {
        super(build, null);
        if (transactions == null) {
            throw new NullPointerException("Cannot have a null transaction list");
        }
        this.transactions = Collections.unmodifiableList(transactions);
        for (AccurevTransaction transaction : transactions) {
            transaction.setParent(this);
        }
    }

    public boolean isEmptySet() {
        return this.transactions.isEmpty();
    }

    public Iterator<AccurevTransaction> iterator() {
        return this.transactions.iterator();
    }

    public Collection<AccurevTransaction> getLogs() {
        return this.transactions;
    }

    public Object[] toArray() {
        if (this.transactions == null) {
            return null;
        }
        return this.transactions.toArray();
    }

    @Exported
    public String getKind() {
        return "accurev";
    }
}

