/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete.parser;

import com.smartbear.jenkins.plugins.testcomplete.Messages;
import com.smartbear.jenkins.plugins.testcomplete.TcLog;
import com.smartbear.jenkins.plugins.testcomplete.TcLogInfo;
import com.smartbear.jenkins.plugins.testcomplete.Utils;
import com.smartbear.jenkins.plugins.testcomplete.parser.ILogParser;
import com.smartbear.jenkins.plugins.testcomplete.parser.LogNodeUtils;
import com.smartbear.jenkins.plugins.testcomplete.parser.ParserSettings;
import com.smartbear.jenkins.plugins.testcomplete.parser.ParsingException;
import hudson.model.TaskListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogParser2
implements ILogParser {
    private static final String SUMMARY_ENTRY_NAME = "Summary.dat";
    private static final String DESCRIPTION_ENTRY_NAME = "Description.tcLog";
    private static final String START_TIME_PROPERTY_NAME = "start time";
    private static final String STOP_TIME_PROPERTY_NAME = "stop time";
    private static final String ERROR_COUNT_PROPERTY_NAME = "error count";
    private static final String WARNING_COUNT_PROPERTY_NAME = "warning count";
    private static final String UNEXPECTED_LOG_FORMAT = "Unexpected log format";
    private final ParserSettings context;
    private final int timezoneOffset;

    public LogParser2(ParserSettings context, int timezoneOffset) {
        this.context = context;
        this.timezoneOffset = timezoneOffset;
    }

    private boolean checkIncomplete(String status) {
        return "3".equals(status);
    }

    private boolean checkFail(String status) {
        if (this.context.errorOnWarnings()) {
            return !"0".equals(status);
        }
        return !"0".equals(status) && !"1".equals(status);
    }

    private String fixTestCaseName(String name) {
        return name.replace(" Log [", " [");
    }

    private TcLogInfo extractBaseLogInfo(ZipFile logArchive) throws ParsingException {
        int errorCount;
        int warningCount;
        long stopTime;
        Node descriptionTopLevelNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, DESCRIPTION_ENTRY_NAME);
        if (descriptionTopLevelNode == null) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        long startTime = Utils.safeConvertDate(LogNodeUtils.getTextProperty(descriptionTopLevelNode, START_TIME_PROPERTY_NAME));
        if (startTime > 0L) {
            startTime -= (long)this.timezoneOffset;
        }
        if ((stopTime = Utils.safeConvertDate(LogNodeUtils.getTextProperty(descriptionTopLevelNode, STOP_TIME_PROPERTY_NAME))) > 0L) {
            stopTime -= (long)this.timezoneOffset;
        }
        try {
            warningCount = Integer.parseInt(LogNodeUtils.getTextProperty(descriptionTopLevelNode, WARNING_COUNT_PROPERTY_NAME));
        }
        catch (NumberFormatException e) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        try {
            errorCount = Integer.parseInt(LogNodeUtils.getTextProperty(descriptionTopLevelNode, ERROR_COUNT_PROPERTY_NAME));
        }
        catch (NumberFormatException e) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        return new TcLogInfo(startTime, stopTime, 0, errorCount, warningCount);
    }

    private void convertSingleEntryToXML(ZipFile logArchive, TcLogInfo logInfo, XMLStreamWriter writer) throws ParsingException, XMLStreamException {
        writer.writeStartDocument("utf-8", "1.0");
        Node descriptionTopLevelNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, DESCRIPTION_ENTRY_NAME);
        if (descriptionTopLevelNode == null) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        Node topLevelNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, LogNodeUtils.getTextProperty(descriptionTopLevelNode, "root file name"));
        if (topLevelNode == null) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        NodeList rootNodes = topLevelNode.getChildNodes();
        Node rootOwnerNode = LogNodeUtils.findRootOwnerNode(rootNodes);
        if (rootOwnerNode == null) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        Node rootOwnerNodeInfo = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, LogNodeUtils.getTextProperty(rootOwnerNode, "filename"));
        if (rootOwnerNodeInfo == null) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        writer.writeStartElement("testsuites");
        String testCaseName = LogNodeUtils.getTextProperty(rootOwnerNode, "name");
        String testCaseDuration = Double.toString((float)logInfo.getTestDuration() / 1000.0f);
        writer.writeStartElement("testsuite");
        writer.writeAttribute("name", this.context.getProject());
        writer.writeAttribute("time", testCaseDuration);
        writer.writeStartElement("testcase");
        writer.writeAttribute("name", this.fixTestCaseName(testCaseName));
        writer.writeAttribute("classname", this.context.getSuite() + "." + this.context.getProject());
        writer.writeAttribute("time", testCaseDuration);
        if (this.checkFail(LogNodeUtils.getTextProperty(rootOwnerNode, "status"))) {
            writer.writeStartElement("failure");
            List<String> messages = LogNodeUtils.getErrorMessages(rootOwnerNodeInfo);
            if (this.context.errorOnWarnings()) {
                messages.addAll(LogNodeUtils.getWarningMessages(rootOwnerNodeInfo));
            }
            writer.writeAttribute("message", StringUtils.join(messages, (String)"\n\n"));
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void convertSummaryToXML(Node summaryNode, XMLStreamWriter writer) throws ParsingException, XMLStreamException {
        writer.writeStartDocument("utf-8", "1.0");
        writer.writeStartElement("testsuites");
        Node projectsNode = LogNodeUtils.findNamedNode(summaryNode, "projects");
        if (projectsNode == null) {
            throw new ParsingException(UNEXPECTED_LOG_FORMAT);
        }
        List<Node> projectNodes = LogNodeUtils.findChildNodes(projectsNode);
        for (Node projectNode : projectNodes) {
            String failedTests = LogNodeUtils.getTextProperty(projectNode, "failedtests");
            if (failedTests == null) {
                failedTests = Integer.toString(0);
            }
            String testProjectName = LogNodeUtils.getTextProperty(projectNode, "name");
            String testStartTime = LogNodeUtils.getTextProperty(projectNode, "starttime");
            Node testsNode = LogNodeUtils.findNamedNode(projectNode, "tests");
            if (testsNode == null) {
                throw new ParsingException(UNEXPECTED_LOG_FORMAT);
            }
            List<Node> testNodes = LogNodeUtils.findChildNodes(testsNode);
            String projectDurationMS = LogNodeUtils.getTextProperty(projectNode, "duration");
            String projectDuration = Double.toString((float)Integer.parseInt(projectDurationMS) / 1000.0f);
            writer.writeStartElement("testsuite");
            writer.writeAttribute("name", testProjectName);
            writer.writeAttribute("time", projectDuration);
            writer.writeAttribute("failures", failedTests);
            writer.writeAttribute("tests", Integer.toString(testNodes.size()));
            writer.writeAttribute("timestamp", LogNodeUtils.startTimeToTimestamp(testStartTime));
            for (Node testNode : testNodes) {
                String testName = LogNodeUtils.getTextProperty(testNode, "name");
                writer.writeStartElement("testcase");
                writer.writeAttribute("name", testName);
                writer.writeAttribute("classname", this.context.getSuite() + "." + testProjectName);
                String testDurationMS = LogNodeUtils.getTextProperty(testNode, "duration");
                String testDuration = Double.toString((float)Integer.parseInt(testDurationMS) / 1000.0f);
                writer.writeAttribute("time", testDuration);
                String testCaseStatus = LogNodeUtils.getTextProperty(testNode, "status");
                if (this.checkIncomplete(testCaseStatus)) {
                    writer.writeStartElement("skipped");
                    writer.writeEndElement();
                } else if (this.checkFail(testCaseStatus)) {
                    writer.writeStartElement("failure");
                    ArrayList<String> messages = new ArrayList<String>();
                    List<String> errors = LogNodeUtils.findChildMessages(testNode, "errors", "error");
                    messages.addAll(errors);
                    if (this.context.errorOnWarnings()) {
                        List<String> warnings = LogNodeUtils.findChildMessages(testNode, "warnings", "warning");
                        messages.addAll(warnings);
                    }
                    writer.writeAttribute("message", StringUtils.join(messages, (String)"\n\n"));
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TcLogInfo parse(TaskListener listener) {
        try {
            ZipFile logArchive = new ZipFile(this.context.getLog());
            TcLogInfo logInfo = this.extractBaseLogInfo(logArchive);
            String xml = null;
            if (this.context.generateJUnitReports()) {
                try (XMLStreamWriter xmlStreamWriter = null;){
                    Node summaryNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, SUMMARY_ENTRY_NAME);
                    StringWriter stringWriter = new StringWriter();
                    xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stringWriter);
                    if (summaryNode != null) {
                        this.convertSummaryToXML(summaryNode, xmlStreamWriter);
                    } else {
                        this.convertSingleEntryToXML(logArchive, logInfo, xmlStreamWriter);
                    }
                    xmlStreamWriter.flush();
                    xmlStreamWriter.close();
                    xmlStreamWriter = null;
                    xml = stringWriter.toString();
                }
            }
            logInfo.setXML(xml);
            return logInfo;
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            TcLog.error(listener, Messages.TcTestBuilder_ExceptionOccurred(), stringWriter.toString());
            return null;
        }
    }
}

