/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete.parser;

import com.smartbear.jenkins.plugins.testcomplete.Messages;
import com.smartbear.jenkins.plugins.testcomplete.TcLog;
import com.smartbear.jenkins.plugins.testcomplete.TcLogInfo;
import com.smartbear.jenkins.plugins.testcomplete.Utils;
import com.smartbear.jenkins.plugins.testcomplete.parser.ILogParser;
import com.smartbear.jenkins.plugins.testcomplete.parser.LogNodeUtils;
import com.smartbear.jenkins.plugins.testcomplete.parser.ParserSettings;
import com.smartbear.jenkins.plugins.testcomplete.parser.ParsingException;
import hudson.model.TaskListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.zip.ZipFile;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogParser
implements ILogParser {
    private static final String DESCRIPTION_ENTRY_NAME = "Description.tcLog";
    private static final String TEST_COUNT_PROPERTY_NAME = "test count";
    private static final String START_TIME_PROPERTY_NAME = "start time";
    private static final String STOP_TIME_PROPERTY_NAME = "stop time";
    private static final String ERROR_COUNT_PROPERTY_NAME = "error count";
    private static final String WARNING_COUNT_PROPERTY_NAME = "warning count";
    private final ParserSettings context;
    private final int timezoneOffset;

    public LogParser(ParserSettings context, int timezoneOffset) {
        this.context = context;
        this.timezoneOffset = timezoneOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TcLogInfo parse(TaskListener listener) {
        try {
            long stopTime;
            ZipFile logArchive = new ZipFile(this.context.getLog());
            Node descriptionTopLevelNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, DESCRIPTION_ENTRY_NAME);
            if (descriptionTopLevelNode == null) {
                throw new ParsingException("Unable to obtain description top-level node.");
            }
            long startTime = Utils.safeConvertDate(LogNodeUtils.getTextProperty(descriptionTopLevelNode, START_TIME_PROPERTY_NAME));
            if (startTime > 0L) {
                startTime -= (long)this.timezoneOffset;
            }
            if ((stopTime = Utils.safeConvertDate(LogNodeUtils.getTextProperty(descriptionTopLevelNode, STOP_TIME_PROPERTY_NAME))) > 0L) {
                stopTime -= (long)this.timezoneOffset;
            }
            int testCount = 0;
            try {
                testCount = Integer.parseInt(LogNodeUtils.getTextProperty(descriptionTopLevelNode, TEST_COUNT_PROPERTY_NAME));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int warningCount = 0;
            try {
                warningCount = Integer.parseInt(LogNodeUtils.getTextProperty(descriptionTopLevelNode, WARNING_COUNT_PROPERTY_NAME));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int errorCount = 0;
            try {
                errorCount = Integer.parseInt(LogNodeUtils.getTextProperty(descriptionTopLevelNode, ERROR_COUNT_PROPERTY_NAME));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            TcLogInfo logInfo = new TcLogInfo(startTime, stopTime, testCount, errorCount, warningCount);
            String xml = null;
            if (this.context.generateJUnitReports()) {
                try (XMLStreamWriter xmlStreamWriter = null;){
                    StringWriter stringWriter = new StringWriter();
                    xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stringWriter);
                    this.convertToXML(logArchive, logInfo, xmlStreamWriter);
                    xmlStreamWriter.flush();
                    xmlStreamWriter.close();
                    xmlStreamWriter = null;
                    xml = stringWriter.toString();
                }
            }
            logInfo.setXML(xml);
            return logInfo;
        }
        catch (Exception e) {
            TcLog.error(listener, Messages.TcTestBuilder_ExceptionOccurred(), e.toString());
            return null;
        }
    }

    private boolean checkFail(String status) {
        if (this.context.errorOnWarnings()) {
            return !"0".equals(status);
        }
        return !"0".equals(status) && !"1".equals(status);
    }

    private String fixTestCaseName(String name) {
        return name.replace(" Log [", " [");
    }

    private void convertToXML(ZipFile logArchive, TcLogInfo logInfo, XMLStreamWriter writer) throws ParsingException, XMLStreamException {
        writer.writeStartDocument("utf-8", "1.0");
        Node descriptionTopLevelNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, DESCRIPTION_ENTRY_NAME);
        if (descriptionTopLevelNode == null) {
            throw new ParsingException("Unable to obtain description top-level node.");
        }
        Node topLevelNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, LogNodeUtils.getTextProperty(descriptionTopLevelNode, "root file name"));
        if (topLevelNode == null) {
            throw new ParsingException("Unable to obtain root top-level node.");
        }
        NodeList rootNodes = topLevelNode.getChildNodes();
        Node rootOwnerNode = LogNodeUtils.findRootOwnerNode(rootNodes);
        if (rootOwnerNode == null) {
            throw new ParsingException("Unable to obtain root owner node.");
        }
        boolean isSuite = "{00000000-0000-0000-0000-000000000000}".equals(LogNodeUtils.getTextProperty(rootOwnerNode, "projectkey"));
        Node rootOwnerNodeInfo = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, LogNodeUtils.getTextProperty(rootOwnerNode, "filename"));
        if (rootOwnerNodeInfo == null) {
            throw new ParsingException("Unable to obtain root owner node info.");
        }
        Node rootOwnerNodeInfoSummary = LogNodeUtils.findNamedNode(rootOwnerNodeInfo.getChildNodes(), "summary");
        boolean isSuiteOrProject = rootOwnerNodeInfoSummary != null;
        writer.writeStartElement("testsuites");
        if (isSuite) {
            List<Node> projects = LogNodeUtils.findChildNodes(rootOwnerNode, rootOwnerNode.getParentNode().getChildNodes());
            for (Node projectNode : projects) {
                Node projectNodeInfo = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, LogNodeUtils.getTextProperty(projectNode, "filename"));
                Node projectNodeInfoSummary = LogNodeUtils.findNamedNode(projectNodeInfo, "summary");
                this.processProject(logArchive, projectNode, projectNodeInfoSummary, writer);
            }
        } else if (isSuiteOrProject) {
            this.processProject(logArchive, rootOwnerNode, rootOwnerNodeInfoSummary, writer);
        } else {
            String testCaseName = LogNodeUtils.getTextProperty(rootOwnerNode, "name");
            String testCaseDuration = Double.toString((float)logInfo.getTestDuration() / 1000.0f);
            writer.writeStartElement("testsuite");
            writer.writeAttribute("name", this.context.getProject());
            writer.writeAttribute("time", testCaseDuration);
            writer.writeStartElement("testcase");
            writer.writeAttribute("name", this.fixTestCaseName(testCaseName));
            writer.writeAttribute("classname", this.context.getSuite() + "." + this.context.getProject());
            writer.writeAttribute("time", testCaseDuration);
            if (this.checkFail(LogNodeUtils.getTextProperty(rootOwnerNode, "status"))) {
                writer.writeStartElement("failure");
                List<String> messages = LogNodeUtils.getErrorMessages(rootOwnerNodeInfo);
                if (this.context.errorOnWarnings()) {
                    messages.addAll(LogNodeUtils.getWarningMessages(rootOwnerNodeInfo));
                }
                writer.writeAttribute("message", StringUtils.join(messages, (String)"\n\n"));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void processItem(ZipFile logArchive, Node node, String projectName, XMLStreamWriter writer, String name) throws ParsingException, XMLStreamException {
        Node nodeInfo = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, LogNodeUtils.getTextProperty(node, "filename"));
        if (nodeInfo == null) {
            throw new ParsingException("Unable to obtain item node info.");
        }
        Node logDataRowNode = LogNodeUtils.findNamedNode(LogNodeUtils.findNamedNode(nodeInfo, "log data"), "row0");
        if (logDataRowNode == null) {
            throw new ParsingException("Unable to obtain log data->row0 node for item with name '" + name + "'.");
        }
        writer.writeStartElement("testcase");
        writer.writeAttribute("name", name);
        writer.writeAttribute("classname", this.context.getSuite() + "." + projectName);
        long startTime = Utils.safeConvertDate(LogNodeUtils.getTextProperty(logDataRowNode, START_TIME_PROPERTY_NAME));
        long endTime = Utils.safeConvertDate(LogNodeUtils.getTextProperty(logDataRowNode, "end time"));
        long duration = endTime - startTime > 0L ? endTime - startTime : 0L;
        writer.writeAttribute("time", Double.toString((float)duration / 1000.0f));
        if (this.checkFail(LogNodeUtils.getTextProperty(node, "status"))) {
            Node testDetailsNode = LogNodeUtils.getRootDocumentNodeFromArchive(logArchive, LogNodeUtils.getTextProperty(logDataRowNode, "details"));
            writer.writeStartElement("failure");
            List<String> messages = LogNodeUtils.getErrorMessages(testDetailsNode);
            if (this.context.errorOnWarnings()) {
                messages.addAll(LogNodeUtils.getWarningMessages(testDetailsNode));
            }
            writer.writeAttribute("message", StringUtils.join(messages, (String)"\n\n"));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void processProject(ZipFile logArchive, Node rootOwnerNode, Node rootOwnerNodeInfoSummary, XMLStreamWriter writer) throws ParsingException, XMLStreamException {
        List<Object> items;
        String totalTests = LogNodeUtils.getTextProperty(LogNodeUtils.findNamedNode(rootOwnerNodeInfoSummary.getChildNodes(), "total"), "total (sum)");
        String failedTests = LogNodeUtils.getTextProperty(LogNodeUtils.findNamedNode(rootOwnerNodeInfoSummary.getChildNodes(), "failed"), "total (sum)");
        long startDate = Utils.safeConvertDate(LogNodeUtils.getTextProperty(rootOwnerNodeInfoSummary, "start date"));
        long stopDate = Utils.safeConvertDate(LogNodeUtils.getTextProperty(rootOwnerNodeInfoSummary, "stop date"));
        long projectDuration = stopDate - startDate > 0L ? stopDate - startDate : 0L;
        String projectName = LogNodeUtils.getTextProperty(rootOwnerNodeInfoSummary, "test");
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(startDate);
        String timestamp = DatatypeConverter.printDateTime((Calendar)cal);
        String rootOwnerNodeFileName = LogNodeUtils.getTextProperty(rootOwnerNode, "filename");
        if (rootOwnerNodeFileName == null || rootOwnerNodeFileName.isEmpty()) {
            throw new ParsingException("Unable to obtain filename for project node.");
        }
        try {
            items = LogNodeUtils.findChildNodesRecursively(logArchive, rootOwnerNode, rootOwnerNode.getParentNode().getChildNodes(), "");
        }
        catch (Exception e) {
            items = new ArrayList();
        }
        writer.writeStartElement("testsuite");
        writer.writeAttribute("name", projectName);
        writer.writeAttribute("failures", failedTests);
        writer.writeAttribute("tests", totalTests);
        writer.writeAttribute("time", Double.toString((float)projectDuration / 1000.0f));
        writer.writeAttribute("timestamp", timestamp);
        for (LogNodeUtils.Pair pair : items) {
            this.processItem(logArchive, (Node)pair.getValue(), projectName, writer, (String)pair.getKey());
        }
        writer.writeEndElement();
    }
}

