/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete.parser;

import com.smartbear.jenkins.plugins.testcomplete.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class LogNodeUtils {
    LogNodeUtils() {
    }

    public static String getTextAttribute(Node node, String name) {
        Node attribute;
        if (node == null) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem(name)) != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    public static String getTextProperty(Node node, String propertyName) {
        if (node == null) {
            return null;
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nameAttribute;
            Node childNode = childNodes.item(i);
            if (!"Prp".equals(childNode.getNodeName()) || !propertyName.equals(nameAttribute = LogNodeUtils.getTextAttribute(childNode, "name"))) continue;
            return LogNodeUtils.getTextAttribute(childNode, "value");
        }
        return null;
    }

    public static List<String> getErrorMessages(Node node) {
        return LogNodeUtils.getMessages(node, "3");
    }

    public static List<String> getWarningMessages(Node node) {
        return LogNodeUtils.getMessages(node, "2");
    }

    public static List<String> getMessages(Node node, String status) {
        LinkedList<String> result = new LinkedList<String>();
        TreeMap<Integer, String> orderedResult = new TreeMap<Integer, String>();
        if (node == null) {
            return result;
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String message;
            String name;
            Node childNode = childNodes.item(i);
            if (!"Node".equals(childNode.getNodeName()) || (name = LogNodeUtils.getTextAttribute(childNode, "name")) == null || !name.startsWith("message")) continue;
            int index = 0;
            try {
                index = Integer.parseInt(name.replace("message", "").trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String type = LogNodeUtils.getTextProperty(childNode, "type");
            if (!status.equals(type) || (message = LogNodeUtils.getTextProperty(childNode, "message")) == null || message.isEmpty()) continue;
            orderedResult.put(index, message);
        }
        for (Map.Entry entry : orderedResult.entrySet()) {
            result.add((String)entry.getValue());
        }
        return result;
    }

    public static Node findRootOwnerNode(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            String ownerMoniker;
            Node node = nodes.item(i);
            String nodeName = LogNodeUtils.getTextAttribute(node, "name");
            if (!"item 0".equals(nodeName) || (ownerMoniker = LogNodeUtils.getTextProperty(node, "ownermoniker")) == null || !ownerMoniker.isEmpty()) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Node getRootDocumentNodeFromArchive(ZipFile archive, String name) {
        if (name == null) {
            return null;
        }
        ZipEntry rootLogDataEntry = archive.getEntry(name);
        if (rootLogDataEntry == null) {
            return null;
        }
        InputStream logDataStream = null;
        try {
            logDataStream = archive.getInputStream(rootLogDataEntry);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(logDataStream);
            Element element = document.getDocumentElement();
            if (!"1".equals(element.getAttribute("version"))) {
                Node node = null;
                return node;
            }
            NodeList list = element.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                String nodeName;
                Node item = list.item(i);
                NamedNodeMap attributes = item.getAttributes();
                if (attributes != null && attributes.getNamedItem("name") != null && "root".equals(nodeName = attributes.getNamedItem("name").getNodeValue())) {
                    Node node = item;
                    return node;
                }
                ++i;
            }
            return null;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            return null;
        }
        finally {
            if (logDataStream != null) {
                try {
                    logDataStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Node findNamedNode(NodeList nodes, String name) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String nodeName = LogNodeUtils.getTextAttribute(node, "name");
            if (!name.equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public static Node findNamedNode(Node node, String name) {
        if (node == null) {
            return null;
        }
        return LogNodeUtils.findNamedNode(node.getChildNodes(), name);
    }

    public static List<String> findChildMessages(Node containerNode, String listName, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        if (containerNode == null) {
            return result;
        }
        Node listNode = LogNodeUtils.findNamedNode(containerNode, listName);
        if (listNode == null) {
            return result;
        }
        List<Node> messageNodes = LogNodeUtils.findChildNodes(listNode);
        for (Node messageNode : messageNodes) {
            int index;
            String name = LogNodeUtils.getTextAttribute(messageNode, "name");
            if (name == null || !name.startsWith(prefix)) continue;
            name = name.substring(prefix.length());
            try {
                index = Integer.parseInt(name);
            }
            catch (NumberFormatException e) {
                continue;
            }
            String msg = LogNodeUtils.getTextProperty(messageNode, "msg");
            if (msg == null || (msg = msg.trim()).isEmpty()) continue;
            map.put(index, msg);
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            result.add((String)map.get(key));
        }
        return result;
    }

    public static List<Node> findChildNodes(Node root, NodeList nodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayList<String> childrenKeys = new ArrayList<String>();
        Node childNode = LogNodeUtils.findNamedNode(root.getChildNodes(), "children");
        if (childNode != null) {
            NodeList childNodeProperties = childNode.getChildNodes();
            for (int i = 0; i < childNodeProperties.getLength(); ++i) {
                Node childNodeProperty = childNodeProperties.item(i);
                String childKey = LogNodeUtils.getTextAttribute(childNodeProperty, "value");
                if (childKey == null || childKey.isEmpty()) continue;
                childrenKeys.add(childKey);
            }
        }
        for (String childKey : childrenKeys) {
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node node = nodes.item(j);
                String nodeMoniker = LogNodeUtils.getTextProperty(node, "moniker");
                if (!childKey.equals(nodeMoniker)) continue;
                result.add(node);
            }
        }
        return result;
    }

    public static List<Node> findChildNodes(Node parent) {
        NodeList children = parent.getChildNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!"Node".equals(children.item(i).getNodeName())) continue;
            result.add(0, children.item(i));
        }
        return result;
    }

    public static boolean isProjectItem(ZipFile archive, Node node) {
        String fileName = LogNodeUtils.getTextProperty(node, "filename");
        Node nodeInfo = LogNodeUtils.getRootDocumentNodeFromArchive(archive, fileName);
        Node logDataRowNode = LogNodeUtils.findNamedNode(nodeInfo, "status");
        return logDataRowNode == null;
    }

    public static List<Node> scanForSubItems(Node root, NodeList nodes) {
        ArrayList<String> childrenKeys = new ArrayList<String>();
        Node childNode = LogNodeUtils.findNamedNode(root.getChildNodes(), "children");
        if (childNode != null) {
            NodeList childNodeProperties = childNode.getChildNodes();
            for (int i = 0; i < childNodeProperties.getLength(); ++i) {
                Node childNodeProperty = childNodeProperties.item(i);
                String childKey = LogNodeUtils.getTextAttribute(childNodeProperty, "value");
                if (childKey == null || childKey.isEmpty()) continue;
                childrenKeys.add(childKey);
            }
        }
        ArrayList<Node> subItems = new ArrayList<Node>();
        for (String childKey : childrenKeys) {
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node node = nodes.item(j);
                String nodeMoniker = LogNodeUtils.getTextProperty(node, "moniker");
                if (!childKey.equals(nodeMoniker)) continue;
                subItems.add(node);
            }
        }
        return subItems;
    }

    public static boolean isTestItem(ZipFile archive, Node node, NodeList nodes) {
        List<Node> subItems = LogNodeUtils.scanForSubItems(node, nodes);
        for (Node subItem : subItems) {
            if (LogNodeUtils.isProjectItem(archive, subItem)) continue;
            return true;
        }
        return false;
    }

    public static List<Pair<String, Node>> findChildNodesRecursively(ZipFile archive, Node root, NodeList nodes, String nodeName) {
        List<Node> subItems = LogNodeUtils.scanForSubItems(root, nodes);
        ArrayList<Pair<String, Node>> result = new ArrayList<Pair<String, Node>>();
        if (subItems.isEmpty() && LogNodeUtils.isProjectItem(archive, root)) {
            return result;
        }
        for (Node node : subItems) {
            String subNodeName = LogNodeUtils.getTextProperty(node, "name");
            List<Pair<String, Node>> children = LogNodeUtils.findChildNodesRecursively(archive, node, nodes, "".equals(nodeName) ? subNodeName : nodeName + "/" + subNodeName);
            if (children != null && !children.isEmpty()) {
                result.addAll(children);
            }
            if (!LogNodeUtils.isProjectItem(archive, node) || !LogNodeUtils.isTestItem(archive, node, nodes)) continue;
            result.add(new Pair<String, Node>("".equals(nodeName) ? subNodeName : nodeName + "/" + subNodeName, node));
        }
        return result;
    }

    public static String startTimeToTimestamp(String startTime) {
        long startDate = Utils.safeConvertDate(startTime);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(startDate);
        return DatatypeConverter.printDateTime((Calendar)cal);
    }

    public static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

