/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import com.smartbear.jenkins.plugins.testcomplete.Messages;
import com.smartbear.jenkins.plugins.testcomplete.TcDynamicReportAction;
import com.smartbear.jenkins.plugins.testcomplete.TcReportAction;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class TcSummaryAction
implements Action {
    private final Run<?, ?> build;
    private LinkedHashMap<String, TcReportAction> reports = new LinkedHashMap();
    private ArrayList<TcReportAction> reportsOrder = new ArrayList();
    private final TcDynamicReportAction dynamic;

    TcSummaryAction(Run<?, ?> build) {
        this.build = build;
        String buildDir = build.getRootDir().getAbsolutePath();
        String reportsPath = buildDir + File.separator + "tcreports" + File.separator;
        this.dynamic = new TcDynamicReportAction(reportsPath);
    }

    public String getIconFileName() {
        return "/plugin/TestComplete/images/tc-48x48.png";
    }

    public String getDisplayName() {
        return Messages.TcSummaryAction_DisplayName();
    }

    public String getUrlName() {
        return "TestComplete";
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public void addReport(TcReportAction report) {
        if (!this.reports.containsValue(report)) {
            report.setParent(this);
            this.reports.put(report.getId(), report);
            this.reportsOrder.add(report);
        }
    }

    @Exported(name="reports", inline=true)
    public ArrayList<TcReportAction> getReportsOrder() {
        return this.reportsOrder;
    }

    public HashMap<String, TcReportAction> getReports() {
        return this.reports;
    }

    public TcReportAction getNextReport(TcReportAction report) {
        if (report == null || !this.reportsOrder.contains(report)) {
            return null;
        }
        int index = this.reportsOrder.indexOf(report);
        if (index + 1 >= this.reportsOrder.size()) {
            return null;
        }
        return this.reportsOrder.get(index + 1);
    }

    public TcReportAction getPreviousReport(TcReportAction report) {
        if (report == null || !this.reportsOrder.contains(report)) {
            return null;
        }
        int index = this.reportsOrder.indexOf(report);
        if (index <= 0) {
            return null;
        }
        return this.reportsOrder.get(index - 1);
    }

    public TcDynamicReportAction getDynamic() {
        return this.dynamic;
    }

    public String getPluginName() {
        return "TestComplete";
    }

    public Api getApi() {
        return new Api((Object)this);
    }
}

