/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class TcLogInfo
implements Serializable {
    private final long startTime;
    private final long stopTime;
    private final long testDuration;
    private final int testCount;
    private final int errorCount;
    private final int warningCount;
    private String XML = null;

    public TcLogInfo(long startTime, long stopTime, int testCount, int errorCount, int warningCount) {
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.testDuration = stopTime > startTime ? stopTime - startTime : 0L;
        this.testCount = testCount;
        this.errorCount = errorCount;
        this.warningCount = warningCount;
    }

    @Exported(name="timestamp")
    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    @Exported(name="duration")
    public long getTestDuration() {
        return this.testDuration;
    }

    public int getTestCount() {
        return this.testCount;
    }

    @Exported(name="errors")
    public int getErrorCount() {
        return this.errorCount;
    }

    @Exported(name="warnings")
    public int getWarningCount() {
        return this.warningCount;
    }

    public String formatStartTime() {
        Date date = new Date(this.startTime);
        return DateFormat.getDateTimeInstance().format(date);
    }

    public String formatStopTime() {
        Date date = new Date(this.stopTime);
        return DateFormat.getDateTimeInstance().format(date);
    }

    public String formatTestDuration() {
        long timeInSeconds = this.testDuration / 1000L;
        long s = timeInSeconds % 60L;
        long m = timeInSeconds / 60L % 60L;
        long h = timeInSeconds / 3600L;
        return String.format("%d:%02d:%02d", h, m, s);
    }

    public String getXML() {
        return this.XML;
    }

    public void setXML(String XML) {
        this.XML = XML;
    }
}

