/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import hudson.model.Action;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class TcDynamicReportAction
implements Action {
    private static final String DOWNLOAD_FILE_NAME = "Test";
    private final String baseReportsPath;
    private transient String basePathCache = null;

    TcDynamicReportAction(String baseReportsPath) {
        this.baseReportsPath = baseReportsPath;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String basePath;
        if (!req.getMethod().equals("GET")) {
            rsp.sendError(405);
            return;
        }
        String path = req.getRestOfPath();
        if (path.length() == 0 || path.contains("..")) {
            rsp.sendError(400);
            return;
        }
        String[] parts = (path = path.substring(1)).split("/");
        if (parts.length == 0) {
            rsp.sendError(400);
            return;
        }
        String ext = null;
        if (parts.length == 1 && parts[0].endsWith(".tclogx")) {
            ext = ".tclogx";
        } else if (parts.length == 1 && parts[0].endsWith(".mht")) {
            ext = ".mht";
        }
        if (this.basePathCache != null) {
            basePath = this.basePathCache;
        } else {
            this.basePathCache = basePath = this.recalculateBasePath(this.baseReportsPath);
        }
        if (ext != null) {
            File file = new File(basePath, parts[0]);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                rsp.sendError(404);
                return;
            }
            try (FileInputStream fis = null;){
                fis = new FileInputStream(file);
                rsp.setHeader("Content-Disposition", "filename=\"Test" + ext + "\"");
                rsp.serveFile(req, (InputStream)fis, file.lastModified(), 0L, file.length(), "mime-type:application/force-download");
            }
        } else {
            String archiveName = parts[0] + ".htmlx";
            File logFile = new File(basePath, archiveName);
            if (!logFile.exists() || !logFile.isFile()) {
                rsp.sendError(404);
                return;
            }
            String entryName = parts.length == 1 ? "index.htm" : path.substring(parts[0].length() + 1);
            ZipFile archive = null;
            InputStream inputStream = null;
            try {
                archive = new ZipFile(logFile);
                ZipEntry targetEntry = this.searchEntry(archive, entryName);
                if (targetEntry == null) {
                    rsp.sendError(404);
                    return;
                }
                inputStream = archive.getInputStream(targetEntry);
                rsp.serveFile(req, inputStream, targetEntry.getTime(), 0L, targetEntry.getSize(), targetEntry.getName());
            }
            catch (Exception e) {
                rsp.sendError(500);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (archive != null) {
                    archive.close();
                }
            }
        }
    }

    private ZipEntry searchEntry(ZipFile archive, String entryName) {
        ZipEntry targetEntry = archive.getEntry(entryName);
        if (targetEntry == null) {
            entryName = entryName.replace("/", "\\");
            targetEntry = archive.getEntry(entryName);
        }
        return targetEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String recalculateBasePath(String basePath) {
        File path = new File(basePath);
        if (path.exists()) return basePath;
        path = path.getParentFile();
        String oldDirectoryName = path.getName();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(path.getParentFile(), "legacyIds")));){
            String line;
            String[] parts;
            do {
                if ((line = br.readLine()) == null) return basePath;
            } while ((parts = line.split("( )")).length != 2 || !parts[0].equals(oldDirectoryName));
            File newPath = new File(path.getParentFile(), parts[1] + File.separatorChar + "tcreports");
            if (!newPath.exists()) return basePath;
            String string = newPath.getAbsolutePath();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return basePath;
    }
}

